/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.validation;

import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Logger;
import javax.validation.ValidationException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.FactoryInvoker;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.validation.ValidationProvider;

public abstract class AbstractValidationInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractValidationInterceptor.class);
    private Object serviceObject;
    private volatile ValidationProvider provider;

    public AbstractValidationInterceptor(String phase) {
        super(phase);
    }

    public void setServiceObject(Object object) {
        this.serviceObject = object;
    }

    public void setProvider(ValidationProvider provider) {
        this.provider = provider;
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        Object theServiceObject = this.getServiceObject(message);
        if (theServiceObject == null) {
            String error = "Service object is not available";
            LOG.severe(error);
            throw new ValidationException(error);
        }
        Method method = this.getServiceMethod(message);
        if (method == null) {
            String error = "Service method is not available";
            LOG.severe(error);
            throw new ValidationException(error);
        }
        MessageContentsList arguments = MessageContentsList.getContentsList(message);
        this.handleValidation(message, theServiceObject, method, arguments);
    }

    protected Object getServiceObject(Message message) {
        FactoryInvoker factoryInvoker;
        Invoker invoker;
        if (this.serviceObject != null) {
            return this.serviceObject;
        }
        Object current = message.getExchange().get("org.apache.cxf.service.object");
        if (current != null) {
            return current;
        }
        Endpoint e = message.getExchange().get(Endpoint.class);
        if (e != null && e.getService() != null && (invoker = e.getService().getInvoker()) instanceof FactoryInvoker && (factoryInvoker = (FactoryInvoker)invoker).isSingletonFactory()) {
            return factoryInvoker.getServiceObject(message.getExchange());
        }
        return null;
    }

    protected Method getServiceMethod(Message message) {
        BindingOperationInfo bop;
        Message inMessage = message.getExchange().getInMessage();
        Method method = (Method)inMessage.get("org.apache.cxf.resource.method");
        if (method == null && (bop = inMessage.getExchange().get(BindingOperationInfo.class)) != null) {
            MethodDispatcher md = (MethodDispatcher)inMessage.getExchange().get(Service.class).get(MethodDispatcher.class.getName());
            method = md.getMethod(bop);
        }
        return method;
    }

    protected abstract void handleValidation(Message var1, Object var2, Method var3, List<Object> var4);

    protected ValidationProvider getProvider(Message message) {
        if (this.provider == null) {
            Object prop = message.getContextualProperty(ValidationProvider.class.getName());
            this.provider = prop != null ? (ValidationProvider)prop : new ValidationProvider();
        }
        return this.provider;
    }
}

