/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.cors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.cxf.rs.security.cors.LocalPreflight;

@PreMatching
public class CrossOriginResourceSharingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Pattern SPACE_PATTERN = Pattern.compile(" ");
    private static final Pattern FIELD_COMMA_PATTERN = Pattern.compile(",");
    private static final String LOCAL_PREFLIGHT = "local_preflight";
    private static final String LOCAL_PREFLIGHT_ORIGIN = "local_preflight.origin";
    private static final String LOCAL_PREFLIGHT_METHOD = "local_preflight.method";
    private static final String PREFLIGHT_PASSED = "preflight_passed";
    private static final String PREFLIGHT_FAILED = "preflight_failed";
    private static final String SIMPLE_REQUEST = "simple_request";
    @Context
    private HttpHeaders headers;
    private List<String> allowOrigins = Collections.emptyList();
    private List<String> allowHeaders = Collections.emptyList();
    private boolean allowCredentials;
    private List<String> exposeHeaders = Collections.emptyList();
    private Integer maxAge;
    private Integer preflightFailStatus = 200;
    private boolean defaultOptionsMethodsHandlePreflight;
    private boolean findResourceMethod = true;

    private <T extends Annotation> T getAnnotation(Method m, Class<T> annClass) {
        if (m == null) {
            return null;
        }
        return ReflectionUtil.getAnnotationForMethodOrContainingClass(m, annClass);
    }

    public void filter(ContainerRequestContext context) {
        Message m = JAXRSUtils.getCurrentMessage();
        String httpMethod = (String)m.get("org.apache.cxf.request.method");
        if ("OPTIONS".equals(httpMethod)) {
            Response r = this.preflightRequest(m);
            if (r != null) {
                context.abortWith(r);
            }
        } else if (this.findResourceMethod) {
            Method method = this.findResourceMethod ? this.getResourceMethod(m, httpMethod) : null;
            this.simpleRequest(m, method);
        } else {
            m.getInterceptorChain().add(new CorsInInterceptor());
        }
    }

    private Response simpleRequest(Message m, Method resourceMethod) {
        CrossOriginResourceSharing ann = this.getAnnotation(resourceMethod, CrossOriginResourceSharing.class);
        List<String> values = this.getHeaderValues("Origin", true);
        if (values == null || values.size() == 0) {
            return null;
        }
        if (!this.effectiveAllowOrigins(ann, values)) {
            return null;
        }
        String originResponse = this.effectiveAllowAllOrigins(ann) ? "*" : this.concatValues(values, true);
        this.commonRequestProcessing(m, ann, originResponse);
        List<String> effectiveExposeHeaders = this.effectiveExposeHeaders(ann);
        if (effectiveExposeHeaders != null && effectiveExposeHeaders.size() != 0) {
            m.getExchange().put("Access-Control-Expose-Headers", effectiveExposeHeaders);
        }
        m.getExchange().put(CrossOriginResourceSharingFilter.class.getName(), SIMPLE_REQUEST);
        return null;
    }

    private Response preflightRequest(Message m) {
        Method optionsMethod;
        List<String> headerOriginValues = this.getHeaderValues("Origin", true);
        if (headerOriginValues == null || headerOriginValues.size() != 1) {
            return null;
        }
        String origin = headerOriginValues.get(0);
        List<String> requestMethodValues = this.getHeaderValues("Access-Control-Request-Method", false);
        if (requestMethodValues == null || requestMethodValues.size() != 1) {
            return this.createPreflightResponse(m, false);
        }
        String requestMethod = requestMethodValues.get(0);
        Method method = null;
        if (this.findResourceMethod && (method = this.getResourceMethod(m, requestMethod)) == null) {
            return null;
        }
        LocalPreflight preflightAnnotation = null;
        if (!this.defaultOptionsMethodsHandlePreflight && (optionsMethod = this.getResourceMethod(m, "OPTIONS")) != null) {
            preflightAnnotation = this.getAnnotation(optionsMethod, LocalPreflight.class);
        }
        if (preflightAnnotation != null || this.defaultOptionsMethodsHandlePreflight) {
            m.put(LOCAL_PREFLIGHT, "true");
            m.put(LOCAL_PREFLIGHT_ORIGIN, origin);
            m.put(LOCAL_PREFLIGHT_METHOD, method);
            return null;
        }
        CrossOriginResourceSharing ann = this.getAnnotation(method, CrossOriginResourceSharing.class);
        if (!this.effectiveAllowOrigins(ann, Collections.singletonList(origin))) {
            return this.createPreflightResponse(m, false);
        }
        List<String> requestHeaders = this.getHeaderValues("Access-Control-Request-Headers", false);
        if (!this.effectiveAllowHeaders(ann, requestHeaders)) {
            return this.createPreflightResponse(m, false);
        }
        String originResponse = this.effectiveAllowAllOrigins(ann) ? "*" : origin;
        m.getExchange().put("Access-Control-Allow-Methods", Arrays.asList(requestMethod));
        m.getExchange().put("Access-Control-Allow-Headers", requestHeaders);
        if (this.effectiveMaxAge(ann) != null) {
            m.getExchange().put("Access-Control-Max-Age", this.effectiveMaxAge(ann).toString());
        }
        this.commonRequestProcessing(m, ann, originResponse);
        return this.createPreflightResponse(m, true);
    }

    private Response createPreflightResponse(Message m, boolean passed) {
        m.getExchange().put(CrossOriginResourceSharingFilter.class.getName(), passed ? PREFLIGHT_PASSED : PREFLIGHT_FAILED);
        int status = passed ? 200 : this.preflightFailStatus;
        return Response.status((int)status).build();
    }

    private Method getResourceMethod(Message m, String httpMethod) {
        String requestUri = HttpUtils.getPathToMatch(m, true);
        List<ClassResourceInfo> resources = JAXRSUtils.getRootResources(m);
        Map<ClassResourceInfo, MultivaluedMap<String, String>> matchedResources = JAXRSUtils.selectResourceClass(resources, requestUri, m);
        if (matchedResources == null) {
            return null;
        }
        MetadataMap<String, String> values = new MetadataMap<String, String>();
        OperationResourceInfo ori = this.findPreflightMethod(matchedResources, requestUri, httpMethod, values, m);
        return ori == null ? null : ori.getAnnotatedMethod();
    }

    private OperationResourceInfo findPreflightMethod(Map<ClassResourceInfo, MultivaluedMap<String, String>> matchedResources, String requestUri, String httpMethod, MultivaluedMap<String, String> values, Message m) {
        String contentType = "*/*";
        MediaType acceptType = MediaType.WILDCARD_TYPE;
        OperationResourceInfo ori = JAXRSUtils.findTargetMethod(matchedResources, m, httpMethod, values, "*/*", Collections.singletonList(acceptType), false);
        if (ori == null) {
            return null;
        }
        if (ori.isSubResourceLocator()) {
            Class<?> cls = ori.getMethodToInvoke().getReturnType();
            ClassResourceInfo subcri = ori.getClassResourceInfo().getSubResource(cls, cls);
            if (subcri == null) {
                return null;
            }
            MetadataMap<String, String> newValues = new MetadataMap<String, String>();
            newValues.putAll((Map)values);
            return this.findPreflightMethod(Collections.singletonMap(subcri, newValues), (String)values.getFirst((Object)"FINAL_MATCH_GROUP"), httpMethod, newValues, m);
        }
        return ori;
    }

    private void commonRequestProcessing(Message m, CrossOriginResourceSharing ann, String origin) {
        m.getExchange().put("Origin", origin);
        m.getExchange().put("Access-Control-Allow-Credentials", this.effectiveAllowCredentials(ann));
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        Message m = JAXRSUtils.getCurrentMessage();
        String op = (String)m.getExchange().get(CrossOriginResourceSharingFilter.class.getName());
        if (op == null || op == PREFLIGHT_FAILED) {
            return;
        }
        responseContext.getHeaders().putSingle((Object)"Access-Control-Allow-Origin", m.getExchange().get("Origin"));
        responseContext.getHeaders().putSingle((Object)"Access-Control-Allow-Credentials", m.getExchange().get("Access-Control-Allow-Credentials"));
        if (SIMPLE_REQUEST.equals(op)) {
            List<String> effectiveExposeHeaders = this.getHeadersFromInput(m, "Access-Control-Expose-Headers");
            if (effectiveExposeHeaders != null) {
                this.addHeaders(responseContext, "Access-Control-Expose-Headers", effectiveExposeHeaders, false);
            }
        } else {
            String maValue = (String)m.getExchange().get("Access-Control-Max-Age");
            if (maValue != null) {
                responseContext.getHeaders().putSingle((Object)"Access-Control-Max-Age", (Object)maValue);
            }
            this.addHeaders(responseContext, "Access-Control-Allow-Methods", this.getHeadersFromInput(m, "Access-Control-Allow-Methods"), false);
            List<String> rqAllowedHeaders = this.getHeadersFromInput(m, "Access-Control-Allow-Headers");
            if (rqAllowedHeaders != null) {
                this.addHeaders(responseContext, "Access-Control-Allow-Headers", rqAllowedHeaders, false);
            }
        }
    }

    private boolean effectiveAllowAllOrigins(CrossOriginResourceSharing ann) {
        if (ann != null) {
            return ann.allowAllOrigins();
        }
        return this.allowOrigins.isEmpty();
    }

    private boolean effectiveAllowCredentials(CrossOriginResourceSharing ann) {
        if (ann != null) {
            return ann.allowCredentials();
        }
        return this.allowCredentials;
    }

    private boolean effectiveAllowOrigins(CrossOriginResourceSharing ann, List<String> origins) {
        if (this.effectiveAllowAllOrigins(ann)) {
            return true;
        }
        List<Object> actualOrigins = Collections.emptyList();
        if (ann != null) {
            actualOrigins = Arrays.asList(ann.allowOrigins());
        }
        if (actualOrigins.isEmpty()) {
            actualOrigins = this.allowOrigins;
        }
        return actualOrigins.containsAll(origins);
    }

    private boolean effectiveAllowAnyHeaders(CrossOriginResourceSharing ann) {
        if (ann != null) {
            return ann.allowHeaders().length == 0;
        }
        return this.allowHeaders.isEmpty();
    }

    private boolean effectiveAllowHeaders(CrossOriginResourceSharing ann, List<String> aHeaders) {
        if (this.effectiveAllowAnyHeaders(ann)) {
            return true;
        }
        List<String> actualHeaders = null;
        actualHeaders = ann != null ? Arrays.asList(ann.allowHeaders()) : this.allowHeaders;
        return actualHeaders.containsAll(aHeaders);
    }

    private List<String> effectiveExposeHeaders(CrossOriginResourceSharing ann) {
        List<String> actualExposeHeaders = null;
        actualExposeHeaders = ann != null ? Arrays.asList(ann.exposeHeaders()) : this.exposeHeaders;
        return actualExposeHeaders;
    }

    private Integer effectiveMaxAge(CrossOriginResourceSharing ann) {
        if (ann != null) {
            int ma = ann.maxAge();
            if (ma < 0) {
                return null;
            }
            return ma;
        }
        return this.maxAge;
    }

    private List<String> getHeadersFromInput(Message m, String key) {
        Object obj = m.getExchange().get(key);
        if (obj instanceof List) {
            return (List)obj;
        }
        return null;
    }

    private List<String> getHeaderValues(String key, boolean spaceSeparated) {
        List values = this.headers.getRequestHeader(key);
        Pattern splitPattern = spaceSeparated ? SPACE_PATTERN : FIELD_COMMA_PATTERN;
        ArrayList<String> results = new ArrayList<String>();
        if (values != null) {
            for (String value : values) {
                String[] items;
                for (String item : items = splitPattern.split(value)) {
                    results.add(item.trim());
                }
            }
        }
        return results;
    }

    private void addHeaders(ContainerResponseContext responseContext, String key, List<String> values, boolean spaceSeparated) {
        String sb = this.concatValues(values, spaceSeparated);
        responseContext.getHeaders().putSingle((Object)key, (Object)sb);
    }

    private String concatValues(List<String> values, boolean spaceSeparated) {
        StringBuffer sb = new StringBuffer();
        for (int x = 0; x < values.size(); ++x) {
            sb.append(values.get(x));
            if (x == values.size() - 1) continue;
            if (spaceSeparated) {
                sb.append(" ");
                continue;
            }
            sb.append(", ");
        }
        return sb.toString();
    }

    public void setAllowOrigins(List<String> allowedOrigins) {
        this.allowOrigins = allowedOrigins;
    }

    public List<String> getAllowOrigins() {
        return this.allowOrigins;
    }

    public List<String> getAllowHeaders() {
        return this.allowHeaders;
    }

    public void setAllowHeaders(List<String> allowedHeaders) {
        this.allowHeaders = allowedHeaders;
    }

    public List<String> getExposeHeaders() {
        return this.exposeHeaders;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public boolean isAllowCredentials() {
        return this.allowCredentials;
    }

    public void setAllowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public void setExposeHeaders(List<String> exposeHeaders) {
        this.exposeHeaders = exposeHeaders;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public void setPreflightErrorStatus(Integer status) {
        this.preflightFailStatus = status;
    }

    public void setDefaultOptionsMethodsHandlePreflight(boolean defaultOptionsMethodsHandlePreflight) {
        this.defaultOptionsMethodsHandlePreflight = defaultOptionsMethodsHandlePreflight;
    }

    public void setFindResourceMethod(boolean findResourceMethod) {
        this.findResourceMethod = findResourceMethod;
    }

    private class CorsInInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public CorsInInterceptor() {
            super("pre-invoke");
        }

        @Override
        public void handleMessage(Message message) {
            OperationResourceInfo ori = message.getExchange().get(OperationResourceInfo.class);
            CrossOriginResourceSharingFilter.this.simpleRequest(message, ori.getAnnotatedMethod());
        }
    }
}

