/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.WriterInterceptor;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Retryable;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InFaultChainInitiatorObserver;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.StaxInEndingInterceptor;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.ClientMessageObserver;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.FrontendClientAdapter;
import org.apache.cxf.jaxrs.client.spec.ClientRequestFilterInterceptor;
import org.apache.cxf.jaxrs.client.spec.ClientResponseFilterInterceptor;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.transport.MessageObserver;

public abstract class AbstractClient
implements Client {
    protected static final String REQUEST_CONTEXT = "RequestContext";
    protected static final String RESPONSE_CONTEXT = "ResponseContext";
    protected static final String KEEP_CONDUIT_ALIVE = "KeepConduitAlive";
    protected static final String HTTP_SCHEME = "http";
    private static final String PROXY_PROPERTY = "jaxrs.proxy";
    private static final String HEADER_SPLIT_PROPERTY = "org.apache.cxf.http.header.split";
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractClient.class);
    protected ClientConfiguration cfg = new ClientConfiguration();
    private ClientState state;

    protected AbstractClient(ClientState initialState) {
        this.state = initialState;
    }

    @Override
    public Client query(String name, Object ... values) {
        this.addMatrixQueryParamsToBuilder(this.getCurrentBuilder(), name, ParameterType.QUERY, values);
        return this;
    }

    @Override
    public Client header(String name, Object ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        if ("Content-Type".equals(name)) {
            if (values.length > 1) {
                throw new IllegalArgumentException("Content-Type can have a single value only");
            }
            this.type(this.convertParamValue(values[0]));
        } else {
            for (Object o : values) {
                this.possiblyAddHeader(name, this.convertParamValue(o));
            }
        }
        return this;
    }

    @Override
    public Client headers(MultivaluedMap<String, String> map) {
        this.state.getRequestHeaders().putAll(map);
        return this;
    }

    @Override
    public Client accept(MediaType ... types) {
        for (MediaType mt : types) {
            this.possiblyAddHeader("Accept", JAXRSUtils.mediaTypeToString(mt, new String[0]));
        }
        return this;
    }

    @Override
    public Client type(MediaType ct) {
        return this.type(JAXRSUtils.mediaTypeToString(ct, new String[0]));
    }

    @Override
    public Client type(String type) {
        this.state.getRequestHeaders().putSingle((Object)"Content-Type", (Object)type);
        return this;
    }

    @Override
    public Client accept(String ... types) {
        for (String type : types) {
            this.possiblyAddHeader("Accept", type);
        }
        return this;
    }

    @Override
    public Client cookie(Cookie cookie) {
        this.possiblyAddHeader("Cookie", cookie.toString());
        return this;
    }

    @Override
    public Client modified(Date date, boolean ifNot) {
        SimpleDateFormat dateFormat = HttpUtils.getHttpDateFormat();
        String hName = ifNot ? "If-Unmodified-Since" : "If-Modified-Since";
        this.state.getRequestHeaders().putSingle((Object)hName, (Object)dateFormat.format(date));
        return this;
    }

    @Override
    public Client language(String language) {
        this.state.getRequestHeaders().putSingle((Object)"Content-Language", (Object)language);
        return this;
    }

    @Override
    public Client match(EntityTag tag, boolean ifNot) {
        String hName = ifNot ? "If-None-Match" : "If-Match";
        this.state.getRequestHeaders().putSingle((Object)hName, (Object)tag.toString());
        return this;
    }

    @Override
    public Client acceptLanguage(String ... languages) {
        for (String s : languages) {
            this.possiblyAddHeader("Accept-Language", s);
        }
        return this;
    }

    @Override
    public Client acceptEncoding(String ... encs) {
        for (String s : encs) {
            this.possiblyAddHeader("Accept-Encoding", s);
        }
        return this;
    }

    @Override
    public Client encoding(String enc) {
        this.state.getRequestHeaders().putSingle((Object)"Content-Encoding", (Object)enc);
        return this;
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        MetadataMap<String, String> map = new MetadataMap<String, String>(false, true);
        map.putAll((Map)this.state.getRequestHeaders());
        return map;
    }

    @Override
    public URI getBaseURI() {
        return this.state.getBaseURI();
    }

    @Override
    public URI getCurrentURI() {
        return this.getCurrentBuilder().clone().buildFromEncoded(new Object[0]);
    }

    @Override
    public Response getResponse() {
        return this.state.getResponse();
    }

    @Override
    public Client reset() {
        this.state.reset();
        return this;
    }

    @Override
    public void close() {
        if (this.cfg.getBus() == null) {
            return;
        }
        ClientLifeCycleManager mgr = this.cfg.getBus().getExtension(ClientLifeCycleManager.class);
        if (null != mgr) {
            mgr.clientDestroyed(new FrontendClientAdapter(this.getConfiguration()));
        }
        if (this.cfg.getConduitSelector() instanceof Closeable) {
            try {
                ((Closeable)((Object)this.cfg.getConduitSelector())).close();
            }
            catch (IOException iOException) {}
        } else {
            this.cfg.getConduit().close();
        }
        this.state.reset();
        this.state = null;
        this.cfg = null;
    }

    private void possiblyAddHeader(String name, String value) {
        if (!this.isDuplicate(name, value)) {
            this.state.getRequestHeaders().add((Object)name, (Object)value);
        }
    }

    private boolean isDuplicate(String name, String value) {
        List values = (List)this.state.getRequestHeaders().get((Object)name);
        return values != null && values.contains(value);
    }

    protected ClientState getState() {
        return this.state;
    }

    protected UriBuilder getCurrentBuilder() {
        return this.state.getCurrentBuilder();
    }

    protected void resetResponse() {
        this.state.setResponse(null);
    }

    protected void resetBaseAddress(URI uri) {
        this.state.setBaseURI(uri);
        this.resetCurrentBuilder(uri);
    }

    protected void resetCurrentBuilder(URI uri) {
        this.state.setCurrentBuilder(new UriBuilderImpl(uri));
    }

    protected MultivaluedMap<String, String> getTemplateParametersMap(URITemplate template, List<Object> values) {
        if (values != null && values.size() != 0) {
            List<String> vars = template.getVariables();
            MetadataMap<String, String> templatesMap = new MetadataMap<String, String>(vars.size());
            for (int i = 0; i < vars.size(); ++i) {
                if (i >= values.size()) continue;
                templatesMap.add(vars.get(i), values.get(i).toString());
            }
            return templatesMap;
        }
        return null;
    }

    protected Response.ResponseBuilder setResponseBuilder(Message outMessage, Exchange exchange) throws Exception {
        Message responseMessage;
        Response response = exchange.get(Response.class);
        if (response != null) {
            outMessage.getExchange().getInMessage().put(Message.PROTOCOL_HEADERS, response.getStringHeaders());
            return JAXRSUtils.fromResponse(JAXRSUtils.copyResponseIfNeeded(response));
        }
        Integer status = AbstractClient.getResponseCode(exchange);
        Response.ResponseBuilder currentResponseBuilder = JAXRSUtils.toResponseBuilder(status);
        Message message = responseMessage = exchange.getInMessage() != null ? exchange.getInMessage() : exchange.getInFaultMessage();
        if (responseMessage == null) {
            return currentResponseBuilder;
        }
        Map protocolHeaders = CastUtils.cast((Map)responseMessage.get(Message.PROTOCOL_HEADERS));
        boolean splitHeaders = MessageUtils.isTrue(outMessage.getContextualProperty(HEADER_SPLIT_PROPERTY));
        for (Map.Entry entry : protocolHeaders.entrySet()) {
            if (null == entry.getKey() || ((List)entry.getValue()).size() <= 0) continue;
            if (HttpUtils.isDateRelatedHeader((String)entry.getKey())) {
                currentResponseBuilder.header((String)entry.getKey(), ((List)entry.getValue()).get(0));
                continue;
            }
            for (String val : (List)entry.getValue()) {
                if (splitHeaders) {
                    String[] values;
                    if (val == null || val.length() == 0) {
                        values = new String[]{""};
                    } else if (val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
                        values = this.parseQuotedHeaderValue(val);
                    } else {
                        String[] stringArray;
                        boolean splitPossible;
                        boolean bl = splitPossible = !"Set-Cookie".equalsIgnoreCase((String)entry.getKey()) || !val.toUpperCase().contains("Expires".toUpperCase());
                        if (splitPossible) {
                            stringArray = val.split(",");
                        } else {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = val;
                        }
                        values = stringArray;
                    }
                    for (String s : values) {
                        String theValue = s.trim();
                        if (theValue.length() <= 0) continue;
                        currentResponseBuilder.header((String)entry.getKey(), (Object)theValue);
                    }
                    continue;
                }
                currentResponseBuilder.header((String)entry.getKey(), (Object)val);
            }
        }
        String ct = (String)responseMessage.get("Content-Type");
        if (ct != null) {
            currentResponseBuilder.type(ct);
        }
        InputStream mStream = responseMessage.getContent(InputStream.class);
        currentResponseBuilder.entity((Object)mStream);
        return currentResponseBuilder;
    }

    protected <T> void writeBody(T o, Message outMessage, Class<?> cls, Type type, Annotation[] anns, OutputStream os) {
        if (o == null) {
            return;
        }
        MultivaluedMap headers = (MultivaluedMap)outMessage.get(Message.PROTOCOL_HEADERS);
        Class<?> theClass = cls;
        MediaType contentType = JAXRSUtils.toMediaType(headers.getFirst((Object)"Content-Type").toString());
        List<WriterInterceptor> writers = ClientProviderFactory.getInstance(outMessage).createMessageBodyWriterInterceptor(theClass, type, anns, contentType, outMessage, null);
        if (writers != null) {
            try {
                JAXRSUtils.writeMessageBody(writers, o, theClass, type, anns, contentType, (MultivaluedMap<String, Object>)headers, outMessage);
                OutputStream realOs = outMessage.get(OutputStream.class);
                if (realOs != null) {
                    realOs.flush();
                }
            }
            catch (Exception ex) {
                AbstractClient.reportMessageHandlerProblem("MSG_WRITER_PROBLEM", cls, contentType, ex);
            }
        } else {
            AbstractClient.reportMessageHandlerProblem("NO_MSG_WRITER", cls, contentType, null);
        }
    }

    protected WebApplicationException convertToWebApplicationException(Response r) {
        Class<?> exceptionClass = JAXRSUtils.getWebApplicationExceptionClass(r, WebApplicationException.class);
        try {
            Constructor<?> ctr = exceptionClass.getConstructor(Response.class);
            return (WebApplicationException)((Object)ctr.newInstance(r));
        }
        catch (Throwable ex2) {
            return new WebApplicationException(r);
        }
    }

    protected <T> T readBody(Response r, Message outMessage, Class<T> cls, Type type, Annotation[] anns) {
        if (cls == Response.class) {
            return cls.cast(r);
        }
        int status = r.getStatus();
        if ((status < 200 || status == 204) && r.getLength() <= 0 || status >= 300) {
            return null;
        }
        return ((ResponseImpl)r).doReadEntity(cls, type, anns);
    }

    protected boolean responseStreamCanBeClosed(Message outMessage, Class<?> cls) {
        return cls != InputStream.class && MessageUtils.isTrue(outMessage.getContextualProperty("response.stream.auto.close"));
    }

    protected void completeExchange(Object response, Exchange exchange, boolean proxy) {
        exchange.put(KEEP_CONDUIT_ALIVE, true);
        this.getConfiguration().getConduitSelector().complete(exchange);
        String s = (String)exchange.getOutMessage().get(Message.BASE_PATH);
        if (s != null && !this.state.getBaseURI().toString().equals(s)) {
            this.calculateNewRequestURI(URI.create(s), this.getCurrentURI(), proxy);
            return;
        }
        s = (String)exchange.getOutMessage().get("transport.retransmit.url");
        if (s != null && !this.state.getBaseURI().toString().equals(s)) {
            this.calculateNewRequestURI(URI.create(s), this.getCurrentURI(), proxy);
            return;
        }
    }

    protected Object[] preProcessResult(Message message) throws Exception {
        Exchange exchange = message.getExchange();
        Exception ex = message.getContent(Exception.class);
        if (ex != null) {
            this.getConfiguration().getConduitSelector().complete(exchange);
            this.checkClientException(message, ex);
        }
        this.checkClientException(message, message.getExchange().get(Exception.class));
        List result = message.getExchange().get(List.class);
        return result != null ? result.toArray() : null;
    }

    protected void checkClientException(Message outMessage, Exception ex) throws Exception {
        Exception actualEx = ex instanceof Fault ? ((Fault)ex).getCause() : ex;
        Integer responseCode = AbstractClient.getResponseCode(outMessage.getExchange());
        if (responseCode == null || actualEx instanceof IOException && outMessage.getExchange().get("client.redirect.exception") != null) {
            if (actualEx instanceof ProcessingException) {
                throw ex;
            }
            if (actualEx != null) {
                throw new ProcessingException((Throwable)actualEx);
            }
            if (!outMessage.getExchange().isOneWay() || this.cfg.isResponseExpectedForOneway()) {
                this.waitForResponseCode(outMessage.getExchange());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForResponseCode(Exchange exchange) {
        Exchange exchange2 = exchange;
        synchronized (exchange2) {
            if (AbstractClient.getResponseCode(exchange) == null) {
                try {
                    exchange.wait(this.cfg.getSynchronousTimeout());
                }
                catch (InterruptedException interruptedException) {}
            } else {
                return;
            }
        }
        if (AbstractClient.getResponseCode(exchange) == null) {
            throw new ProcessingException("Response timeout");
        }
    }

    private static Integer getResponseCode(Exchange exchange) {
        Integer responseCode = (Integer)exchange.get(Message.RESPONSE_CODE);
        if (responseCode == null && exchange.getInMessage() != null) {
            responseCode = (Integer)exchange.getInMessage().get(Message.RESPONSE_CODE);
        }
        return responseCode;
    }

    protected URI calculateNewRequestURI(Map<String, Object> reqContext) {
        URI newBaseURI = URI.create(reqContext.get(Message.ENDPOINT_ADDRESS).toString());
        URI requestURI = URI.create(reqContext.get("org.apache.cxf.request.uri").toString());
        return this.calculateNewRequestURI(newBaseURI, requestURI, MessageUtils.isTrue(reqContext.get(PROXY_PROPERTY)));
    }

    private URI calculateNewRequestURI(URI newBaseURI, URI requestURI, boolean proxy) {
        String baseURIPath = newBaseURI.getRawPath();
        String reqURIPath = requestURI.getRawPath();
        UriBuilder builder = new UriBuilderImpl().uri(newBaseURI);
        String basePath = reqURIPath.startsWith(baseURIPath) ? baseURIPath : this.getBaseURI().getRawPath();
        builder.path(reqURIPath.equals(basePath) ? "" : reqURIPath.substring(basePath.length()));
        String newQuery = newBaseURI.getRawQuery();
        if (newQuery == null) {
            builder.replaceQuery(requestURI.getRawQuery());
        } else {
            builder.replaceQuery(newQuery);
        }
        URI newRequestURI = builder.build(new Object[0]);
        this.resetBaseAddress(newBaseURI);
        URI current = proxy ? newBaseURI : newRequestURI;
        this.resetCurrentBuilder(current);
        return newRequestURI;
    }

    protected void doRunInterceptorChain(Message m) {
        try {
            m.getInterceptorChain().doIntercept(m);
        }
        catch (Exception ex) {
            m.setContent(Exception.class, ex);
        }
    }

    protected Object[] retryInvoke(BindingOperationInfo oi, Object[] params, Map<String, Object> context, Exchange exchange) throws Exception {
        try {
            Object body = params.length == 0 ? null : params[0];
            Map<String, Object> reqContext = CastUtils.cast((Map)context.get(REQUEST_CONTEXT));
            MultivaluedMap headers = (MultivaluedMap)reqContext.get(Message.PROTOCOL_HEADERS);
            URI newRequestURI = this.calculateNewRequestURI(reqContext);
            Object response = this.retryInvoke(newRequestURI, (MultivaluedMap<String, String>)headers, body, exchange, context);
            exchange.put(List.class, this.getContentsList(response));
            return new Object[]{response};
        }
        catch (Throwable t) {
            Exception ex = t instanceof Exception ? (Exception)t : new Exception(t);
            exchange.put(Exception.class, ex);
            return null;
        }
    }

    protected abstract Object retryInvoke(URI var1, MultivaluedMap<String, String> var2, Object var3, Exchange var4, Map<String, Object> var5) throws Throwable;

    protected void addMatrixQueryParamsToBuilder(UriBuilder ub, String paramName, ParameterType pt, Object ... pValues) {
        if (pt != ParameterType.MATRIX && pt != ParameterType.QUERY) {
            throw new IllegalArgumentException("This method currently deal with matrix and query parameters only");
        }
        if (!"".equals(paramName)) {
            if (pValues != null && pValues.length > 0) {
                for (Object pValue : pValues) {
                    if (InjectionUtils.isSupportedCollectionOrArray(pValue.getClass())) {
                        List<Object> c = pValue.getClass().isArray() ? Arrays.asList((Object[])pValue) : (List<Object>)pValue;
                        Iterator it = c.iterator();
                        while (it.hasNext()) {
                            this.convertMatrixOrQueryToBuilder(ub, paramName, it.next(), pt);
                        }
                        continue;
                    }
                    this.convertMatrixOrQueryToBuilder(ub, paramName, pValue, pt);
                }
            } else {
                this.addMatrixOrQueryToBuilder(ub, paramName, pt, pValues);
            }
        } else {
            Object pValue = pValues[0];
            MultivaluedMap<String, Object> values = InjectionUtils.extractValuesFromBean(pValue, "");
            for (Map.Entry entry : values.entrySet()) {
                for (Object v : (List)entry.getValue()) {
                    this.convertMatrixOrQueryToBuilder(ub, (String)entry.getKey(), v, pt);
                }
            }
        }
    }

    private void convertMatrixOrQueryToBuilder(UriBuilder ub, String paramName, Object pValue, ParameterType pt) {
        String convertedValue = this.convertParamValue(pValue);
        this.addMatrixOrQueryToBuilder(ub, paramName, pt, convertedValue);
    }

    private void addMatrixOrQueryToBuilder(UriBuilder ub, String paramName, ParameterType pt, Object ... pValue) {
        if (pt == ParameterType.MATRIX) {
            ub.matrixParam(paramName, pValue);
        } else {
            ub.queryParam(paramName, pValue);
        }
    }

    protected String convertParamValue(Object pValue) {
        ParamConverter<?> prov;
        if (pValue == null) {
            return null;
        }
        Class<?> pClass = pValue.getClass();
        if (pClass == String.class || pClass.isPrimitive()) {
            return pValue.toString();
        }
        ClientProviderFactory pf = ClientProviderFactory.getInstance(this.cfg.getBus());
        if (pf != null && (prov = pf.createParameterHandler(pClass)) != null) {
            return prov.toString(pValue);
        }
        return pValue.toString();
    }

    protected static void reportMessageHandlerProblem(String name, Class<?> cls, MediaType ct, Throwable cause) {
        String errorMessage = JAXRSUtils.logMessageHandlerProblem("NO_MSG_WRITER", cls, ct);
        throw new ProcessingException(errorMessage, cause);
    }

    protected static void setAllHeaders(MultivaluedMap<String, String> headers, HttpURLConnection conn) {
        for (Map.Entry entry : headers.entrySet()) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                String value = (String)((List)entry.getValue()).get(i);
                b.append(value);
                if (i + 1 >= ((List)entry.getValue()).size()) continue;
                b.append(',');
            }
            conn.setRequestProperty((String)entry.getKey(), b.toString());
        }
    }

    protected String[] parseQuotedHeaderValue(String originalValue) {
        ArrayList<String> results = new ArrayList<String>();
        char[] chars = originalValue.toCharArray();
        int lastIndex = chars.length - 1;
        boolean quote = false;
        StringBuilder sb = new StringBuilder();
        block5: for (int pos = 0; pos <= lastIndex; ++pos) {
            char c = chars[pos];
            if (pos == lastIndex) {
                sb.append(c);
                results.add(sb.toString());
                continue;
            }
            switch (c) {
                case '\"': {
                    sb.append(c);
                    quote = !quote;
                    continue block5;
                }
                case '\\': {
                    if (quote) {
                        if (++pos <= lastIndex) {
                            c = chars[pos];
                            sb.append(c);
                        }
                        if (pos != lastIndex) continue block5;
                        results.add(sb.toString());
                        continue block5;
                    }
                    sb.append(c);
                    continue block5;
                }
                case ',': {
                    if (quote) {
                        sb.append(c);
                        continue block5;
                    }
                    results.add(sb.toString());
                    sb = new StringBuilder();
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return results.toArray(new String[results.size()]);
    }

    protected ClientConfiguration getConfiguration() {
        return this.cfg;
    }

    protected void setConfiguration(ClientConfiguration config) {
        this.cfg = config;
    }

    protected void prepareConduitSelector(Message message, URI currentURI, boolean proxy) {
        try {
            this.cfg.prepareConduitSelector(message);
        }
        catch (Fault ex) {
            LOG.warning("Failure to prepare a message from conduit selector");
        }
        message.getExchange().put(ConduitSelector.class, this.cfg.getConduitSelector());
        message.getExchange().put(Service.class, this.cfg.getConduitSelector().getEndpoint().getService());
        String address = (String)message.get(Message.ENDPOINT_ADDRESS);
        if (address.startsWith(HTTP_SCHEME) && !address.equals(currentURI.toString())) {
            URI baseAddress = URI.create(address);
            currentURI = this.calculateNewRequestURI(baseAddress, currentURI, proxy);
            message.put(Message.ENDPOINT_ADDRESS, currentURI.toString());
            message.put("org.apache.cxf.request.uri", currentURI.toString());
        }
        message.put(Message.BASE_PATH, this.getBaseURI().toString());
    }

    protected static PhaseInterceptorChain setupOutInterceptorChain(ClientConfiguration cfg) {
        PhaseManager pm = cfg.getBus().getExtension(PhaseManager.class);
        List<Interceptor<? extends Message>> i1 = cfg.getBus().getOutInterceptors();
        List<Interceptor<? extends Message>> i2 = cfg.getOutInterceptors();
        List<Interceptor<? extends Message>> i3 = cfg.getConduitSelector().getEndpoint().getOutInterceptors();
        PhaseInterceptorChain chain = new PhaseChainCache().get(pm.getOutPhases(), i1, i2, i3);
        chain.add(new ClientRequestFilterInterceptor());
        return chain;
    }

    protected static PhaseInterceptorChain setupInInterceptorChain(ClientConfiguration cfg) {
        PhaseManager pm = cfg.getBus().getExtension(PhaseManager.class);
        List<Interceptor<? extends Message>> i1 = cfg.getBus().getInInterceptors();
        List<Interceptor<? extends Message>> i2 = cfg.getInInterceptors();
        List<Interceptor<? extends Message>> i3 = cfg.getConduitSelector().getEndpoint().getInInterceptors();
        PhaseInterceptorChain chain = new PhaseChainCache().get(pm.getInPhases(), i1, i2, i3);
        chain.add(new ClientResponseFilterInterceptor());
        return chain;
    }

    protected static MessageObserver setupInFaultObserver(final ClientConfiguration cfg) {
        if (!cfg.getInFaultInterceptors().isEmpty()) {
            return new InFaultChainInitiatorObserver(cfg.getBus()){

                @Override
                protected void initializeInterceptors(Exchange ex, PhaseInterceptorChain chain) {
                    chain.add(cfg.getInFaultInterceptors());
                }
            };
        }
        return null;
    }

    protected Message createMessage(Object body, String httpMethod, MultivaluedMap<String, String> headers, URI currentURI, Exchange exchange, Map<String, Object> invocationContext, boolean proxy) {
        Message m = this.cfg.getConduitSelector().getEndpoint().getBinding().createMessage();
        m.put("org.apache.cxf.client", Boolean.TRUE);
        m.put("org.apache.cxf.message.inbound", Boolean.FALSE);
        m.put("org.apache.cxf.request.method", httpMethod);
        m.put(Message.PROTOCOL_HEADERS, headers);
        if (currentURI.isAbsolute() && currentURI.getScheme().startsWith(HTTP_SCHEME)) {
            m.put(Message.ENDPOINT_ADDRESS, currentURI.toString());
        } else {
            m.put(Message.ENDPOINT_ADDRESS, this.state.getBaseURI().toString());
        }
        Object requestURIProperty = this.cfg.getRequestContext().get("org.apache.cxf.request.uri");
        if (requestURIProperty == null) {
            m.put("org.apache.cxf.request.uri", currentURI.toString());
        } else {
            m.put("org.apache.cxf.request.uri", requestURIProperty.toString());
        }
        m.put("Content-Type", headers.getFirst((Object)"Content-Type"));
        body = this.checkIfBodyEmpty(body);
        this.setEmptyRequestPropertyIfNeeded(m, body);
        m.setContent(List.class, this.getContentsList(body));
        m.put("jaxrs.template.parameters", this.getState().getTemplates());
        PhaseInterceptorChain chain = AbstractClient.setupOutInterceptorChain(this.cfg);
        chain.setFaultObserver(AbstractClient.setupInFaultObserver(this.cfg));
        m.setInterceptorChain(chain);
        exchange = this.createExchange(m, exchange);
        exchange.put("org.apache.cxf.rest.message", Boolean.TRUE);
        exchange.setOneWay("true".equals(headers.getFirst((Object)"OnewayRequest")));
        exchange.put(Retryable.class, new RetryableImpl());
        this.setContexts(m, exchange, invocationContext, proxy);
        this.prepareConduitSelector(m, currentURI, proxy);
        return m;
    }

    protected void setEmptyRequestPropertyIfNeeded(Message outMessage, Object body) {
        if (body == null) {
            outMessage.put("org.apache.cxf.empty.request", true);
        }
    }

    protected Object checkIfBodyEmpty(Object body) {
        if (body != null && (body.getClass() == String.class && ((String)body).length() == 0 || body.getClass() == Form.class && ((Form)body).asMap().isEmpty() || Map.class.isAssignableFrom(body.getClass()) && ((Map)body).isEmpty())) {
            body = null;
        }
        return body;
    }

    protected Map<String, Object> getRequestContext(Message outMessage) {
        Map invContext = CastUtils.cast((Map)outMessage.get("org.apache.cxf.invocation.context"));
        return CastUtils.cast((Map)invContext.get(REQUEST_CONTEXT));
    }

    protected List<?> getContentsList(Object body) {
        return body == null ? new MessageContentsList() : new MessageContentsList(body);
    }

    protected Exchange createExchange(Message m, Exchange exchange) {
        if (exchange == null) {
            exchange = new ExchangeImpl();
        }
        exchange.setSynchronous(true);
        exchange.setOutMessage(m);
        exchange.put(Bus.class, this.cfg.getBus());
        exchange.put(MessageObserver.class, new ClientMessageObserver(this.cfg));
        exchange.put(Endpoint.class, this.cfg.getConduitSelector().getEndpoint());
        exchange.put("org.apache.cxf.transport.no_io_exceptions", true);
        exchange.put(StaxInEndingInterceptor.STAX_IN_NOCLOSE, Boolean.TRUE);
        m.setExchange(exchange);
        return exchange;
    }

    protected void setContexts(Message message, Exchange exchange, Map<String, Object> context, boolean proxy) {
        Map reqContext = null;
        Map resContext = null;
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        reqContext = CastUtils.cast((Map)context.get(REQUEST_CONTEXT));
        resContext = CastUtils.cast((Map)context.get(RESPONSE_CONTEXT));
        if (reqContext == null) {
            reqContext = new HashMap<String, Object>(this.cfg.getRequestContext());
            context.put(REQUEST_CONTEXT, reqContext);
        }
        reqContext.put(Message.PROTOCOL_HEADERS, message.get(Message.PROTOCOL_HEADERS));
        reqContext.put("org.apache.cxf.request.uri", message.get("org.apache.cxf.request.uri"));
        reqContext.put(Message.ENDPOINT_ADDRESS, message.get(Message.ENDPOINT_ADDRESS));
        reqContext.put(PROXY_PROPERTY, proxy);
        if (resContext == null) {
            resContext = new HashMap();
            context.put(RESPONSE_CONTEXT, resContext);
        }
        message.put("org.apache.cxf.invocation.context", context);
        message.putAll(reqContext);
        exchange.putAll(reqContext);
    }

    protected void setPlainOperationNameProperty(Message outMessage, String name) {
        outMessage.getExchange().put("org.apache.cxf.resource.operation.name", name);
    }

    private class RetryableImpl
    implements Retryable {
        private RetryableImpl() {
        }

        @Override
        public Object[] invoke(BindingOperationInfo oi, Object[] params, Map<String, Object> context, Exchange exchange) throws Exception {
            return AbstractClient.this.retryInvoke(oi, params, context, exchange);
        }
    }

    protected abstract class AbstractBodyWriter
    extends AbstractOutDatabindingInterceptor {
        public AbstractBodyWriter() {
            super("write");
        }

        @Override
        public void handleMessage(Message outMessage) throws Fault {
            XMLStreamWriter writer;
            MessageContentsList objs = MessageContentsList.getContentsList(outMessage);
            if (objs == null || objs.size() == 0) {
                return;
            }
            OutputStream os = outMessage.getContent(OutputStream.class);
            if (os == null && (writer = outMessage.getContent(XMLStreamWriter.class)) == null) {
                return;
            }
            Object body = objs.get(0);
            Annotation[] customAnns = (Annotation[])outMessage.get(Annotation.class.getName());
            Type t = outMessage.get(Type.class);
            this.doWriteBody(outMessage, body, t, customAnns, os);
        }

        protected abstract void doWriteBody(Message var1, Object var2, Type var3, Annotation[] var4, OutputStream var5) throws Fault;
    }
}

