/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.continuations;

import java.util.Collection;
import org.apache.cxf.Bus;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.continuations.JMSContinuation;
import org.springframework.jms.listener.AbstractMessageListenerContainer;

public class JMSContinuationProvider
implements ContinuationProvider {
    private Bus bus;
    private Message inMessage;
    private MessageObserver incomingObserver;
    private Collection<JMSContinuation> continuations;
    private AbstractMessageListenerContainer jmsListener;
    private JMSConfiguration jmsConfig;

    public JMSContinuationProvider(Bus b, Message m, MessageObserver observer, Collection<JMSContinuation> cList, AbstractMessageListenerContainer jmsListener, JMSConfiguration jmsConfig) {
        this.bus = b;
        this.inMessage = m;
        this.incomingObserver = observer;
        this.continuations = cList;
        this.jmsListener = jmsListener;
        this.jmsConfig = jmsConfig;
    }

    @Override
    public Continuation getContinuation() {
        Message m = this.inMessage;
        if (m != null && m.getExchange() != null && m.getExchange().getInMessage() != null) {
            m = m.getExchange().getInMessage();
        }
        if (m == null || m.getExchange() == null || m.getExchange().isOneWay()) {
            return null;
        }
        JMSContinuation cw = m.get(JMSContinuation.class);
        if (cw == null) {
            cw = new JMSContinuation(this.bus, m, this.incomingObserver, this.continuations, this.jmsListener, this.jmsConfig);
            m.put(JMSContinuation.class, cw);
        }
        return cw;
    }
}

