/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.xml;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.ws.security.WSSConfig;
import org.w3c.dom.Document;

public abstract class AbstractXmlSecOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractXmlSecOutInterceptor.class);

    public AbstractXmlSecOutInterceptor() {
        super("write");
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        try {
            Document doc = this.getDomDocument(message);
            if (doc == null) {
                return;
            }
            Document finalDoc = this.processDocument(message, doc);
            message.setContent(List.class, new MessageContentsList(new DOMSource(finalDoc)));
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            LOG.warning(sw.toString());
            throw new Fault(new RuntimeException(ex.getMessage() + ", stacktrace: " + sw.toString()));
        }
    }

    protected abstract Document processDocument(Message var1, Document var2) throws Exception;

    private Object getRequestBody(Message message) {
        MessageContentsList objs = MessageContentsList.getContentsList(message);
        if (objs == null || objs.size() == 0) {
            return null;
        }
        return objs.get(0);
    }

    private Document getDomDocument(Message m) throws Exception {
        Object body = this.getRequestBody(m);
        if (body == null) {
            return null;
        }
        if (body instanceof Document) {
            return (Document)body;
        }
        if (body instanceof DOMSource) {
            return (Document)((DOMSource)body).getNode();
        }
        ProviderFactory pf = ProviderFactory.getInstance(m);
        MessageBodyWriter<?> providerObject = pf.createMessageBodyWriter(body.getClass(), body.getClass(), new Annotation[0], MediaType.APPLICATION_XML_TYPE, m);
        if (!(providerObject instanceof JAXBElementProvider)) {
            return null;
        }
        JAXBElementProvider provider = (JAXBElementProvider)providerObject;
        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
        m.setContent(XMLStreamWriter.class, writer);
        provider.writeTo(body, body.getClass(), new Annotation[0], MediaType.APPLICATION_XML_TYPE, (MultivaluedMap<String, Object>)((MultivaluedMap)m.get(Message.PROTOCOL_HEADERS)), null);
        return writer.getDocument();
    }

    static {
        WSSConfig.init();
    }
}

