/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.xml.XMLSource;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.staxutils.DepthExceededStaxException;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;

@Provider
@Produces(value={"application/xml", "application/*+xml", "text/xml"})
@Consumes(value={"application/xml", "application/*+xml", "text/xml", "text/html"})
public class SourceProvider<T>
extends AbstractConfigurableProvider
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    private static final String PREFERRED_FORMAT = "source-preferred-format";
    @Context
    private MessageContext context;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return Source.class.isAssignableFrom(type) || Document.class.isAssignableFrom(type);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return Source.class.isAssignableFrom(type) || XMLSource.class.isAssignableFrom(type) || Document.class.isAssignableFrom(type);
    }

    public T readFrom(Class<T> source, Type genericType, Annotation[] annotations, MediaType m, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        String s;
        Class<Object> theSource = source;
        if (theSource == Source.class && ("sax".equalsIgnoreCase(s = this.getPreferredSource()) || "cxf.stax".equalsIgnoreCase(s))) {
            theSource = SAXSource.class;
        }
        if (DOMSource.class.isAssignableFrom(theSource) || Document.class.isAssignableFrom(theSource)) {
            T t;
            boolean docRequired = Document.class.isAssignableFrom(theSource);
            XMLStreamReader reader = this.getReader(is);
            try {
                Document doc = StaxUtils.read(reader);
                t = source.cast(docRequired ? doc : new DOMSource(doc));
            }
            catch (DepthExceededStaxException e) {
                throw new WebApplicationException(413);
            }
            catch (Exception e) {
                IOException ioex = new IOException("Problem creating a Source object");
                ioex.setStackTrace(e.getStackTrace());
                throw ioex;
            }
            finally {
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {}
            }
            return t;
        }
        if (SAXSource.class.isAssignableFrom(theSource) || StaxSource.class.isAssignableFrom(theSource)) {
            return source.cast(new StaxSource(this.getReader(is)));
        }
        if (StreamSource.class.isAssignableFrom(theSource) || Source.class.isAssignableFrom(theSource)) {
            return source.cast(new StreamSource(this.getRealStream(is)));
        }
        if (XMLSource.class.isAssignableFrom(theSource)) {
            return source.cast(new XMLSource(this.getRealStream(is)));
        }
        throw new IOException("Unrecognized source");
    }

    protected XMLStreamReader getReader(InputStream is) {
        XMLStreamReader reader = this.getReaderFromMessage();
        return reader == null ? StaxUtils.createXMLStreamReader(is) : reader;
    }

    protected InputStream getRealStream(InputStream is) throws IOException {
        XMLStreamReader reader = this.getReaderFromMessage();
        return reader == null ? is : this.getStreamFromReader(reader);
    }

    private InputStream getStreamFromReader(XMLStreamReader input) throws IOException {
        CachedOutputStream out = new CachedOutputStream();
        try {
            StaxUtils.copy(input, (OutputStream)out);
            InputStream inputStream = out.getInputStream();
            return inputStream;
        }
        catch (XMLStreamException ex) {
            throw new IOException("XMLStreamException:" + ex.getMessage());
        }
        finally {
            out.close();
        }
    }

    protected XMLStreamReader getReaderFromMessage() {
        MessageContext mc = this.getContext();
        if (mc != null) {
            return mc.getContent(XMLStreamReader.class);
        }
        return null;
    }

    public void writeTo(T source, Class<?> clazz, Type genericType, Annotation[] annotations, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        String encoding = HttpUtils.getSetEncoding(mt, headers, "UTF-8");
        XMLStreamReader reader = source instanceof Source ? StaxUtils.createXMLStreamReader((Source)source) : StaxUtils.createXMLStreamReader((Document)source);
        XMLStreamWriter writer = StaxUtils.createXMLStreamWriter(os, encoding);
        try {
            StaxUtils.copy(reader, writer);
        }
        catch (XMLStreamException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (XMLStreamException e) {}
            try {
                writer.flush();
                writer.close();
            }
            catch (XMLStreamException e) {}
        }
    }

    public long getSize(T source, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    protected String getPreferredSource() {
        MessageContext mc = this.getContext();
        String source = null;
        if (mc != null) {
            source = (String)mc.getContextualProperty(PREFERRED_FORMAT);
        }
        return source != null ? source : "sax";
    }

    protected MessageContext getContext() {
        return this.context;
    }
}

