/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.util.Comparator;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.ext.ResourceComparator;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public class OperationResourceInfoComparator
implements Comparator<OperationResourceInfo> {
    private static final String HEAD_METHOD = "HEAD";
    private boolean headMethod;
    private Message message;
    private ResourceComparator rc;

    public OperationResourceInfoComparator(Message m, String method) {
        Object o;
        this.message = m;
        if (this.message != null && (o = m.getExchange().get(Endpoint.class).get("org.apache.cxf.jaxrs.comparator")) != null) {
            this.rc = (ResourceComparator)o;
        }
        this.headMethod = HEAD_METHOD.equals(method);
    }

    @Override
    public int compare(OperationResourceInfo e1, OperationResourceInfo e2) {
        int result;
        if (this.rc != null && (result = this.rc.compare(e1, e2, this.message)) != 0) {
            return result;
        }
        if (this.headMethod) {
            if (HEAD_METHOD.equals(e1.getHttpMethod())) {
                return -1;
            }
            if (HEAD_METHOD.equals(e2.getHttpMethod())) {
                return 1;
            }
        }
        if ((result = URITemplate.compareTemplates(e1.getURITemplate(), e2.getURITemplate())) == 0 && (e1.getHttpMethod() != null && e2.getHttpMethod() == null || e1.getHttpMethod() == null && e2.getHttpMethod() != null)) {
            return e1.getHttpMethod() != null ? -1 : 1;
        }
        if (result == 0) {
            result = JAXRSUtils.compareSortedMediaTypes(e1.getConsumeTypes(), e2.getConsumeTypes());
        }
        if (result == 0) {
            result = JAXRSUtils.compareSortedMediaTypes(e1.getProduceTypes(), e2.getProduceTypes());
        }
        return result;
    }
}

