/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.jsse;

import java.util.List;
import javax.net.ssl.SSLSocketFactory;
import org.apache.cxf.configuration.jsse.TLSParameterBase;

public class TLSClientParameters
extends TLSParameterBase {
    private boolean disableCNCheck;
    private SSLSocketFactory sslSocketFactory;
    private int sslCacheTimeout = 86400000;
    private boolean useHttpsURLConnectionDefaultSslSocketFactory;
    private boolean useHttpsURLConnectionDefaultHostnameVerifier;

    public void setDisableCNCheck(boolean disableCNCheck) {
        this.disableCNCheck = disableCNCheck;
    }

    public boolean isDisableCNCheck() {
        return this.disableCNCheck;
    }

    public final void setSSLSocketFactory(SSLSocketFactory factory) {
        this.sslSocketFactory = factory;
    }

    public final SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public int getSslCacheTimeout() {
        return this.sslCacheTimeout;
    }

    public void setSslCacheTimeout(int sslCacheTimeout) {
        this.sslCacheTimeout = sslCacheTimeout;
    }

    public boolean isUseHttpsURLConnectionDefaultSslSocketFactory() {
        return this.useHttpsURLConnectionDefaultSslSocketFactory;
    }

    public void setUseHttpsURLConnectionDefaultSslSocketFactory(boolean useHttpsURLConnectionDefaultSslSocketFactory) {
        this.useHttpsURLConnectionDefaultSslSocketFactory = useHttpsURLConnectionDefaultSslSocketFactory;
    }

    public boolean isUseHttpsURLConnectionDefaultHostnameVerifier() {
        return this.useHttpsURLConnectionDefaultHostnameVerifier;
    }

    public void setUseHttpsURLConnectionDefaultHostnameVerifier(boolean useHttpsURLConnectionDefaultHostnameVerifier) {
        this.useHttpsURLConnectionDefaultHostnameVerifier = useHttpsURLConnectionDefaultHostnameVerifier;
    }

    public int hashCode() {
        int hash = this.disableCNCheck ? 37 : 17;
        hash = this.hash(hash, this.sslCacheTimeout);
        hash = this.hash(hash, this.secureRandom);
        hash = this.hash(hash, this.protocol);
        hash = this.hash(hash, this.certAlias);
        hash = this.hash(hash, this.provider);
        for (String cs : this.ciphersuites) {
            hash = this.hash(hash, cs);
        }
        hash = this.hash(hash, this.keyManagers);
        hash = this.hash(hash, this.trustManagers);
        if (this.cipherSuiteFilters != null) {
            hash = this.hash(hash, this.cipherSuiteFilters.getInclude());
            hash = this.hash(hash, this.cipherSuiteFilters.getExclude());
        }
        if (this.certConstraints != null) {
            hash = this.hash(hash, this.certConstraints.getIssuerDNConstraints());
            hash = this.hash(hash, this.certConstraints.getSubjectDNConstraints());
        }
        return hash;
    }

    private int hash(int i, Object o) {
        if (o != null) {
            i = i * 37 + o.hashCode();
        }
        return i;
    }

    private int hash(int i, Object[] os) {
        if (os == null) {
            return i;
        }
        for (Object o : os) {
            i = this.hash(i, o);
        }
        return i;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TLSClientParameters) {
            TLSClientParameters that = (TLSClientParameters)o;
            boolean eq = this.disableCNCheck == that.disableCNCheck;
            eq |= this.sslCacheTimeout == that.sslCacheTimeout;
            eq |= this.secureRandom == that.secureRandom;
            eq |= TLSClientParameters.equals(this.certAlias, that.certAlias);
            eq |= TLSClientParameters.equals(this.protocol, that.protocol);
            eq |= TLSClientParameters.equals(this.provider, that.provider);
            eq |= TLSClientParameters.equals(this.ciphersuites, that.ciphersuites);
            eq |= TLSClientParameters.equals(this.keyManagers, that.keyManagers);
            eq |= TLSClientParameters.equals(this.trustManagers, that.trustManagers);
            if (this.cipherSuiteFilters != null) {
                if (that.cipherSuiteFilters != null) {
                    eq |= TLSClientParameters.equals(this.cipherSuiteFilters.getExclude(), that.cipherSuiteFilters.getExclude());
                    eq |= TLSClientParameters.equals(this.cipherSuiteFilters.getInclude(), that.cipherSuiteFilters.getInclude());
                } else {
                    eq = false;
                }
            } else {
                eq |= that.cipherSuiteFilters == null;
            }
            if (this.certConstraints != null) {
                if (that.certConstraints != null) {
                    eq |= TLSClientParameters.equals(this.certConstraints.getIssuerDNConstraints(), that.certConstraints.getIssuerDNConstraints());
                    eq |= TLSClientParameters.equals(this.certConstraints.getSubjectDNConstraints(), that.certConstraints.getSubjectDNConstraints());
                } else {
                    eq = false;
                }
            } else {
                eq |= that.certConstraints == null;
            }
            return eq;
        }
        return false;
    }

    private static boolean equals(List<?> obj1, List<?> obj2) {
        if (obj1.size() == obj2.size()) {
            for (int x = 0; x < obj1.size(); ++x) {
                if (TLSClientParameters.equals(obj1.get(x), obj2.get(x))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean equals(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    private static boolean equals(Object[] a1, Object[] a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 != null && a1.length == a2.length) {
            for (int i = 0; i < a1.length; ++i) {
                if (TLSClientParameters.equals(a1[i], a2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

