/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.cache;

import java.io.Closeable;
import java.io.Serializable;
import java.net.URL;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.ws.security.cache.EHCacheManagerHolder;
import org.apache.ws.security.cache.ReplayCache;

public class EHCacheReplayCache
implements ReplayCache,
Closeable,
BusLifeCycleListener {
    public static final long DEFAULT_TTL = 3600L;
    public static final long MAX_TTL = 43200L;
    private Ehcache cache;
    private CacheManager cacheManager;
    private Bus bus;
    private long ttl = 3600L;

    public EHCacheReplayCache(String key, Bus b, URL configFileURL) {
        this.bus = b;
        if (this.bus != null) {
            this.bus.getExtension(BusLifeCycleManager.class).registerLifeCycleListener(this);
        }
        this.cacheManager = EHCacheManagerHolder.getCacheManager(this.bus, configFileURL);
        CacheConfiguration cc = EHCacheManagerHolder.getCacheConfiguration(key, this.cacheManager);
        Cache newCache = new Cache(cc);
        this.cache = this.cacheManager.addCacheIfAbsent((Ehcache)newCache);
        this.ttl = cc.getTimeToLiveSeconds();
    }

    public void setTTL(long newTtl) {
        this.ttl = newTtl;
    }

    public long getTTL() {
        return this.ttl;
    }

    public void add(String identifier) {
        this.add(identifier, this.ttl);
    }

    public void add(String identifier, long timeToLive) {
        if (identifier == null || "".equals(identifier)) {
            return;
        }
        int parsedTTL = (int)timeToLive;
        if ((timeToLive != (long)parsedTTL || parsedTTL < 0 || (long)parsedTTL > 43200L) && this.ttl != (long)(parsedTTL = (int)this.ttl)) {
            parsedTTL = 3600;
        }
        Element element = new Element((Object)identifier, (Object)identifier, Boolean.valueOf(false), Integer.valueOf(parsedTTL), Integer.valueOf(parsedTTL));
        element.resetAccessStatistics();
        this.cache.put(element);
    }

    public boolean contains(String identifier) {
        Element element = this.cache.get((Serializable)((Object)identifier));
        if (element != null) {
            if (this.cache.isExpired(element)) {
                this.cache.remove((Serializable)((Object)identifier));
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void close() {
        if (this.cacheManager != null) {
            if (this.cache != null) {
                this.cacheManager.removeCache(this.cache.getName());
            }
            EHCacheManagerHolder.releaseCacheManger(this.cacheManager);
            this.cacheManager = null;
            this.cache = null;
            if (this.bus != null) {
                this.bus.getExtension(BusLifeCycleManager.class).unregisterLifeCycleListener(this);
            }
        }
    }

    @Override
    public void initComplete() {
    }

    @Override
    public void preShutdown() {
        this.close();
    }

    @Override
    public void postShutdown() {
        this.close();
    }
}

