/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.mac;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.rs.security.oauth2.tokens.mac.Nonce;

public class NonceHistory
implements Serializable {
    private static final long serialVersionUID = -6404833046910698956L;
    private final long requestTimeDelta;
    private final List<Nonce> nonceList = new ArrayList<Nonce>();

    public NonceHistory(long requestTimeDelta, Nonce nonce) {
        this.requestTimeDelta = requestTimeDelta;
        this.nonceList.add(nonce);
    }

    public void addNonce(Nonce nonce) {
        this.nonceList.add(nonce);
    }

    public long getRequestTimeDelta() {
        return this.requestTimeDelta;
    }

    public List<Nonce> getNonceList() {
        return this.nonceList;
    }

    public Collection<Nonce> findMatchingNonces(String nonceString, long ts) {
        ArrayList<Nonce> nonceMatches = new ArrayList<Nonce>();
        for (Nonce nonce : this.getNonceList()) {
            if (!nonce.getNonceString().equals(nonceString) || nonce.getTs() != ts) continue;
            nonceMatches.add(nonce);
        }
        return nonceMatches;
    }
}

