/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.utils;

import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;

public final class Base64UrlUtility {
    private static final Logger LOG = LogUtils.getL7dLogger(Base64UrlUtility.class);

    private Base64UrlUtility() {
    }

    public static byte[] decode(String encoded) throws Base64Exception {
        encoded = encoded.replace("-", "+").replace('_', '/');
        switch (encoded.length() % 4) {
            case 0: {
                break;
            }
            case 2: {
                encoded = encoded + "==";
                break;
            }
            case 3: {
                encoded = encoded + "=";
                break;
            }
            default: {
                throw new Base64Exception(new Message("BASE64_RUNTIME_EXCEPTION", LOG, new Object[0]));
            }
        }
        return Base64Utility.decode(encoded);
    }

    public static String encode(String str) {
        try {
            return Base64UrlUtility.encode(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String encode(byte[] id) {
        return Base64UrlUtility.encodeChunk(id, 0, id.length);
    }

    public static String encodeChunk(byte[] id, int offset, int length) {
        String encoded = new String(Base64Utility.encodeChunk(id, offset, length));
        return encoded.replace("+", "-").replace('/', '_').replace("=", "");
    }
}

