/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.assertion;

import java.util.List;
import org.apache.cxf.rs.security.saml.assertion.Claim;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Claims {
    private List<Claim> claims;
    private String realm;

    public Claims(List<Claim> claims) {
        this.claims = claims;
    }

    public Claims(List<Claim> claims, String realm) {
        this.claims = claims;
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    public List<Claim> getClaims() {
        return this.claims;
    }

    public Claim findClaimByFriendlyName(String friendlyName) {
        for (Claim c : this.claims) {
            if (!c.getFriendlyName().equals(friendlyName)) continue;
            return c;
        }
        return null;
    }

    public Claim findClaimByName(String name) {
        for (Claim c : this.claims) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public Claim findClaimByFormatAndName(String format, String name) {
        for (Claim c : this.claims) {
            if (!c.getName().equals(name) || !c.getNameFormat().equals(format)) continue;
            return c;
        }
        return null;
    }
}

