/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common.idltypes;

import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class CorbaUtils {
    protected static final Set<String> IDL_RESERVED_WORDS = new TreeSet<String>();
    protected static final Set<String> IGNORED_MODULES = new TreeSet<String>();
    protected static final Set<String> TIMEBASE_IDL_DEFS = new TreeSet<String>();

    protected CorbaUtils() {
    }

    public static String mangleName(String cname) {
        while (CorbaUtils.isCollideWithKeyWord(cname)) {
            cname = "_" + cname;
        }
        if (cname.indexOf("..") != -1) {
            cname = cname.replace('.', '_');
        } else if (cname.indexOf("$") != -1) {
            cname = cname.replace('$', '_');
        } else if (cname.indexOf("?") != -1) {
            if (cname.length() == 1) {
                cname = "u0063";
            } else {
                StringTokenizer tokenizer = new StringTokenizer(cname, "?");
                String str = "";
                while (tokenizer.hasMoreTokens()) {
                    String s = tokenizer.nextToken();
                    str = s + "u0063";
                }
                cname = str;
            }
        } else if (cname.indexOf("-") != -1) {
            cname = cname.replace('-', '_');
        } else if (cname.indexOf("/") != -1) {
            cname = cname.replace('/', '_');
        }
        return cname;
    }

    public static String mangleEnumIdentifier(String identifier) {
        String value = CorbaUtils.mangleName(identifier);
        value = value.replace(' ', '_');
        if ((value = value.replace('.', '_')).indexOf(":") != -1) {
            value = value.substring(value.lastIndexOf(":") + 1);
        }
        String fletter = value.substring(0, 1);
        try {
            Integer.parseInt(fletter);
            value = "e_" + value;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (value.startsWith("__")) {
            value = value.substring(1);
        }
        return value;
    }

    public static boolean isReservedWord(String name) {
        return IDL_RESERVED_WORDS.contains(name);
    }

    public static boolean isCollideWithKeyWord(String name) {
        for (String key : IDL_RESERVED_WORDS) {
            if (!key.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTimeBaseDef(String name) {
        return TIMEBASE_IDL_DEFS.contains(name);
    }

    public static boolean ignoreModule(String name) {
        return IGNORED_MODULES.contains(name);
    }

    static {
        IDL_RESERVED_WORDS.add("abstract");
        IDL_RESERVED_WORDS.add("double");
        IDL_RESERVED_WORDS.add("local");
        IDL_RESERVED_WORDS.add("raises");
        IDL_RESERVED_WORDS.add("typedef");
        IDL_RESERVED_WORDS.add("any");
        IDL_RESERVED_WORDS.add("exception");
        IDL_RESERVED_WORDS.add("long");
        IDL_RESERVED_WORDS.add("readonly");
        IDL_RESERVED_WORDS.add("unsigned");
        IDL_RESERVED_WORDS.add("attribute");
        IDL_RESERVED_WORDS.add("enum");
        IDL_RESERVED_WORDS.add("module");
        IDL_RESERVED_WORDS.add("sequence");
        IDL_RESERVED_WORDS.add("union");
        IDL_RESERVED_WORDS.add("boolean");
        IDL_RESERVED_WORDS.add("factory");
        IDL_RESERVED_WORDS.add("native");
        IDL_RESERVED_WORDS.add("short");
        IDL_RESERVED_WORDS.add("ValueBase");
        IDL_RESERVED_WORDS.add("case");
        IDL_RESERVED_WORDS.add("FALSE");
        IDL_RESERVED_WORDS.add("Object");
        IDL_RESERVED_WORDS.add("string");
        IDL_RESERVED_WORDS.add("valuetype");
        IDL_RESERVED_WORDS.add("char");
        IDL_RESERVED_WORDS.add("fixed");
        IDL_RESERVED_WORDS.add("octet");
        IDL_RESERVED_WORDS.add("struct");
        IDL_RESERVED_WORDS.add("void");
        IDL_RESERVED_WORDS.add("const");
        IDL_RESERVED_WORDS.add("float");
        IDL_RESERVED_WORDS.add("oneway");
        IDL_RESERVED_WORDS.add("supports");
        IDL_RESERVED_WORDS.add("wchar");
        IDL_RESERVED_WORDS.add("context");
        IDL_RESERVED_WORDS.add("in");
        IDL_RESERVED_WORDS.add("out");
        IDL_RESERVED_WORDS.add("switch");
        IDL_RESERVED_WORDS.add("wstring");
        IDL_RESERVED_WORDS.add("custom");
        IDL_RESERVED_WORDS.add("inout");
        IDL_RESERVED_WORDS.add("private");
        IDL_RESERVED_WORDS.add("TRUE");
        IDL_RESERVED_WORDS.add("default");
        IDL_RESERVED_WORDS.add("interface");
        IDL_RESERVED_WORDS.add("public");
        IDL_RESERVED_WORDS.add("truncatable");
        IGNORED_MODULES.add("TimeBase");
    }
}

