/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.SamlToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamlTokenBuilder
implements AssertionBuilder<Element> {
    PolicyBuilder builder;

    public SamlTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        SamlToken samlToken = new SamlToken(consts);
        samlToken.setOptional(PolicyConstants.isOptional(element));
        samlToken.setIgnorable(PolicyConstants.isIgnorable(element));
        String attribute = element.getAttributeNS(element.getNamespaceURI(), "IncludeToken");
        if (attribute != null) {
            samlToken.setInclusion(consts.getInclusionFromAttributeValue(attribute));
        }
        Element child = DOMUtils.getFirstElement(element);
        boolean foundPolicy = false;
        while (child != null) {
            String ln = child.getLocalName();
            if ("Policy".equals(ln)) {
                foundPolicy = true;
                NodeList policyChildren = child.getChildNodes();
                if (policyChildren != null) {
                    for (int i = 0; i < policyChildren.getLength(); ++i) {
                        Node policyChild = policyChildren.item(i);
                        if (!(policyChild instanceof Element)) continue;
                        QName qname = new QName(policyChild.getNamespaceURI(), policyChild.getLocalName());
                        String localname = qname.getLocalPart();
                        if ("WssSamlV11Token10".equals(localname)) {
                            samlToken.setUseSamlVersion11Profile10(true);
                            continue;
                        }
                        if ("WssSamlV11Token11".equals(localname)) {
                            samlToken.setUseSamlVersion11Profile11(true);
                            continue;
                        }
                        if ("WssSamlV20Token11".equals(localname)) {
                            samlToken.setUseSamlVersion20Profile11(true);
                            continue;
                        }
                        if ("RequireDerivedKeys".equals(localname)) {
                            samlToken.setDerivedKeys(true);
                            continue;
                        }
                        if ("RequireExplicitDerivedKeys".equals(localname)) {
                            samlToken.setExplicitDerivedKeys(true);
                            continue;
                        }
                        if ("RequireImpliedDerivedKeys".equals(localname)) {
                            samlToken.setImpliedDerivedKeys(true);
                            continue;
                        }
                        if (!"RequireKeyIdentifierReference".equals(localname)) continue;
                        samlToken.setRequireKeyIdentifierReference(true);
                    }
                }
            }
            child = DOMUtils.getNextElement(child);
        }
        if (!foundPolicy && consts != SP11Constants.INSTANCE) {
            throw new IllegalArgumentException("sp:SpnegoContextToken/wsp:Policy must have a value");
        }
        return samlToken;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.SAML_TOKEN, SP12Constants.SAML_TOKEN};
    }
}

