/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.misc;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.tools.common.AbstractCXFToolContainer;
import org.apache.cxf.tools.common.CommandInterfaceUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolRunner;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.CommandDocument;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.misc.processor.WSDLToXMLProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLToXML
extends AbstractCXFToolContainer {
    static final String TOOL_NAME = "wsdl2xml";
    static final String BINDING_NAME_POSFIX = "_XMLBinding";
    static final String SERVICE_NAME_POSFIX = "_XMLService";
    static final String PORT_NAME_POSFIX = "_XMLPort";

    public WSDLToXML(ToolSpec toolspec) throws Exception {
        super(TOOL_NAME, toolspec);
    }

    private Set<String> getArrayKeys() {
        return new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(boolean exitOnFinish) {
        WSDLToXMLProcessor processor = new WSDLToXMLProcessor();
        try {
            super.execute(exitOnFinish);
            if (!this.hasInfoOption()) {
                ToolContext env = new ToolContext();
                env.setParameters(this.getParametersMap(this.getArrayKeys()));
                if (this.isVerboseOn()) {
                    env.put("verbose", Boolean.TRUE);
                }
                env.put("args", this.getArgument());
                this.validate(env);
                this.setEnvParamDefValues(env);
                processor.setEnvironment(env);
                processor.process();
            }
        }
        catch (ToolException ex) {
            if (ex.getCause() instanceof BadUsageException) {
                this.printUsageException(TOOL_NAME, (BadUsageException)ex.getCause());
            }
            this.err.println();
            this.err.println("WSDLToXML Error: " + ex.getMessage());
            if (this.isVerboseOn()) {
                ex.printStackTrace(this.err);
            }
        }
        catch (Exception ex) {
            this.err.println();
            this.err.println("WSDLToXML Error: " + ex.getMessage());
            if (this.isVerboseOn()) {
                ex.printStackTrace(this.err);
            }
        }
        finally {
            this.tearDown();
        }
    }

    private void setEnvParamDefValues(ToolContext env) {
        if (!env.optionSet("binding")) {
            env.put("binding", env.get("porttype") + BINDING_NAME_POSFIX);
        }
        if (!env.optionSet("service")) {
            env.put("service", env.get("porttype") + SERVICE_NAME_POSFIX);
        }
        if (!env.optionSet("port")) {
            env.put("port", env.get("porttype") + PORT_NAME_POSFIX);
        }
    }

    private void validate(ToolContext env) throws ToolException {
        String outdir = (String)env.get("outputdir");
        if (outdir != null) {
            File dir = new File(outdir);
            if (!dir.exists() && !dir.mkdirs()) {
                Message msg = new Message("DIRECTORY_COULD_NOT_BE_CREATED", LOG, outdir);
                throw new ToolException(msg);
            }
            if (!dir.isDirectory()) {
                Message msg = new Message("NOT_A_DIRECTORY", LOG, outdir);
                throw new ToolException(msg);
            }
        }
    }

    public static void main(String[] pargs) {
        CommandInterfaceUtils.commandCommonMain();
        try {
            ToolRunner.runTool(WSDLToXML.class, WSDLToXML.class.getResourceAsStream("wsdl2xml.xml"), false, pargs);
        }
        catch (Exception ex) {
            System.err.println("Error : " + ex.getMessage());
            System.err.println();
            ex.printStackTrace();
        }
    }

    @Override
    public void checkParams(ErrorVisitor errors) throws ToolException {
        CommandDocument doc = super.getCommandDocument();
        if (!doc.hasParameter("wsdlurl")) {
            errors.add(new ErrorVisitor.UserError("WSDL/SCHEMA URL has to be specified"));
        }
        if (errors.getErrors().size() > 0) {
            Message msg = new Message("PARAMETER_MISSING", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)new BadUsageException(this.getUsage(), errors));
        }
    }
}

