/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.cxf.security.LoginSecurityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSecurityContext
implements LoginSecurityContext {
    private Principal p;
    private Subject subject;

    public DefaultSecurityContext(Subject subject) {
        this.p = DefaultSecurityContext.findPrincipal(subject);
        this.subject = subject;
    }

    public DefaultSecurityContext(Principal p, Subject subject) {
        this.p = p;
        this.subject = subject;
    }

    private static Principal findPrincipal(Subject subject) {
        if (subject != null) {
            for (Principal principal : subject.getPrincipals()) {
                if (principal instanceof Group) continue;
                return principal;
            }
        }
        return null;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.p;
    }

    @Override
    public boolean isUserInRole(String role) {
        if (this.subject != null) {
            for (Principal principal : this.subject.getPrincipals()) {
                if (principal instanceof Group && this.checkGroup((Group)principal, role)) {
                    return true;
                }
                if (this.p == principal || !role.equals(principal.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkGroup(Group group, String role) {
        if (group.getName().equals(role)) {
            return true;
        }
        Enumeration members = group.members();
        while (members.hasMoreElements()) {
            Principal member = (Principal)members.nextElement();
            if (!member.getName().equals(role) && (!(member instanceof Group) || !this.checkGroup((Group)member, role))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public Set<Principal> getUserRoles() {
        HashSet<Principal> roles = new HashSet<Principal>();
        if (this.subject != null) {
            for (Principal principal : this.subject.getPrincipals()) {
                if (principal == this.p) continue;
                roles.add(principal);
            }
        }
        return roles;
    }
}

