/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.xml.stax;

import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.xml.AbstractMessageWriter;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.aegis.xml.stax.AttributeWriter;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.staxutils.StaxUtils;

public class ElementWriter
extends AbstractMessageWriter
implements MessageWriter {
    private XMLStreamWriter writer;
    private String namespace;
    private String name;
    private String prefix;

    public ElementWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public ElementWriter(XMLStreamWriter writer, String name, String namespace) {
        this(writer, name, namespace, null);
    }

    public ElementWriter(XMLStreamWriter streamWriter, QName name) {
        this(streamWriter, name.getLocalPart(), name.getNamespaceURI());
    }

    public ElementWriter(XMLStreamWriter writer, String name, String namespace, String prefix) {
        this.writer = writer;
        this.namespace = namespace;
        this.name = name;
        this.prefix = prefix;
        try {
            this.writeStartElement();
        }
        catch (XMLStreamException e) {
            throw new DatabindingException("Error writing document.", (Throwable)e);
        }
    }

    public ElementWriter(OutputStream os, String name, String namespace) throws XMLStreamException {
        XMLOutputFactory ofactory = XMLOutputFactory.newInstance();
        this.writer = ofactory.createXMLStreamWriter(os);
        this.namespace = namespace;
        this.name = name;
        try {
            this.writeStartElement();
        }
        catch (XMLStreamException e) {
            throw new DatabindingException("Error writing document.", (Throwable)e);
        }
    }

    private void writeStartElement() throws XMLStreamException {
        if (!StringUtils.isEmpty(this.namespace)) {
            boolean declare = false;
            String decPrefix = this.writer.getNamespaceContext().getPrefix(this.namespace);
            if (StringUtils.isEmpty(this.prefix) && decPrefix == null) {
                if (!StringUtils.isEmpty(this.namespace)) {
                    declare = true;
                    this.prefix = StaxUtils.getUniquePrefix(this.writer);
                } else {
                    this.prefix = "";
                    if (!StringUtils.isEmpty(this.writer.getNamespaceContext().getNamespaceURI(""))) {
                        declare = true;
                    }
                }
            } else if (StringUtils.isEmpty(this.prefix)) {
                this.prefix = decPrefix;
            } else if (!this.prefix.equals(decPrefix)) {
                declare = true;
            }
            this.writer.writeStartElement(this.prefix, this.name, this.namespace);
            if (declare) {
                this.writer.setPrefix(this.prefix, this.namespace);
                this.writer.writeNamespace(this.prefix, this.namespace);
            }
        } else {
            this.writer.writeStartElement(this.name);
        }
    }

    public void writeValue(Object value) {
        try {
            if (value != null) {
                this.writer.writeCharacters(value.toString());
            }
        }
        catch (XMLStreamException e) {
            throw new DatabindingException("Error writing document.", (Throwable)e);
        }
    }

    public MessageWriter getElementWriter(String nm) {
        return new ElementWriter(this.writer, nm, this.namespace);
    }

    public MessageWriter getElementWriter(String nm, String ns) {
        return new ElementWriter(this.writer, nm, ns);
    }

    public MessageWriter getElementWriter(QName qname) {
        if ("".equals(qname.getPrefix())) {
            return new ElementWriter(this.writer, qname.getLocalPart(), qname.getNamespaceURI());
        }
        return new ElementWriter(this.writer, qname.getLocalPart(), qname.getNamespaceURI(), qname.getPrefix());
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void close() {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new DatabindingException("Error writing document.", (Throwable)e);
        }
    }

    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    public XMLStreamWriter getXMLStreamWriter() {
        return this.writer;
    }

    public MessageWriter getAttributeWriter(String nm) {
        return new AttributeWriter(this.writer, nm, this.namespace);
    }

    public MessageWriter getAttributeWriter(String nm, String ns) {
        return new AttributeWriter(this.writer, nm, ns);
    }

    public MessageWriter getAttributeWriter(QName qname) {
        return new AttributeWriter(this.writer, qname.getLocalPart(), qname.getNamespaceURI());
    }

    public String getPrefixForNamespace(String ns) {
        try {
            String pfx = this.writer.getPrefix(ns);
            if (pfx == null) {
                pfx = StaxUtils.getUniquePrefix(this.writer);
                this.writer.setPrefix(pfx, ns);
                this.writer.writeNamespace(pfx, ns);
            }
            return this.prefix;
        }
        catch (XMLStreamException e) {
            throw new DatabindingException("Error writing document.", (Throwable)e);
        }
    }

    public String getPrefixForNamespace(String ns, String hint) {
        try {
            String pfx = this.writer.getPrefix(ns);
            String contextPfx = this.writer.getNamespaceContext().getPrefix(ns);
            if (pfx == null) {
                String ns2 = this.writer.getNamespaceContext().getNamespaceURI(hint);
                pfx = ns2 == null && !"".equals(hint) ? hint : (ns.equals(ns2) ? hint : (contextPfx != null ? contextPfx : StaxUtils.getUniquePrefix(this.writer)));
                this.writer.setPrefix(pfx, ns);
                this.writer.writeNamespace(pfx, ns);
            }
            return pfx;
        }
        catch (XMLStreamException e) {
            throw new DatabindingException("Error writing document.", (Throwable)e);
        }
    }
}

