/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptorProvider;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.kerberos.KerberosClient;
import org.apache.cxf.ws.security.kerberos.KerberosUtils;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.tokenstore.TokenStoreFactory;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.policyvalidators.KerberosTokenPolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.KerberosSecurity;

public class KerberosTokenInterceptorProvider
extends AbstractPolicyInterceptorProvider {
    private static final long serialVersionUID = 5922028830873137490L;

    public KerberosTokenInterceptorProvider() {
        super(Arrays.asList(SP11Constants.KERBEROS_TOKEN, SP12Constants.KERBEROS_TOKEN));
        this.getOutInterceptors().add(PolicyBasedWSS4JOutInterceptor.INSTANCE);
        this.getOutFaultInterceptors().add(PolicyBasedWSS4JOutInterceptor.INSTANCE);
        this.getInInterceptors().add(PolicyBasedWSS4JInInterceptor.INSTANCE);
        this.getInFaultInterceptors().add(PolicyBasedWSS4JInInterceptor.INSTANCE);
        this.getOutInterceptors().add(new KerberosTokenOutInterceptor());
        this.getOutFaultInterceptors().add(new KerberosTokenOutInterceptor());
        this.getInInterceptors().add(new KerberosTokenInInterceptor());
        this.getInFaultInterceptors().add(new KerberosTokenInInterceptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final TokenStore getTokenStore(Message message) {
        EndpointInfo info;
        EndpointInfo endpointInfo = info = message.getExchange().get(Endpoint.class).getEndpointInfo();
        synchronized (endpointInfo) {
            TokenStore tokenStore = (TokenStore)message.getContextualProperty("org.apache.cxf.ws.security.tokenstore.TokenStore");
            if (tokenStore == null) {
                tokenStore = (TokenStore)info.getProperty("org.apache.cxf.ws.security.tokenstore.TokenStore");
            }
            if (tokenStore == null) {
                TokenStoreFactory tokenStoreFactory = TokenStoreFactory.newInstance();
                String cacheKey = "org.apache.cxf.ws.security.tokenstore.TokenStore";
                if (info.getName() != null) {
                    cacheKey = cacheKey + "-" + info.getName().toString().hashCode();
                }
                tokenStore = tokenStoreFactory.newTokenStore(cacheKey, message);
                info.setProperty("org.apache.cxf.ws.security.tokenstore.TokenStore", tokenStore);
            }
            return tokenStore;
        }
    }

    private static SecurityToken createSecurityToken(KerberosSecurity binarySecurityToken) {
        SecurityToken token = new SecurityToken(binarySecurityToken.getID());
        token.setToken(binarySecurityToken.getElement());
        token.setTokenType(binarySecurityToken.getValueType());
        return token;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KerberosTokenInInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public KerberosTokenInInterceptor() {
            super("pre-protocol");
            this.addAfter(WSS4JInInterceptor.class.getName());
            this.addAfter(PolicyBasedWSS4JInInterceptor.class.getName());
        }

        @Override
        public void handleMessage(Message message) throws Fault {
            AssertionInfoMap aim = message.get(AssertionInfoMap.class);
            if (aim != null) {
                Collection ais = (Collection)aim.get(SP12Constants.KERBEROS_TOKEN);
                if (ais == null) {
                    return;
                }
                if (!this.isRequestor(message)) {
                    List results = CastUtils.cast((List)message.get("RECV_RESULTS"));
                    if (results != null && results.size() > 0) {
                        this.parseHandlerResults((WSHandlerResult)results.get(0), message, aim);
                    }
                } else {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
            }
        }

        private void parseHandlerResults(WSHandlerResult rResult, Message message, AssertionInfoMap aim) {
            List<WSSecurityEngineResult> kerberosResults = this.findKerberosResults(rResult.getResults());
            Iterator<WSSecurityEngineResult> i$ = kerberosResults.iterator();
            while (i$.hasNext()) {
                KerberosTokenPolicyValidator kerberosValidator = new KerberosTokenPolicyValidator(message);
                WSSecurityEngineResult wser = i$.next();
                KerberosSecurity kerberosToken = (KerberosSecurity)wser.get((Object)"binary-security-token");
                boolean valid = kerberosValidator.validatePolicy(aim, kerberosToken);
                if (!valid) continue;
                SecurityToken token = KerberosTokenInterceptorProvider.createSecurityToken(kerberosToken);
                token.setSecret((byte[])wser.get((Object)"secret"));
                KerberosTokenInterceptorProvider.getTokenStore(message).add(token);
                message.getExchange().put("ws-security.token.id", token.getId());
                return;
            }
        }

        private List<WSSecurityEngineResult> findKerberosResults(List<WSSecurityEngineResult> wsSecEngineResults) {
            ArrayList<WSSecurityEngineResult> results = new ArrayList<WSSecurityEngineResult>();
            for (WSSecurityEngineResult wser : wsSecEngineResults) {
                BinarySecurity binarySecurity;
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 4096 || !((binarySecurity = (BinarySecurity)wser.get((Object)"binary-security-token")) instanceof KerberosSecurity)) continue;
                results.add(wser);
            }
            return results;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KerberosTokenOutInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public KerberosTokenOutInterceptor() {
            super("prepare-send");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message message) throws Fault {
            AssertionInfoMap aim = message.get(AssertionInfoMap.class);
            if (aim != null) {
                Collection ais = (Collection)aim.get(SP12Constants.KERBEROS_TOKEN);
                if (ais == null || ais.isEmpty()) {
                    return;
                }
                if (this.isRequestor(message)) {
                    SecurityToken tok = null;
                    String tokId = (String)message.getContextualProperty("ws-security.token.id");
                    if (tokId != null) {
                        tok = KerberosTokenInterceptorProvider.getTokenStore(message).getToken(tokId);
                    }
                    if (tok == null) {
                        try {
                            KerberosClient client;
                            KerberosClient kerberosClient = client = KerberosUtils.getClient(message, "kerberos");
                            synchronized (kerberosClient) {
                                tok = client.requestSecurityToken();
                            }
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new Fault(e);
                        }
                    }
                    if (tok != null) {
                        for (AssertionInfo ai : ais) {
                            ai.setAsserted(true);
                        }
                        message.getExchange().get(Endpoint.class).put("ws-security.token.id", tok.getId());
                        message.getExchange().put("ws-security.token.id", tok.getId());
                        KerberosTokenInterceptorProvider.getTokenStore(message).add(tok);
                    }
                } else {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
            }
        }
    }
}

