/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.catalog.OASISCatalogManagerHelper;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.frontend.WSDLGetInterceptor;
import org.apache.cxf.frontend.WSDLQueryException;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.ResourceManagerWSDLLocator;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLGetUtils {
    public static final String AUTO_REWRITE_ADDRESS = "autoRewriteSoapAddress";
    public static final String AUTO_REWRITE_ADDRESS_ALL = "autoRewriteSoapAddressForAllServices";
    public static final String PUBLISHED_ENDPOINT_URL = "publishedEndpointUrl";
    public static final String WSDL_CREATE_IMPORTS = "org.apache.cxf.wsdl.create.imports";
    private static final String WSDLS_KEY = WSDLGetUtils.class.getName() + ".WSDLs";
    private static final String SCHEMAS_KEY = WSDLGetUtils.class.getName() + ".Schemas";
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLGetInterceptor.class);

    public Set<String> getWSDLIds(Message message, String base, String ctxUri, EndpointInfo endpointInfo) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("wsdl", "");
        new WSDLGetUtils().getDocument(message, base, params, ctxUri, endpointInfo);
        Map mp = CastUtils.cast((Map)endpointInfo.getService().getProperty(WSDLS_KEY));
        return mp.keySet();
    }

    private String buildUrl(String base, String ctxUri, String s) {
        return base + ctxUri + "?" + s;
    }

    public Map<String, String> getSchemaLocations(Message message, String base, String ctxUri, EndpointInfo endpointInfo) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("wsdl", "");
        new WSDLGetUtils().getDocument(message, base, params, ctxUri, endpointInfo);
        Map mp = CastUtils.cast((Map)endpointInfo.getService().getProperty(SCHEMAS_KEY));
        HashMap<String, String> schemas = new HashMap<String, String>();
        for (Map.Entry ent : mp.entrySet()) {
            params.clear();
            params.put("xsd", (String)ent.getKey());
            Document doc = this.getDocument(message, base, params, ctxUri, endpointInfo);
            schemas.put(doc.getDocumentElement().getAttribute("targetNamespace"), this.buildUrl(base, ctxUri, "xsd=" + (String)ent.getKey()));
        }
        return schemas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument(Message message, String base, Map<String, String> params, String ctxUri, EndpointInfo endpointInfo) {
        try {
            Document doc;
            Definition def;
            String xsd;
            String wsdl;
            Bus bus = message.getExchange().getBus();
            Object prop = message.getContextualProperty(PUBLISHED_ENDPOINT_URL);
            if (prop == null) {
                prop = endpointInfo.getProperty(PUBLISHED_ENDPOINT_URL);
            }
            if (prop != null) {
                base = String.valueOf(prop);
            }
            if ((wsdl = params.get("wsdl")) != null) {
                wsdl = URLDecoder.decode(wsdl, "utf-8");
            }
            if ((xsd = params.get("xsd")) != null) {
                xsd = URLDecoder.decode(xsd, "utf-8");
            }
            Map<String, Definition> mp = CastUtils.cast((Map)endpointInfo.getService().getProperty(WSDLS_KEY));
            Map<String, SchemaReference> smp = CastUtils.cast((Map)endpointInfo.getService().getProperty(SCHEMAS_KEY));
            if (mp == null) {
                endpointInfo.getService().setProperty(WSDLS_KEY, new ConcurrentHashMap(8, 0.75f, 4));
                mp = CastUtils.cast((Map)endpointInfo.getService().getProperty(WSDLS_KEY));
            }
            if (smp == null) {
                endpointInfo.getService().setProperty(SCHEMAS_KEY, new ConcurrentHashMap(8, 0.75f, 4));
                smp = CastUtils.cast((Map)endpointInfo.getService().getProperty(SCHEMAS_KEY));
            }
            if (!mp.containsKey("")) {
                ServiceWSDLBuilder builder = new ServiceWSDLBuilder(bus, endpointInfo.getService());
                builder.setUseSchemaImports(MessageUtils.getContextualBoolean(message, WSDL_CREATE_IMPORTS, false));
                builder.setBaseFileName(endpointInfo.getService().getName().getLocalPart());
                def = builder.build(new HashMap<String, SchemaInfo>());
                mp.put("", def);
                this.updateDefinition(bus, def, mp, smp, base, endpointInfo);
            }
            if (xsd == null) {
                Object wsdl2;
                def = (Definition)mp.get(wsdl);
                if (def == null && (wsdl2 = this.resolveWithCatalogs(OASISCatalogManager.getCatalogManager(bus), wsdl, base)) != null) {
                    def = (Definition)mp.get(wsdl2);
                }
                if (def == null) {
                    throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("WSDL_NOT_FOUND", LOG, wsdl), null);
                }
                wsdl2 = def;
                synchronized (wsdl2) {
                    if (endpointInfo.getProperty(PUBLISHED_ENDPOINT_URL) != null) {
                        String epurl = String.valueOf(endpointInfo.getProperty(PUBLISHED_ENDPOINT_URL));
                        this.updatePublishedEndpointUrl(epurl, def, endpointInfo.getName());
                        base = epurl;
                    }
                    WSDLWriter wsdlWriter = bus.getExtension(WSDLManager.class).getWSDLFactory().newWSDLWriter();
                    def.setExtensionRegistry(bus.getExtension(WSDLManager.class).getExtensionRegistry());
                    doc = wsdlWriter.getDocument(def);
                }
            } else {
                ResourceManagerWSDLLocator rml;
                InputSource src;
                String xsd2;
                SchemaReference si = (SchemaReference)smp.get(xsd);
                if (si == null && (xsd2 = this.resolveWithCatalogs(OASISCatalogManager.getCatalogManager(bus), xsd, base)) != null) {
                    si = (SchemaReference)smp.get(xsd2);
                }
                if (si == null) {
                    throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("SCHEMA_NOT_FOUND", LOG, wsdl), null);
                }
                String uri = si.getReferencedSchema().getDocumentBaseURI();
                uri = this.resolveWithCatalogs(OASISCatalogManager.getCatalogManager(bus), uri, si.getReferencedSchema().getDocumentBaseURI());
                if (uri == null) {
                    uri = si.getReferencedSchema().getDocumentBaseURI();
                }
                doc = (src = (rml = new ResourceManagerWSDLLocator(uri, bus)).getBaseInputSource()).getByteStream() != null || src.getCharacterStream() != null ? StaxUtils.read(src) : StaxUtils.read(new DOMSource(si.getReferencedSchema().getElement().getOwnerDocument()));
            }
            this.updateDoc(doc, base, mp, smp, message);
            return doc;
        }
        catch (WSDLQueryException wex) {
            throw wex;
        }
        catch (Exception wex) {
            throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, base), (Throwable)wex);
        }
    }

    protected String mapUri(String base, Map<String, SchemaReference> smp, String loc) throws UnsupportedEncodingException {
        SchemaReference ref = smp.get(URLDecoder.decode(loc, "utf-8"));
        if (ref != null) {
            return base + "?xsd=" + ref.getSchemaLocationURI().replace(" ", "%20");
        }
        return null;
    }

    protected void updateDoc(Document doc, String base, Map<String, Definition> mp, Map<String, SchemaReference> smp, Message message) {
        Object rewriteSoapAddress;
        List<Element> elementList = null;
        try {
            String sl;
            elementList = DOMUtils.findAllElementsByTagNameNS(doc.getDocumentElement(), "http://www.w3.org/2001/XMLSchema", "import");
            for (Element el : elementList) {
                sl = el.getAttribute("schemaLocation");
                if ((sl = this.mapUri(base, smp, sl)) == null) continue;
                el.setAttribute("schemaLocation", sl);
            }
            elementList = DOMUtils.findAllElementsByTagNameNS(doc.getDocumentElement(), "http://www.w3.org/2001/XMLSchema", "include");
            for (Element el : elementList) {
                sl = el.getAttribute("schemaLocation");
                if (!smp.containsKey(URLDecoder.decode(sl, "utf-8"))) continue;
                el.setAttribute("schemaLocation", base + "?xsd=" + sl.replace(" ", "%20"));
            }
            elementList = DOMUtils.findAllElementsByTagNameNS(doc.getDocumentElement(), "http://www.w3.org/2001/XMLSchema", "redefine");
            for (Element el : elementList) {
                sl = el.getAttribute("schemaLocation");
                if (!smp.containsKey(URLDecoder.decode(sl, "utf-8"))) continue;
                el.setAttribute("schemaLocation", base + "?xsd=" + sl.replace(" ", "%20"));
            }
            elementList = DOMUtils.findAllElementsByTagNameNS(doc.getDocumentElement(), "http://schemas.xmlsoap.org/wsdl/", "import");
            for (Element el : elementList) {
                sl = el.getAttribute("location");
                if (!mp.containsKey(URLDecoder.decode(sl, "utf-8"))) continue;
                el.setAttribute("location", base + "?wsdl=" + sl.replace(" ", "%20"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, base), (Throwable)e);
        }
        boolean rewriteAllSoapAddress = MessageUtils.isTrue(message.getContextualProperty(AUTO_REWRITE_ADDRESS_ALL));
        if (rewriteAllSoapAddress) {
            List<Element> portList = DOMUtils.findAllElementsByTagNameNS(doc.getDocumentElement(), "http://schemas.xmlsoap.org/wsdl/", "port");
            String basePath = (String)message.get("http.base.path");
            for (Element el : portList) {
                this.rewriteAddressProtocolHostPort(base, el, basePath, "http://schemas.xmlsoap.org/wsdl/soap/");
                this.rewriteAddressProtocolHostPort(base, el, basePath, "http://schemas.xmlsoap.org/wsdl/soap12/");
            }
        }
        if ((rewriteSoapAddress = message.getContextualProperty(AUTO_REWRITE_ADDRESS)) == null || MessageUtils.isTrue(rewriteSoapAddress) || rewriteAllSoapAddress) {
            List<Element> serviceList = DOMUtils.findAllElementsByTagNameNS(doc.getDocumentElement(), "http://schemas.xmlsoap.org/wsdl/", "service");
            for (Element serviceEl : serviceList) {
                String serviceName = serviceEl.getAttribute("name");
                if (!serviceName.equals(message.getExchange().getService().getName().getLocalPart())) continue;
                elementList = DOMUtils.findAllElementsByTagNameNS(doc.getDocumentElement(), "http://schemas.xmlsoap.org/wsdl/", "port");
                for (Element el : elementList) {
                    String name = el.getAttribute("name");
                    if (!name.equals(message.getExchange().getEndpoint().getEndpointInfo().getName().getLocalPart())) continue;
                    this.rewriteAddress(base, el, "http://schemas.xmlsoap.org/wsdl/soap/");
                    this.rewriteAddress(base, el, "http://schemas.xmlsoap.org/wsdl/soap12/");
                }
            }
        }
        try {
            doc.setXmlStandalone(true);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    protected void rewriteAddress(String base, Element el, String soapNS) {
        List<Element> sadEls = DOMUtils.findAllElementsByTagNameNS(el, soapNS, "address");
        for (Element soapAddress : sadEls) {
            soapAddress.setAttribute("location", base);
        }
    }

    protected void rewriteAddressProtocolHostPort(String base, Element el, String httpBasePathProp, String soapNS) {
        List<Element> sadEls = DOMUtils.findAllElementsByTagNameNS(el, soapNS, "address");
        for (Element soapAddress : sadEls) {
            String location = soapAddress.getAttribute("location").trim();
            try {
                URI locUri = new URI(location);
                if (locUri.isAbsolute()) {
                    URL baseUrl = new URL(base);
                    StringBuilder sb = new StringBuilder(baseUrl.getProtocol());
                    sb.append("://").append(baseUrl.getHost()).append(":").append(baseUrl.getPort()).append(locUri.getPath());
                    soapAddress.setAttribute("location", sb.toString());
                    continue;
                }
                if (httpBasePathProp == null) continue;
                soapAddress.setAttribute("location", httpBasePathProp + location);
            }
            catch (Exception e) {}
        }
    }

    protected String resolveWithCatalogs(OASISCatalogManager catalogs, String start, String base) {
        try {
            return new OASISCatalogManagerHelper().resolve(catalogs, start, base);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected void updateDefinition(Bus bus, Definition def, Map<String, Definition> done, Map<String, SchemaReference> doneSchemas, String base, EndpointInfo ei) {
        OASISCatalogManager catalogs = OASISCatalogManager.getCatalogManager(bus);
        Collection<List> imports = CastUtils.cast(def.getImports().values());
        for (List lst : imports) {
            List<Import> impLst = CastUtils.cast(lst);
            for (Import imp : impLst) {
                String start = imp.getLocationURI();
                String decodedStart = null;
                try {
                    decodedStart = URLDecoder.decode(start, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, start), (Throwable)e);
                }
                String resolvedSchemaLocation = this.resolveWithCatalogs(catalogs, start, base);
                if (resolvedSchemaLocation == null) {
                    try {
                        new URL(start);
                    }
                    catch (MalformedURLException e) {
                        if (done.put(decodedStart, imp.getDefinition()) != null) continue;
                        this.updateDefinition(bus, imp.getDefinition(), done, doneSchemas, base, ei);
                    }
                    continue;
                }
                if (done.put(decodedStart, imp.getDefinition()) != null) continue;
                done.put(resolvedSchemaLocation, imp.getDefinition());
                this.updateDefinition(bus, imp.getDefinition(), done, doneSchemas, base, ei);
            }
        }
        Types types = def.getTypes();
        if (types != null) {
            for (ExtensibilityElement el : CastUtils.cast(types.getExtensibilityElements(), ExtensibilityElement.class)) {
                if (!(el instanceof Schema)) continue;
                Schema see = (Schema)el;
                this.updateSchemaImports(bus, see, doneSchemas, base);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWSDLPublishedEndpointAddress(Definition def, EndpointInfo endpointInfo) {
        Definition definition = def;
        synchronized (definition) {
            if (endpointInfo.getProperty(PUBLISHED_ENDPOINT_URL) != null) {
                String epurl = String.valueOf(endpointInfo.getProperty(PUBLISHED_ENDPOINT_URL));
                this.updatePublishedEndpointUrl(epurl, def, endpointInfo.getName());
            }
        }
    }

    protected void updatePublishedEndpointUrl(String publishingUrl, Definition def, QName name) {
        Collection<Service> services = CastUtils.cast(def.getAllServices().values());
        for (Service service : services) {
            Collection<Port> ports = CastUtils.cast(service.getPorts().values());
            if (ports.isEmpty()) continue;
            if (name == null) {
                this.setSoapAddressLocationOn(ports.iterator().next(), publishingUrl);
                break;
            }
            for (Port port : ports) {
                if (!name.getLocalPart().equals(port.getName())) continue;
                this.setSoapAddressLocationOn(port, publishingUrl);
            }
        }
    }

    protected void setSoapAddressLocationOn(Port port, String url) {
        List extensions = port.getExtensibilityElements();
        for (Object extension : extensions) {
            if (extension instanceof SOAP12Address) {
                ((SOAP12Address)extension).setLocationURI(url);
                continue;
            }
            if (!(extension instanceof SOAPAddress)) continue;
            ((SOAPAddress)extension).setLocationURI(url);
        }
    }

    protected void updateSchemaImports(Bus bus, Schema schema, Map<String, SchemaReference> doneSchemas, String base) {
        OASISCatalogManager catalogs = OASISCatalogManager.getCatalogManager(bus);
        Collection<List> imports = CastUtils.cast(schema.getImports().values());
        for (List lst : imports) {
            List<SchemaImport> impLst = CastUtils.cast(lst);
            for (SchemaImport imp : impLst) {
                String start = this.findSchemaLocation(doneSchemas, (SchemaReference)imp);
                if (start == null) continue;
                String decodedStart = null;
                try {
                    decodedStart = URLDecoder.decode(start, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, start), (Throwable)e);
                }
                if (doneSchemas.containsKey(decodedStart)) continue;
                String resolvedSchemaLocation = this.resolveWithCatalogs(catalogs, start, base);
                if (resolvedSchemaLocation == null) {
                    try {
                        new URL(start);
                    }
                    catch (MalformedURLException e) {
                        if (doneSchemas.put(decodedStart, (SchemaReference)imp) != null) continue;
                        this.updateSchemaImports(bus, imp.getReferencedSchema(), doneSchemas, base);
                    }
                    continue;
                }
                if (doneSchemas.put(decodedStart, (SchemaReference)imp) != null) continue;
                doneSchemas.put(resolvedSchemaLocation, (SchemaReference)imp);
                this.updateSchemaImports(bus, imp.getReferencedSchema(), doneSchemas, base);
            }
        }
        List<SchemaReference> includes = CastUtils.cast(schema.getIncludes());
        for (SchemaReference included : includes) {
            String start = this.findSchemaLocation(doneSchemas, included);
            if (start == null) continue;
            String decodedStart = null;
            try {
                decodedStart = URLDecoder.decode(start, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, start), (Throwable)e);
            }
            String resolvedSchemaLocation = this.resolveWithCatalogs(catalogs, start, base);
            if (resolvedSchemaLocation == null) {
                if (doneSchemas.containsKey(decodedStart)) continue;
                try {
                    new URL(start);
                }
                catch (MalformedURLException e) {
                    if (doneSchemas.put(decodedStart, included) != null) continue;
                    this.updateSchemaImports(bus, included.getReferencedSchema(), doneSchemas, base);
                }
                continue;
            }
            if (doneSchemas.containsKey(decodedStart) && doneSchemas.containsKey(resolvedSchemaLocation)) continue;
            doneSchemas.put(decodedStart, included);
            doneSchemas.put(resolvedSchemaLocation, included);
            this.updateSchemaImports(bus, included.getReferencedSchema(), doneSchemas, base);
        }
        List<SchemaReference> redefines = CastUtils.cast(schema.getRedefines());
        for (SchemaReference included : redefines) {
            String start = this.findSchemaLocation(doneSchemas, included);
            if (start == null) continue;
            String decodedStart = null;
            try {
                decodedStart = URLDecoder.decode(start, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, start), (Throwable)e);
            }
            String resolvedSchemaLocation = this.resolveWithCatalogs(catalogs, start, base);
            if (resolvedSchemaLocation == null) {
                if (doneSchemas.containsKey(decodedStart)) continue;
                try {
                    new URL(start);
                }
                catch (MalformedURLException e) {
                    if (doneSchemas.put(decodedStart, included) != null) continue;
                    this.updateSchemaImports(bus, included.getReferencedSchema(), doneSchemas, base);
                }
                continue;
            }
            if (doneSchemas.containsKey(decodedStart) && doneSchemas.containsKey(resolvedSchemaLocation)) continue;
            doneSchemas.put(decodedStart, included);
            doneSchemas.put(resolvedSchemaLocation, included);
            this.updateSchemaImports(bus, included.getReferencedSchema(), doneSchemas, base);
        }
    }

    private String findSchemaLocation(Map<String, SchemaReference> doneSchemas, SchemaReference imp) {
        if (imp.getReferencedSchema() != null) {
            for (Map.Entry<String, SchemaReference> e : doneSchemas.entrySet()) {
                if (e.getValue().getReferencedSchema().getElement() != imp.getReferencedSchema().getElement()) continue;
                doneSchemas.put(imp.getSchemaLocationURI(), imp);
                imp.setSchemaLocationURI(e.getKey());
                return e.getKey();
            }
        }
        return imp.getSchemaLocationURI();
    }
}

