/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.basic;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.AegisContext;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.type.basic.ArrayType;
import org.apache.cxf.aegis.type.basic.BeanTypeInfo;
import org.apache.cxf.aegis.type.basic.InterfaceInvocationHandler;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.xmlschema.XmlSchemaUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAnyAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanType
extends AegisType {
    private BeanTypeInfo info;
    private boolean isInterface;
    private boolean isException;

    public BeanType() {
    }

    public BeanType(BeanTypeInfo info) {
        this.info = info;
        this.typeClass = info.getTypeClass();
        this.initTypeClass();
    }

    private void initTypeClass() {
        Class plainClass = (Class)this.typeClass;
        this.isInterface = plainClass.isInterface();
        this.isException = Exception.class.isAssignableFrom(plainClass);
    }

    @Override
    public Object readObject(MessageReader reader, Context context) throws DatabindingException {
        BeanTypeInfo inf = this.getTypeInfo();
        try {
            QName name;
            MessageReader childReader;
            Object target;
            Object object;
            Class<?> clazz = this.getTypeClass();
            if (this.isInterface) {
                String impl = context.getGlobalContext().getBeanImplementationMap().get(clazz);
                if (impl == null) {
                    InterfaceInvocationHandler handler = new InterfaceInvocationHandler();
                    object = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)handler);
                    target = handler;
                } else {
                    try {
                        clazz = ClassLoaderUtils.loadClass(impl, this.getClass());
                        target = object = clazz.newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        throw new DatabindingException("Could not find implementation class " + impl + " for class " + clazz.getName());
                    }
                }
            } else {
                target = this.isException ? (object = this.createFromFault(context)) : (object = clazz.newInstance());
            }
            while (reader.hasMoreAttributeReaders()) {
                childReader = reader.getNextAttributeReader();
                name = childReader.getName();
                AegisType type = inf.getType(name);
                if (type == null) continue;
                Object writeObj = type.readObject(childReader, context);
                this.writeProperty(name, target, writeObj, clazz, inf);
            }
            while (reader.hasMoreElementReaders()) {
                BeanTypeInfo propertyTypeInfo;
                childReader = reader.getNextElementReader();
                name = childReader.getName();
                AegisType type = this.getElementType(name, propertyTypeInfo = this.getBeanTypeInfoWithProperty(name), childReader, context);
                if (type != null) {
                    if (!childReader.isXsiNil()) {
                        Object writeObj;
                        if (type.isFlatArray()) {
                            ArrayType aType = (ArrayType)type;
                            PropertyDescriptor desc = inf.getPropertyDescriptorFromMappedName(name);
                            boolean isList = List.class.isAssignableFrom(desc.getPropertyType());
                            writeObj = aType.readObject(childReader, name, context, !isList);
                        } else {
                            writeObj = type.readObject(childReader, context);
                        }
                        this.writeProperty(name, target, writeObj, clazz, propertyTypeInfo);
                        continue;
                    }
                    if (!this.alwaysAllowNillables() && !propertyTypeInfo.isNillable(name)) {
                        throw new DatabindingException(name.getLocalPart() + " is nil, but not nillable.");
                    }
                    childReader.readToEnd();
                    continue;
                }
                childReader.readToEnd();
            }
            return object;
        }
        catch (IllegalAccessException e) {
            throw new DatabindingException("Illegal access. " + e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new DatabindingException("Couldn't instantiate class. " + e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new DatabindingException("Illegal access. " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new DatabindingException("Illegal argument. " + e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new DatabindingException("Could not create class: " + e.getMessage(), (Throwable)e);
        }
    }

    protected boolean alwaysAllowNillables() {
        return false;
    }

    protected AegisType getElementType(QName name, BeanTypeInfo beanTypeInfo, MessageReader reader, Context context) {
        AegisType type = beanTypeInfo.getType(name);
        type = TypeUtil.getReadType(reader.getXMLStreamReader(), context.getGlobalContext(), type);
        return type;
    }

    protected Object createFromFault(Context context) throws SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object o;
        Class<?> clazz = this.getTypeClass();
        Fault fault = context.getFault();
        try {
            Constructor<?> ctr = clazz.getConstructor(String.class, Throwable.class);
            o = ctr.newInstance(fault.getMessage(), fault);
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor<?> ctr = clazz.getConstructor(String.class, Exception.class);
                o = ctr.newInstance(fault.getMessage(), fault);
            }
            catch (NoSuchMethodException e1) {
                try {
                    Constructor<?> ctr = clazz.getConstructor(String.class);
                    o = ctr.newInstance(fault.getMessage());
                }
                catch (NoSuchMethodException e2) {
                    return clazz.newInstance();
                }
            }
        }
        return o;
    }

    protected void writeProperty(QName name, Object object, Object property, Class<?> impl, BeanTypeInfo inf) throws DatabindingException {
        if (object instanceof InterfaceInvocationHandler) {
            InterfaceInvocationHandler delegate = (InterfaceInvocationHandler)object;
            delegate.writeProperty(name.getLocalPart(), property);
            return;
        }
        try {
            PropertyDescriptor desc = inf.getPropertyDescriptorFromMappedName(name);
            Method m = desc.getWriteMethod();
            if (m == null) {
                if (this.getTypeClass().isInterface()) {
                    m = this.getWriteMethodFromImplClass(impl, desc);
                }
                if (m == null && property instanceof List) {
                    m = desc.getReadMethod();
                    List l = CastUtils.cast((List)m.invoke(object, new Object[0]));
                    List p = CastUtils.cast((List)property);
                    l.addAll(p);
                    return;
                }
                if (m == null) {
                    throw new DatabindingException("No write method for property " + name + " in " + object.getClass());
                }
            }
            Class<?> propertyType = desc.getPropertyType();
            if (property == null && !propertyType.isPrimitive() || property != null) {
                m.invoke(object, property);
            }
        }
        catch (Exception e) {
            if (e instanceof DatabindingException) {
                throw (DatabindingException)e;
            }
            throw new DatabindingException("Couldn't set property " + name + " on " + object + ". " + e.getMessage(), (Throwable)e);
        }
    }

    private Method getWriteMethodFromImplClass(Class<?> impl, PropertyDescriptor pd) throws Exception {
        String name = pd.getName();
        name = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        return impl.getMethod(name, pd.getPropertyType());
    }

    void writeObjectFromObjectType(Object object, MessageWriter writer, Context context, boolean wroteXsiType) {
        this.writeObjectInternal(object, writer, context, wroteXsiType);
    }

    @Override
    public void writeObject(Object object, MessageWriter writer, Context context) throws DatabindingException {
        this.writeObjectInternal(object, writer, context, false);
    }

    private void writeObjectInternal(Object object, MessageWriter writer, Context context, boolean wroteXsiType) throws DatabindingException {
        AegisType t;
        Object value;
        if (object == null) {
            return;
        }
        BeanTypeInfo inf = this.getTypeInfo();
        if (!wroteXsiType && object.getClass() == this.getTypeClass() && context.isWriteXsiTypes()) {
            writer.writeXsiType(this.getSchemaType());
        }
        for (QName name : inf.getAttributes()) {
            value = this.readProperty(object, name);
            if (value == null) continue;
            AegisType type = this.getType(inf, name);
            if (type == null) {
                throw new DatabindingException("Couldn't find type for " + value.getClass() + " for property " + name);
            }
            MessageWriter cwriter = writer.getAttributeWriter(name);
            type.writeObject(value, cwriter, context);
            cwriter.close();
        }
        if (inf.isExtension() && (t = this.getSuperType()) != null) {
            t.writeObject(object, writer, context);
        }
        for (QName name : inf.getElements()) {
            if (inf.isExtension() && inf.getPropertyDescriptorFromMappedName(name).getReadMethod().getDeclaringClass() != inf.getTypeClass()) continue;
            value = this.readProperty(object, name);
            AegisType defaultType = this.getType(inf, name);
            AegisType type = TypeUtil.getWriteType(context.getGlobalContext(), value, defaultType);
            if (value != null) {
                if (type == null) {
                    throw new DatabindingException("Couldn't find type for " + value.getClass() + " for property " + name);
                }
                this.writeElement(name, value, type, writer, context);
                continue;
            }
            if (!inf.isNillable(name)) continue;
            MessageWriter cwriter = this.getWriter(writer, name, type);
            cwriter.writeXsiNil();
            cwriter.close();
        }
    }

    protected void writeElement(QName name, Object value, AegisType type, MessageWriter writer, Context context) {
        if (!type.isFlatArray()) {
            MessageWriter cwriter = null;
            cwriter = this.getWriter(writer, name, type);
            type.writeObject(value, cwriter, context);
            cwriter.close();
        } else {
            ArrayType arrayType = (ArrayType)type;
            arrayType.writeObject(value, writer, context, name);
        }
    }

    private MessageWriter getWriter(MessageWriter writer, QName name, AegisType type) {
        MessageWriter cwriter = writer.getElementWriter(name);
        return cwriter;
    }

    protected Object readProperty(Object object, QName name) {
        try {
            PropertyDescriptor desc = this.getTypeInfo().getPropertyDescriptorFromMappedName(name);
            Method m = desc.getReadMethod();
            if (m == null) {
                throw new DatabindingException("No read method for property " + name + " in class " + object.getClass().getName());
            }
            return m.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new DatabindingException("Couldn't get property " + name + " from bean " + object, (Throwable)e);
        }
    }

    private AegisType getType(BeanTypeInfo inf, QName name) {
        AegisType type = inf.getType(name);
        if (type == null) {
            throw new NullPointerException("Couldn't find type for" + name + " in class " + this.getTypeClass().getName());
        }
        return type;
    }

    private void writeTypeReference(QName name, XmlSchemaElement element, AegisType type, XmlSchema schemaRoot) {
        if (type.isAbstract()) {
            element.setName(name.getLocalPart());
            element.setSchemaTypeName(type.getSchemaType());
            XmlSchemaUtils.addImportIfNeeded(schemaRoot, type.getSchemaType().getNamespaceURI());
            long minOccurs = this.getTypeInfo().getMinOccurs(name);
            if (minOccurs == 0L) {
                element.setMinOccurs(minOccurs);
            }
            element.setNillable(this.getTypeInfo().isNillable(name));
        } else {
            element.getRef().setTargetQName(type.getSchemaType());
        }
    }

    @Override
    public void setTypeClass(Type typeClass) {
        super.setTypeClass(typeClass);
        this.initTypeClass();
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public Set<AegisType> getDependencies() {
        HashSet<AegisType> deps = new HashSet<AegisType>();
        BeanTypeInfo inf = this.getTypeInfo();
        for (QName name : inf.getAttributes()) {
            deps.add(inf.getType(name));
        }
        for (QName name : inf.getElements()) {
            if (inf.isExtension() && inf.getPropertyDescriptorFromMappedName(name).getReadMethod().getDeclaringClass() != inf.getTypeClass()) continue;
            deps.add(inf.getType(name));
        }
        AegisType sooperType = this.getSuperType();
        if (sooperType != null) {
            deps.add(sooperType);
        }
        return deps;
    }

    protected BeanTypeInfo getBeanTypeInfoWithProperty(QName name) {
        BeanType beanType = this;
        AegisType type = null;
        while (type == null) {
            type = beanType.getTypeInfo().getType(name);
            if (type != null) continue;
            AegisType superType = beanType.getSuperType();
            if (!(superType instanceof BeanType)) break;
            beanType = (BeanType)superType;
        }
        return beanType.getTypeInfo();
    }

    public AegisType getSuperType() {
        BeanTypeInfo inf = this.getTypeInfo();
        Class<?> c = inf.getTypeClass();
        c = c.isInterface() && c.getInterfaces().length == 1 ? c.getInterfaces()[0] : c.getSuperclass();
        if (c != null && c != Object.class && c != Exception.class && c != RuntimeException.class && c != Enum.class && c != Serializable.class && c != Cloneable.class) {
            TypeMapping tm = inf.getTypeMapping();
            AegisType superType = tm.getType(c);
            if (superType == null) {
                superType = this.getTypeMapping().getTypeCreator().createType(c);
                if (superType != null) {
                    tm.register(superType);
                    this.info.setExtension(true);
                }
            } else {
                this.info.setExtension(true);
            }
            return superType;
        }
        return null;
    }

    public BeanTypeInfo getTypeInfo() {
        if (this.info == null) {
            this.info = this.createTypeInfo();
        }
        this.info.initialize();
        return this.info;
    }

    public BeanTypeInfo createTypeInfo() {
        BeanTypeInfo inf = new BeanTypeInfo(this.getTypeClass(), this.getSchemaType().getNamespaceURI());
        inf.setTypeMapping(this.getTypeMapping());
        return inf;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(": [class=");
        Class<?> c = this.getTypeClass();
        sb.append(c == null ? "<null>" : c.getName());
        sb.append(",\nQName=");
        QName q = this.getSchemaType();
        sb.append(q == null ? "<null>" : q.toString());
        sb.append(",\ninfo=");
        sb.append(this.getTypeInfo().toString());
        sb.append("]");
        return sb.toString();
    }

    private void addXmimeToSchema(XmlSchema root) {
        XmlSchemaUtils.addImportIfNeeded(root, "http://www.w3.org/2005/05/xmlmime");
    }

    @Override
    public long getMinOccurs() {
        return this.getTypeInfo().getMinOccurs();
    }

    @Override
    public boolean hasMinOccurs() {
        return true;
    }

    @Override
    public void setTypeMapping(TypeMapping typeMapping) {
        super.setTypeMapping(typeMapping);
        if (this.info != null) {
            this.info.setTypeMapping(typeMapping);
        }
    }

    @Override
    public void writeSchema(XmlSchema root) {
        AegisType type;
        BeanTypeInfo inf = this.getTypeInfo();
        XmlSchemaComplexType complex = new XmlSchemaComplexType(root, true);
        complex.setName(this.getSchemaType().getLocalPart());
        AegisType sooperType = this.getSuperType();
        if ((inf.getTypeClass().getModifiers() & 0x400) != 0 && !inf.getTypeClass().isInterface()) {
            complex.setAbstract(true);
        }
        XmlSchemaSequence sequence = new XmlSchemaSequence();
        boolean isExtension = inf.isExtension();
        if (isExtension && sooperType != null) {
            XmlSchemaComplexContent content = new XmlSchemaComplexContent();
            complex.setContentModel((XmlSchemaContentModel)content);
            XmlSchemaComplexContentExtension extension = new XmlSchemaComplexContentExtension();
            content.setContent((XmlSchemaContent)extension);
            extension.setBaseTypeName(sooperType.getSchemaType());
            extension.setParticle((XmlSchemaParticle)sequence);
        } else {
            complex.setParticle((XmlSchemaParticle)sequence);
        }
        boolean needXmime = false;
        boolean needUtilityTypes = false;
        for (QName name : inf.getElements()) {
            PropertyDescriptor pd;
            if (isExtension && (pd = inf.getPropertyDescriptorFromMappedName(name)).getReadMethod().getDeclaringClass() != inf.getTypeClass()) continue;
            XmlSchemaElement element = new XmlSchemaElement(root, false);
            element.setName(name.getLocalPart());
            sequence.getItems().add(element);
            type = this.getType(inf, name);
            if (type.isFlatArray()) {
                element.setMinOccurs(type.getMinOccurs());
                element.setMaxOccurs(type.getMaxOccurs());
                ArrayType aType = (ArrayType)type;
                type = aType.getComponentType();
                element.setNillable(type.isNillable());
            } else if ("http://cxf.apache.org/arrays".equals(type.getSchemaType().getNamespaceURI())) {
                XmlSchemaUtils.addImportIfNeeded(root, "http://cxf.apache.org/arrays");
            }
            this.writeTypeReference(name, element, type, root);
            needXmime |= type.usesXmime();
            needUtilityTypes |= type.usesUtilityTypes();
        }
        if (needXmime) {
            this.addXmimeToSchema(root);
        }
        if (needUtilityTypes) {
            AegisContext.addUtilityTypesToSchema(root);
        }
        if (inf.isExtensibleElements()) {
            XmlSchemaAny any = new XmlSchemaAny();
            any.setMinOccurs(0L);
            any.setMaxOccurs(Long.MAX_VALUE);
            sequence.getItems().add(any);
        }
        for (QName name : inf.getAttributes()) {
            XmlSchemaAttribute attribute = new XmlSchemaAttribute(root, false);
            complex.getAttributes().add(attribute);
            attribute.setName(name.getLocalPart());
            type = this.getType(inf, name);
            attribute.setSchemaTypeName(type.getSchemaType());
            String ns = name.getNamespaceURI();
            if (ns.equals(root.getTargetNamespace())) continue;
            XmlSchemaUtils.addImportIfNeeded(root, ns);
        }
        if (inf.isExtensibleAttributes()) {
            complex.setAnyAttribute(new XmlSchemaAnyAttribute());
        }
    }
}

