/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.rm.EncoderDecoder;
import org.apache.cxf.ws.rm.RM11Constants;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.v200702.AckRequestedType;
import org.apache.cxf.ws.rm.v200702.CloseSequenceType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceType;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.v200702.SequenceFaultType;
import org.apache.cxf.ws.rm.v200702.SequenceType;
import org.apache.cxf.ws.rm.v200702.TerminateSequenceType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EncoderDecoder11Impl
implements EncoderDecoder {
    public static final EncoderDecoder11Impl INSTANCE = new EncoderDecoder11Impl();
    private static JAXBContext jaxbContext;
    private static final Logger LOG;

    private EncoderDecoder11Impl() {
    }

    @Override
    public String getWSRMNamespace() {
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702";
    }

    @Override
    public String getWSANamespace() {
        return "http://www.w3.org/2005/08/addressing";
    }

    @Override
    public RMConstants getConstants() {
        return RM11Constants.INSTANCE;
    }

    @Override
    public Class<?> getCreateSequenceType() {
        return CreateSequenceType.class;
    }

    @Override
    public Class<?> getCreateSequenceResponseType() {
        return CreateSequenceResponseType.class;
    }

    @Override
    public Class<?> getTerminateSequenceType() {
        return TerminateSequenceType.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JAXBContext getContext() throws JAXBException {
        Class<EncoderDecoder11Impl> clazz = EncoderDecoder11Impl.class;
        synchronized (EncoderDecoder11Impl.class) {
            if (jaxbContext == null) {
                Class<?> clas = RMUtils.getWSRMFactory().getClass();
                jaxbContext = JAXBContext.newInstance((String)PackageUtils.getPackageName(clas), (ClassLoader)clas.getClassLoader());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return jaxbContext;
        }
    }

    @Override
    public Element buildHeaders(RMProperties rmps, QName qname) throws JAXBException {
        Collection<AckRequestedType> reqs;
        Collection<SequenceAcknowledgement> acks;
        Document doc = DOMUtils.createDocument();
        Element header = doc.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
        Attr attr = doc.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsrm");
        attr.setValue("http://schemas.xmlsoap.org/ws/2005/02/rm");
        header.setAttributeNodeNS(attr);
        Marshaller marshaller = EncoderDecoder11Impl.getContext().createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        SequenceType seq = rmps.getSequence();
        if (null != seq) {
            LOG.log(Level.FINE, "encoding sequence into RM header");
            JAXBElement<SequenceType> element = RMUtils.getWSRMFactory().createSequence(seq);
            marshaller.marshal(element, (Node)header);
        }
        if (null != (acks = rmps.getAcks())) {
            LOG.log(Level.FINE, "encoding sequence acknowledgement(s) into RM header");
            for (SequenceAcknowledgement ack : acks) {
                marshaller.marshal((Object)ack, (Node)header);
            }
        }
        if (null != (reqs = rmps.getAcksRequested())) {
            LOG.log(Level.FINE, "encoding acknowledgement request(s) into RM header");
            for (AckRequestedType req : reqs) {
                marshaller.marshal(RMUtils.getWSRMFactory().createAckRequested(req), (Node)header);
            }
        }
        return header;
    }

    @Override
    public Element buildHeaderFault(SequenceFault sf, QName qname) throws JAXBException {
        Document doc = DOMUtils.createDocument();
        Element header = doc.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
        Attr attr = doc.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsrm");
        attr.setValue("http://docs.oasis-open.org/ws-rx/wsrm/200702");
        header.setAttributeNodeNS(attr);
        Marshaller marshaller = EncoderDecoder11Impl.getContext().createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        QName fqname = RM11Constants.SEQUENCE_FAULT_QNAME;
        SequenceFaultType flt = new SequenceFaultType();
        flt.setFaultCode(sf.getFaultCode());
        Object detail = sf.getDetail();
        if (detail instanceof Element) {
            flt.getAny().add(detail);
        } else if (detail instanceof Identifier) {
            marshaller.marshal(detail, (Node)doc);
        } else if (detail instanceof SequenceAcknowledgement) {
            marshaller.marshal(detail, (Node)doc);
        }
        Element data = doc.getDocumentElement();
        if (data != null) {
            flt.getDetail().getAny().add(data);
        }
        if ((data = sf.getExtraDetail()) != null) {
            flt.getDetail().getAny().add(data);
        }
        marshaller.marshal((Object)new JAXBElement(fqname, SequenceFaultType.class, (Object)flt), (Node)header);
        return header;
    }

    @Override
    public Element encodeSequenceAcknowledgement(SequenceAcknowledgement ack) throws JAXBException {
        Document doc = DOMUtils.createDocument();
        Marshaller marshaller = EncoderDecoder11Impl.getContext().createMarshaller();
        marshaller.marshal((Object)ack, (Node)doc);
        return (Element)doc.getFirstChild();
    }

    @Override
    public Element encodeIdentifier(Identifier id) throws JAXBException {
        Document doc = DOMUtils.createDocument();
        Marshaller marshaller = EncoderDecoder11Impl.getContext().createMarshaller();
        marshaller.marshal((Object)id, (Node)doc);
        return (Element)doc.getFirstChild();
    }

    @Override
    public SequenceType decodeSequenceType(Element elem) throws JAXBException {
        Unmarshaller unmarshaller = EncoderDecoder11Impl.getContext().createUnmarshaller();
        JAXBElement jaxbElement = unmarshaller.unmarshal((Node)elem, SequenceType.class);
        return (SequenceType)jaxbElement.getValue();
    }

    @Override
    public CloseSequenceType decodeSequenceTypeCloseSequence(Element elem) throws JAXBException {
        return null;
    }

    @Override
    public SequenceAcknowledgement decodeSequenceAcknowledgement(Element elem) throws JAXBException {
        Unmarshaller unmarshaller = EncoderDecoder11Impl.getContext().createUnmarshaller();
        return (SequenceAcknowledgement)unmarshaller.unmarshal((Node)elem);
    }

    @Override
    public AckRequestedType decodeAckRequestedType(Element elem) throws JAXBException {
        Unmarshaller unmarshaller = EncoderDecoder11Impl.getContext().createUnmarshaller();
        JAXBElement jaxbElement = unmarshaller.unmarshal((Node)elem, AckRequestedType.class);
        return (AckRequestedType)jaxbElement.getValue();
    }

    @Override
    public Object convertToSend(CreateSequenceType create) {
        return create;
    }

    @Override
    public Object convertToSend(CreateSequenceResponseType create) {
        return create;
    }

    @Override
    public Object convertToSend(TerminateSequenceType term) {
        return term;
    }

    @Override
    public CreateSequenceType convertReceivedCreateSequence(Object create) {
        return (CreateSequenceType)create;
    }

    @Override
    public CreateSequenceResponseType convertReceivedCreateSequenceResponse(Object create) {
        return (CreateSequenceResponseType)create;
    }

    @Override
    public TerminateSequenceType convertReceivedTerminateSequence(Object term) {
        return (TerminateSequenceType)term;
    }

    static {
        LOG = LogUtils.getL7dLogger(EncoderDecoder11Impl.class);
    }
}

