/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler.logical;

import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJFactoryResolver;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxws.handler.logical.LogicalMessageContextImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.message.XMLMessage;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LogicalMessageImpl
implements LogicalMessage {
    private static final Logger LOG = LogUtils.getL7dLogger(LogicalMessageImpl.class);
    private final LogicalMessageContextImpl msgContext;

    public LogicalMessageImpl(LogicalMessageContextImpl lmctx) {
        this.msgContext = lmctx;
    }

    public Source getPayload() {
        Source source = null;
        Service.Mode mode = this.msgContext.getWrappedMessage().getExchange().get(Service.Mode.class);
        if (mode != null) {
            source = this.handleDispatchProviderCase(mode);
        } else {
            Message message = this.msgContext.getWrappedMessage();
            source = message.getContent(Source.class);
            if (source == null) {
                SOAPMessage msg = message.getContent(SOAPMessage.class);
                XMLStreamReader reader = null;
                if (msg != null) {
                    try {
                        Node node;
                        for (node = SAAJUtils.getBody(msg).getFirstChild(); node != null && !(node instanceof Element); node = node.getNextSibling()) {
                        }
                        source = new DOMSource(node);
                        reader = StaxUtils.createXMLStreamReader(source);
                    }
                    catch (SOAPException e) {
                        throw new Fault(e);
                    }
                }
                if (source == null) {
                    try {
                        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
                        reader = message.getContent(XMLStreamReader.class);
                        StaxUtils.toNextTag(reader);
                        StaxUtils.copy(reader, (XMLStreamWriter)writer);
                        source = new DOMSource(writer.getDocument().getDocumentElement());
                        reader = StaxUtils.createXMLStreamReader(writer.getDocument());
                    }
                    catch (ParserConfigurationException e) {
                        throw new Fault(e);
                    }
                    catch (XMLStreamException e) {
                        throw new Fault(e);
                    }
                }
                message.setContent(XMLStreamReader.class, reader);
                message.setContent(Source.class, source);
            } else if (!(source instanceof DOMSource)) {
                W3CDOMStreamWriter writer;
                try {
                    writer = new W3CDOMStreamWriter();
                }
                catch (ParserConfigurationException e) {
                    throw new Fault(e);
                }
                XMLStreamReader reader = message.getContent(XMLStreamReader.class);
                if (reader == null) {
                    reader = StaxUtils.createXMLStreamReader(source);
                }
                try {
                    StaxUtils.copy(reader, (XMLStreamWriter)writer);
                }
                catch (XMLStreamException e) {
                    throw new Fault(e);
                }
                source = new DOMSource(writer.getDocument().getDocumentElement());
                reader = StaxUtils.createXMLStreamReader(writer.getDocument());
                message.setContent(XMLStreamReader.class, reader);
                message.setContent(Source.class, source);
            }
        }
        return source;
    }

    private Source handleDispatchProviderCase(Service.Mode mode) {
        Source source = null;
        Message message = this.msgContext.getWrappedMessage();
        Source obj = message.getContent(Source.class);
        if (message instanceof SoapMessage) {
            CachedOutputStream cos;
            if (obj instanceof StreamSource) {
                try {
                    cos = new CachedOutputStream();
                    StaxUtils.copy(obj, (OutputStream)cos);
                    obj = new StreamSource(cos.getInputStream());
                    message.setContent(Source.class, new StreamSource(cos.getInputStream()));
                    cos.close();
                }
                catch (Exception e) {
                    throw new Fault(e);
                }
            }
            if (mode == Service.Mode.PAYLOAD) {
                source = obj;
            } else {
                try {
                    cos = new CachedOutputStream();
                    StaxUtils.copy(obj, (OutputStream)cos);
                    InputStream in = cos.getInputStream();
                    SOAPMessage msg = this.initSOAPMessage(in);
                    source = new DOMSource(SAAJUtils.getBody(msg).getFirstChild());
                    in.close();
                    cos.close();
                }
                catch (Exception e) {
                    throw new Fault(e);
                }
            }
        } else if (message instanceof XMLMessage) {
            if (obj != null) {
                source = obj;
            } else if (message.getContent(DataSource.class) != null) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("GETPAYLOAD_OF_DATASOURCE_NOT_VALID_XMLHTTPBINDING", LOG, new Object[0]));
            }
        }
        return source;
    }

    public void setPayload(Source s) {
        Message message = this.msgContext.getWrappedMessage();
        Service.Mode mode = (Service.Mode)this.msgContext.getWrappedMessage().getContextualProperty(Service.Mode.class.getName());
        SOAPMessage m = message.getContent(SOAPMessage.class);
        if (m != null && !MessageUtils.isOutbound(message)) {
            try {
                SAAJUtils.getBody(m).removeContents();
                W3CDOMStreamWriter writer = new W3CDOMStreamWriter((Element)SAAJUtils.getBody(m));
                StaxUtils.copy(s, (XMLStreamWriter)writer);
                writer.flush();
                writer.close();
                s = mode == Service.Mode.MESSAGE ? new DOMSource((Node)m.getSOAPPart()) : new DOMSource(SAAJUtils.getBody(m).getFirstChild());
                W3CDOMStreamReader r = new W3CDOMStreamReader(DOMUtils.getFirstChildElement((Element)SAAJUtils.getBody(m)));
                message.setContent(XMLStreamReader.class, r);
            }
            catch (Exception e) {
                throw new Fault(e);
            }
        } else if (mode != null) {
            if (message instanceof SoapMessage) {
                if (mode == Service.Mode.MESSAGE) {
                    try {
                        SOAPMessage msg = this.initSOAPMessage(null);
                        this.write(s, (Node)SAAJUtils.getBody(msg));
                        s = new DOMSource((Node)msg.getSOAPPart());
                    }
                    catch (Exception e) {
                        throw new Fault(e);
                    }
                }
            } else if (message instanceof XMLMessage && message.getContent(DataSource.class) != null) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("GETPAYLOAD_OF_DATASOURCE_NOT_VALID_XMLHTTPBINDING", LOG, new Object[0]));
            }
        } else {
            XMLStreamReader reader = StaxUtils.createXMLStreamReader(s);
            this.msgContext.getWrappedMessage().setContent(XMLStreamReader.class, reader);
        }
        this.msgContext.getWrappedMessage().setContent(Source.class, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getPayload(JAXBContext arg0) {
        Object object;
        Source s = this.getPayload();
        if (!(s instanceof DOMSource)) return arg0.createUnmarshaller().unmarshal(this.getPayload());
        DOMSource ds = (DOMSource)s;
        Node parent = ds.getNode().getParentNode();
        Node next = ds.getNode().getNextSibling();
        if (parent instanceof DocumentFragment) {
            parent.removeChild(ds.getNode());
        }
        try {
            object = arg0.createUnmarshaller().unmarshal((Source)ds);
        }
        catch (Throwable throwable) {
            try {
                if (!(parent instanceof DocumentFragment)) throw throwable;
                parent.insertBefore(ds.getNode(), next);
                throw throwable;
            }
            catch (JAXBException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
        if (!(parent instanceof DocumentFragment)) return object;
        parent.insertBefore(ds.getNode(), next);
        return object;
    }

    public void setPayload(Object arg0, JAXBContext arg1) {
        try {
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
            arg1.createMarshaller().marshal(arg0, (XMLStreamWriter)writer);
            DOMSource source = new DOMSource(writer.getDocument().getDocumentElement());
            this.setPayload(source);
        }
        catch (ParserConfigurationException e) {
            throw new WebServiceException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private void write(Source source, Node n) {
        try {
            if (source instanceof DOMSource && ((DOMSource)source).getNode() == null) {
                return;
            }
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter((Element)n);
            StaxUtils.copy(source, (XMLStreamWriter)writer);
        }
        catch (XMLStreamException e) {
            throw new Fault(e);
        }
    }

    private SOAPMessage initSOAPMessage(InputStream is) throws SOAPException, IOException {
        SOAPMessage msg = null;
        msg = is != null ? SAAJFactoryResolver.createMessageFactory(null).createMessage(null, is) : SAAJFactoryResolver.createMessageFactory(null).createMessage();
        msg.setProperty("javax.xml.soap.write-xml-declaration", (Object)"true");
        msg.getSOAPPart().getEnvelope().addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        msg.getSOAPPart().getEnvelope().addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        return msg;
    }
}

