/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.JarResource;
import org.apache.cxf.common.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtil {
    private static Method springBeanUtilsDescriptorFetcher;
    private static boolean springChecked;

    private ReflectionUtil() {
    }

    public static <T> T accessDeclaredField(final Field f, final Object o, final Class<T> responseClass) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public T run() {
                try {
                    Object t;
                    try {
                        f.setAccessible(true);
                        t = responseClass.cast(f.get(o));
                        Object var4_4 = null;
                    }
                    catch (SecurityException e) {
                        Object t2 = null;
                        Object var4_5 = null;
                        f.setAccessible(false);
                        return t2;
                    }
                    catch (IllegalAccessException e) {
                        Object t3 = null;
                        Object var4_6 = null;
                        f.setAccessible(false);
                        return t3;
                    }
                    f.setAccessible(false);
                    return t;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    f.setAccessible(false);
                    throw throwable;
                }
            }
        });
    }

    public static Field getDeclaredField(final Class<?> cls, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    return cls.getDeclaredField(name);
                }
                catch (SecurityException e) {
                    return null;
                }
                catch (NoSuchFieldException e) {
                    return null;
                }
            }
        });
    }

    public static <T> Constructor<T> getDeclaredConstructor(final Class<T> cls, final Class<?> ... args) {
        return (Constructor)AccessController.doPrivileged(new PrivilegedAction<Constructor<T>>(){

            @Override
            public Constructor<T> run() {
                try {
                    return cls.getDeclaredConstructor(args);
                }
                catch (SecurityException e) {
                    return null;
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
    }

    public static <T> Constructor<T> getConstructor(final Class<T> cls, final Class<?> ... args) {
        return (Constructor)AccessController.doPrivileged(new PrivilegedAction<Constructor<T>>(){

            @Override
            public Constructor<T> run() {
                try {
                    return cls.getConstructor(args);
                }
                catch (SecurityException e) {
                    return null;
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
    }

    public static Method[] getDeclaredMethods(final Class<?> cls) {
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return cls.getDeclaredMethods();
            }
        });
    }

    public static Field[] getDeclaredFields(final Class<?> cls) {
        return AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return cls.getDeclaredFields();
            }
        });
    }

    public static <T extends AccessibleObject> T setAccessible(final T o) {
        return (T)((AccessibleObject)AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                o.setAccessible(true);
                return o;
            }
        }));
    }

    public static <T extends AccessibleObject> T setAccessible(final T o, final boolean b) {
        return (T)((AccessibleObject)AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                o.setAccessible(b);
                return o;
            }
        }));
    }

    public static List<String> getPackagesFromJar(File jarFile) throws IOException {
        ArrayList<String> packageNames = new ArrayList<String>();
        if (jarFile.isDirectory()) {
            ReflectionUtil.getPackageNamesFromDir(jarFile, jarFile, packageNames);
        } else {
            JarResource resource = new JarResource();
            for (String item : resource.getJarContents(jarFile)) {
                String packageName;
                if (!item.endsWith(".class") || StringUtils.isEmpty(packageName = ReflectionUtil.getPackageName(item)) || packageNames.contains(packageName)) continue;
                packageNames.add(packageName);
            }
        }
        return packageNames;
    }

    private static void getPackageNamesFromDir(File base, File dir, List<String> pkgs) {
        boolean foundClass = false;
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                ReflectionUtil.getPackageNamesFromDir(base, file, pkgs);
                continue;
            }
            if (foundClass || !file.getName().endsWith(".class")) continue;
            foundClass = true;
            String pkg = "";
            file = dir;
            while (!file.equals(base)) {
                if (!"".equals(pkg)) {
                    pkg = "." + pkg;
                }
                pkg = file.getName() + pkg;
                file = file.getParentFile();
            }
            if (pkgs.contains(pkg)) continue;
            pkgs.add(pkg);
        }
    }

    private static String getPackageName(String clzName) {
        if (clzName.indexOf("/") == -1) {
            return null;
        }
        String packageName = clzName.substring(0, clzName.lastIndexOf("/"));
        return packageName.replace("/", ".");
    }

    public static PropertyDescriptor[] getPropertyDescriptorsAvoidSunBug(Class<?> refClass, BeanInfo beanInfo, Class<?> beanClass, PropertyDescriptor[] propertyDescriptors) {
        if (!springChecked) {
            try {
                springChecked = true;
                Class<?> cls = ClassLoaderUtils.loadClass("org.springframework.beans.BeanUtils", refClass);
                springBeanUtilsDescriptorFetcher = cls.getMethod("getPropertyDescriptor", Class.class, String.class);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (springBeanUtilsDescriptorFetcher != null) {
            if (propertyDescriptors != null) {
                ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>(propertyDescriptors.length);
                for (int i = 0; i < propertyDescriptors.length; ++i) {
                    PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
                    try {
                        propertyDescriptor = (PropertyDescriptor)springBeanUtilsDescriptorFetcher.invoke(null, beanClass, propertyDescriptor.getName());
                        if (propertyDescriptor == null) continue;
                        descriptors.add(propertyDescriptor);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e.getCause());
                    }
                }
                return descriptors.toArray(new PropertyDescriptor[descriptors.size()]);
            }
            return null;
        }
        return beanInfo.getPropertyDescriptors();
    }

    public static Method findMethod(Class<?> cls, String name, Class<?> ... params) {
        Method m;
        if (cls == null) {
            return null;
        }
        for (Class<?> cs : cls.getInterfaces()) {
            Method m2;
            if (!Modifier.isPublic(cs.getModifiers()) || (m2 = ReflectionUtil.findMethod(cs, name, params)) == null || !Modifier.isPublic(m2.getModifiers())) continue;
            return m2;
        }
        try {
            m = cls.getDeclaredMethod(name, params);
            if (m != null && Modifier.isPublic(m.getModifiers())) {
                return m;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        m = ReflectionUtil.findMethod(cls.getSuperclass(), name, params);
        if (m == null) {
            try {
                m = cls.getMethod(name, params);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return m;
    }

    public static <T extends Annotation> T getAnnotationForMethodOrContainingClass(Method m, Class<T> annotationType) {
        T annotation = m.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        return m.getDeclaringClass().getAnnotation(annotationType);
    }
}

