/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.types;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.CorbaTypeMap;
import org.apache.cxf.binding.corba.types.AbstractCorbaTypeListener;
import org.apache.cxf.binding.corba.types.CorbaHandlerUtils;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaStructHandler;
import org.apache.cxf.binding.corba.types.CorbaTypeListener;
import org.apache.cxf.binding.corba.utils.CorbaUtils;
import org.apache.cxf.binding.corba.wsdl.MemberType;
import org.apache.cxf.binding.corba.wsdl.Struct;
import org.apache.cxf.service.model.ServiceInfo;
import org.omg.CORBA.ORB;

public class CorbaStructListener
extends AbstractCorbaTypeListener {
    private final CorbaTypeMap typeMap;
    private final ORB orb;
    private List<MemberType> structMembers;
    private int memberCount;
    private CorbaTypeListener currentTypeListener;
    private ServiceInfo serviceInfo;
    private int depth;

    public CorbaStructListener(CorbaObjectHandler handler, CorbaTypeMap map, ORB orbRef, ServiceInfo sInfo) {
        super(handler);
        this.orb = orbRef;
        this.typeMap = map;
        this.structMembers = ((Struct)handler.getType()).getMember();
        this.serviceInfo = sInfo;
    }

    public void processStartElement(QName name) {
        if (this.depth == 0 && this.currentElement != null && !this.currentElement.equals(name)) {
            this.currentTypeListener = null;
        }
        ++this.depth;
        if (this.currentTypeListener == null) {
            QName elName = name;
            MemberType member = this.structMembers.get(this.memberCount);
            boolean anonType = false;
            if (member.isSetAnonschematype() && member.isAnonschematype()) {
                anonType = true;
                elName = CorbaUtils.getEmptyQName();
                this.currentElement = null;
            } else {
                this.currentElement = name;
            }
            this.currentTypeListener = CorbaHandlerUtils.getTypeListener(elName, member.getIdltype(), this.typeMap, this.orb, this.serviceInfo);
            this.currentTypeListener.setNamespaceContext(this.ctx);
            ((CorbaStructHandler)this.handler).addMember(this.currentTypeListener.getCorbaObject());
            ++this.memberCount;
            if (anonType) {
                this.currentTypeListener.getCorbaObject().setAnonymousType(true);
                this.currentTypeListener.processStartElement(name);
            }
        } else {
            this.currentTypeListener.processStartElement(name);
        }
    }

    public void processEndElement(QName name) {
        if (this.currentTypeListener != null) {
            this.currentTypeListener.processEndElement(name);
            --this.depth;
        }
    }

    public void processCharacters(String text) {
        this.currentTypeListener.processCharacters(text);
    }

    public void processWriteAttribute(String prefix, String namespaceURI, String localName, String value) {
        if (this.currentTypeListener != null) {
            this.currentTypeListener.processWriteAttribute(prefix, namespaceURI, localName, value);
        } else if ("type".equals(localName) && "http://www.w3.org/2001/XMLSchema-instance".equals(namespaceURI)) {
            String pfx = value.substring(0, value.indexOf(":"));
            String ns = this.ctx.getNamespaceURI(pfx);
            QName qn = new QName(ns, value.substring(value.indexOf(":") + 1));
            CorbaTypeListener l = CorbaHandlerUtils.getTypeListener(qn, qn, this.typeMap, this.orb, this.serviceInfo);
            this.handler = l.getCorbaObject();
            this.structMembers = ((Struct)this.handler.getType()).getMember();
        }
    }

    public void processWriteNamespace(String prefix, String namespaceURI) {
        if (this.currentTypeListener != null) {
            this.currentTypeListener.processWriteNamespace(prefix, namespaceURI);
        }
    }
}

