/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.java5;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.type.TypeCreationOptions;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.type.basic.BeanTypeInfo;
import org.apache.cxf.aegis.type.java5.AnnotationReader;
import org.apache.cxf.aegis.util.NamespaceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedTypeInfo
extends BeanTypeInfo {
    private final AnnotationReader annotationReader;

    public AnnotatedTypeInfo(TypeMapping tm, Class<?> typeClass, String ns, TypeCreationOptions typeCreationOptions) {
        this(tm, typeClass, ns, new AnnotationReader(), typeCreationOptions);
    }

    public AnnotatedTypeInfo(TypeMapping tm, Class<?> typeClass, String ns, AnnotationReader annotationReader, TypeCreationOptions typeCreationOptions) {
        super(typeClass, ns);
        this.annotationReader = annotationReader;
        this.setQualifyAttributes(typeCreationOptions.isQualifyAttributes());
        this.setQualifyElements(typeCreationOptions.isQualifyElements());
        this.setTypeMapping(tm);
        this.initialize();
    }

    @Override
    protected void mapProperty(PropertyDescriptor pd) {
        if (this.annotationReader.isIgnored(pd.getReadMethod())) {
            return;
        }
        String explicitNamespace = this.annotationReader.getNamespace(pd.getReadMethod());
        boolean mustQualify = null != explicitNamespace && !"".equals(explicitNamespace);
        String name = pd.getName();
        if (this.isAttribute(pd)) {
            this.mapAttribute(name, this.createMappedName(pd, mustQualify || this.isQualifyAttributes()));
        } else if (this.isElement(pd)) {
            this.mapElement(name, this.createMappedName(pd, mustQualify || this.isQualifyElements()));
        }
    }

    @Override
    protected boolean registerType(PropertyDescriptor desc) {
        Method readMethod = desc.getReadMethod();
        Class<?> type = this.annotationReader.getType(readMethod);
        return type == null && super.registerType(desc);
    }

    @Override
    protected boolean isAttribute(PropertyDescriptor desc) {
        return this.annotationReader.isAttribute(desc.getReadMethod());
    }

    @Override
    protected boolean isElement(PropertyDescriptor desc) {
        return !this.isAttribute(desc);
    }

    @Override
    protected QName createMappedName(PropertyDescriptor desc, boolean qualify) {
        QName name = this.createQName(desc);
        if (!qualify) {
            return new QName(null, name.getLocalPart());
        }
        return name;
    }

    protected QName createQName(PropertyDescriptor desc) {
        String namespace;
        String name = this.annotationReader.getName(desc.getReadMethod());
        if (name == null) {
            name = desc.getName();
        }
        if ((namespace = this.annotationReader.getNamespace(desc.getReadMethod())) == null) {
            namespace = this.annotationReader.getNamespace(this.getTypeClass());
        }
        if (namespace == null) {
            namespace = this.annotationReader.getNamespace(this.getTypeClass().getPackage());
        }
        if (namespace == null) {
            namespace = NamespaceHelper.makeNamespaceFromClassName(this.getTypeClass().getName(), "http");
        }
        return new QName(namespace, name);
    }

    @Override
    public boolean isNillable(QName name) {
        PropertyDescriptor desc = this.getPropertyDescriptorFromMappedName(name);
        if (this.annotationReader.isElement(desc.getReadMethod())) {
            return this.annotationReader.isNillable(desc.getReadMethod());
        }
        return super.isNillable(name);
    }

    @Override
    public int getMinOccurs(QName name) {
        PropertyDescriptor desc = this.getPropertyDescriptorFromMappedName(name);
        if (this.annotationReader.isElement(desc.getReadMethod())) {
            return this.annotationReader.getMinOccurs(desc.getReadMethod());
        }
        return super.getMinOccurs(name);
    }
}

