/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.uri;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.common.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URISupport {
    private URISupport() {
    }

    public static Map<String, String> parseQuery(String uri) throws URISyntaxException {
        try {
            HashMap<String, String> rc = new HashMap<String, String>();
            if (uri != null) {
                String[] parameters;
                for (String parameter : parameters = StringUtils.split(uri, "&")) {
                    int p = parameter.indexOf("=");
                    if (p >= 0) {
                        String name = URLDecoder.decode(parameter.substring(0, p), "UTF-8");
                        String value = URLDecoder.decode(parameter.substring(p + 1), "UTF-8");
                        rc.put(name, value);
                        continue;
                    }
                    rc.put(parameter, null);
                }
            }
            return rc;
        }
        catch (UnsupportedEncodingException e) {
            URISyntaxException se = new URISyntaxException(e.toString(), "Invalid encoding");
            se.initCause(e);
            throw se;
        }
    }

    public static Map<String, String> parseParameters(URI uri) throws URISyntaxException {
        String query = uri.getQuery();
        if (query == null) {
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            int idx = schemeSpecificPart.lastIndexOf(63);
            if (idx < 0) {
                return Collections.emptyMap();
            }
            query = schemeSpecificPart.substring(idx + 1);
        } else {
            query = URISupport.stripPrefix(query, "?");
        }
        return URISupport.parseQuery(query);
    }

    public static URI removeQuery(URI uri) throws URISyntaxException {
        return URISupport.createURIWithQuery(uri, null);
    }

    public static URI createURIWithQuery(URI uri, String query) throws URISyntaxException {
        return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), query, uri.getFragment());
    }

    public static CompositeData parseComposite(URI uri) throws URISyntaxException {
        CompositeData rc = new CompositeData();
        rc.scheme = uri.getScheme();
        String ssp = URISupport.stripPrefix(uri.getSchemeSpecificPart().trim(), "//").trim();
        URISupport.parseComposite(uri, rc, ssp);
        rc.fragment = uri.getFragment();
        return rc;
    }

    private static void parseComposite(URI uri, CompositeData rc, String ssp) throws URISyntaxException {
        String params;
        int p;
        if (!URISupport.checkParenthesis(ssp)) {
            throw new URISyntaxException(uri.toString(), "Not a matching number of '(' and ')' parenthesis");
        }
        int intialParen = ssp.indexOf("(");
        if (intialParen == 0) {
            rc.host = ssp.substring(0, intialParen);
            p = rc.host.indexOf("/");
            if (p >= 0) {
                rc.path = rc.host.substring(p);
                rc.host = rc.host.substring(0, p);
            }
            p = ssp.lastIndexOf(")");
            params = ssp.substring(p + 1).trim();
        } else {
            params = "";
        }
        p = params.indexOf("?");
        if (p >= 0) {
            if (p > 0) {
                rc.path = URISupport.stripPrefix(params.substring(0, p), "/");
            }
            rc.parameters = URISupport.parseQuery(params.substring(p + 1));
        } else {
            if (params.length() > 0) {
                rc.path = URISupport.stripPrefix(params, "/");
            }
            rc.parameters = Collections.emptyMap();
        }
    }

    public static String stripPrefix(String value, String prefix) {
        if (value.startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    public static URI stripScheme(URI uri) throws URISyntaxException {
        return new URI(URISupport.stripPrefix(uri.getSchemeSpecificPart().trim(), "//"));
    }

    public static String createQueryString(Map<String, String> options) throws URISyntaxException {
        try {
            if (options.size() > 0) {
                StringBuilder rc = new StringBuilder();
                boolean first = true;
                for (String key : options.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        rc.append("&");
                    }
                    String value = options.get(key);
                    rc.append(URLEncoder.encode(key, "UTF-8"));
                    rc.append("=");
                    rc.append(URLEncoder.encode(value, "UTF-8"));
                }
                return rc.toString();
            }
            return "";
        }
        catch (UnsupportedEncodingException e) {
            URISyntaxException se = new URISyntaxException(e.toString(), "Invalid encoding");
            se.initCause(e);
            throw se;
        }
    }

    public static URI createRemainingURI(URI originalURI, Map<String, String> params) throws URISyntaxException {
        String s = URISupport.createQueryString(params);
        if (s.length() == 0) {
            s = null;
        }
        return URISupport.createURIWithQuery(originalURI, s);
    }

    public static URI changeScheme(URI bindAddr, String scheme) throws URISyntaxException {
        return new URI(scheme, bindAddr.getUserInfo(), bindAddr.getHost(), bindAddr.getPort(), bindAddr.getPath(), bindAddr.getQuery(), bindAddr.getFragment());
    }

    public static boolean checkParenthesis(String str) {
        boolean result = true;
        if (str != null) {
            int open = 0;
            int closed = 0;
            int i = 0;
            while ((i = str.indexOf(40, i)) >= 0) {
                ++i;
                ++open;
            }
            i = 0;
            while ((i = str.indexOf(41, i)) >= 0) {
                ++i;
                ++closed;
            }
            result = open == closed;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompositeData {
        private String host;
        private String scheme;
        private String path;
        private URI[] components;
        private Map<String, String> parameters;
        private String fragment;

        public URI[] getComponents() {
            return this.components;
        }

        public String getFragment() {
            return this.fragment;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getPath() {
            return this.path;
        }

        public String getHost() {
            return this.host;
        }

        public URI toURI() throws URISyntaxException {
            StringBuilder sb = new StringBuilder();
            if (this.scheme != null) {
                sb.append(this.scheme);
                sb.append(':');
            }
            if (this.host != null && this.host.length() != 0) {
                sb.append(this.host);
            } else {
                sb.append('(');
                for (int i = 0; i < this.components.length; ++i) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append(this.components[i].toString());
                }
                sb.append(')');
            }
            if (this.path != null) {
                sb.append('/');
                sb.append(this.path);
            }
            if (!this.parameters.isEmpty()) {
                sb.append("?");
                sb.append(URISupport.createQueryString(this.parameters));
            }
            if (this.fragment != null) {
                sb.append("#");
                sb.append(this.fragment);
            }
            return new URI(sb.toString());
        }
    }
}

