/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AbstractTypeCreator;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.ParameterizedTypeFactory;
import org.apache.cxf.aegis.type.TypeClassInfo;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.type.basic.BeanType;
import org.apache.cxf.aegis.type.basic.XMLBeanTypeInfo;
import org.apache.cxf.aegis.type.java5.Java5TypeCreator;
import org.apache.cxf.aegis.util.NamespaceHelper;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLTypeCreator
extends AbstractTypeCreator {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLTypeCreator.class);
    private static List<Class> stopClasses = new ArrayList<Class>();
    private static final DocumentBuilderFactory AEGIS_DOCUMENT_BUILDER_FACTORY;
    private Map<String, Document> documents = new HashMap<String, Document>();
    private volatile XPathUtils xpathUtils;

    private synchronized XPathUtils getXPathUtils() {
        if (this.xpathUtils == null) {
            this.xpathUtils = new XPathUtils();
        }
        return this.xpathUtils;
    }

    private Document readAegisFile(InputStream is, final String path) throws IOException {
        Document doc;
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = AEGIS_DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOG.log(Level.SEVERE, "Unable to create a document builder, e");
            throw new RuntimeException("Unable to create a document builder, e");
        }
        documentBuilder.setErrorHandler(new ErrorHandler(){

            private String errorMessage(SAXParseException exception) {
                return MessageFormat.format("{0} at {1} line {2} column {3}.", exception.getMessage(), path, exception.getLineNumber(), exception.getColumnNumber());
            }

            private void throwDatabindingException(String message) {
                DatabindingException e = new DatabindingException(message);
                e.setMessage(message);
                throw e;
            }

            public void error(SAXParseException exception) throws SAXException {
                String message = this.errorMessage(exception);
                LOG.log(Level.SEVERE, message, exception);
                this.throwDatabindingException(message);
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                String message = this.errorMessage(exception);
                LOG.log(Level.SEVERE, message, exception);
                this.throwDatabindingException(message);
            }

            public void warning(SAXParseException exception) throws SAXException {
                LOG.log(Level.INFO, this.errorMessage(exception), exception);
            }
        });
        try {
            doc = documentBuilder.parse(is);
        }
        catch (SAXException e) {
            LOG.log(Level.SEVERE, "Error parsing Aegis file.", e);
            return null;
        }
        return doc;
    }

    protected Document getDocument(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (this.documents.containsKey(clazz.getName())) {
            return this.documents.get(clazz.getName());
        }
        String path = '/' + clazz.getName().replace('.', '/') + ".aegis.xml";
        InputStream is = clazz.getResourceAsStream(path);
        if (is == null) {
            this.documents.put(clazz.getName(), null);
            LOG.finest("Mapping file : " + path + " not found.");
            return null;
        }
        LOG.finest("Found mapping file : " + path);
        try {
            Document doc = this.readAegisFile(is, path);
            this.documents.put(clazz.getName(), doc);
            return doc;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error loading file " + path, e);
            this.documents.put(clazz.getName(), null);
            return null;
        }
    }

    @Override
    protected boolean isEnum(Class javaType) {
        Element mapping = this.findMapping(javaType);
        if (mapping != null) {
            return super.isEnum(javaType);
        }
        return this.nextCreator.isEnum(javaType);
    }

    @Override
    public AegisType createEnumType(TypeClassInfo info) {
        Element mapping = this.findMapping(info.getType());
        if (mapping != null) {
            return super.createEnumType(info);
        }
        return this.nextCreator.createEnumType(info);
    }

    @Override
    public AegisType createCollectionType(TypeClassInfo info) {
        if (info.getType() instanceof Class) {
            return this.createCollectionTypeFromGeneric(info);
        }
        return this.nextCreator.createCollectionType(info);
    }

    @Override
    public TypeClassInfo createClassInfo(PropertyDescriptor pd) {
        Element mapping = this.findMapping(pd.getReadMethod().getDeclaringClass());
        if (mapping == null) {
            return this.nextCreator.createClassInfo(pd);
        }
        Element propertyEl = this.getMatch(mapping, "./property[@name='" + pd.getName() + "']");
        if (propertyEl == null) {
            return this.nextCreator.createClassInfo(pd);
        }
        TypeClassInfo info = new TypeClassInfo();
        Type returnType = pd.getReadMethod().getGenericReturnType();
        info.setType(returnType);
        info.setDescription("property " + pd.getDisplayName());
        this.readMetadata(info, mapping, propertyEl);
        return info;
    }

    protected Element findMapping(Type type) {
        Class<?> clazz = TypeUtil.getTypeClass(type, false);
        if (clazz == null) {
            return null;
        }
        Document doc = this.getDocument(clazz);
        if (doc == null) {
            return null;
        }
        Element mapping = this.getMatch(doc, "/mappings/mapping[@uri='" + this.getTypeMapping().getMappingIdentifierURI() + "']");
        if (mapping == null) {
            mapping = this.getMatch(doc, "/mappings/mapping[not(@uri)]");
        }
        return mapping;
    }

    protected List<Element> findMappings(Type type) {
        Class<?> clazz = TypeUtil.getTypeClass(type, false);
        ArrayList<Element> mappings = new ArrayList<Element>();
        if (clazz == null) {
            return mappings;
        }
        Element top = this.findMapping(clazz);
        if (top != null) {
            mappings.add(top);
        }
        Class<?> parent = clazz;
        while (true) {
            Class<?>[] interfaces = parent.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> interfaze = interfaces[i];
                List<Element> interfaceMappings = this.findMappings(interfaze);
                mappings.addAll(interfaceMappings);
            }
            Class<?> sup = parent.getSuperclass();
            if (sup == null || stopClasses.contains(sup)) break;
            Element mapping = this.findMapping(sup);
            if (mapping != null) {
                mappings.add(mapping);
            }
            parent = sup;
        }
        return mappings;
    }

    @Override
    public AegisType createDefaultType(TypeClassInfo info) {
        Element mapping = this.findMapping(info.getType());
        List<Element> mappings = this.findMappings(info.getType());
        Class<?> relatedClass = TypeUtil.getTypeRelatedClass(info.getType());
        if (mapping != null || mappings.size() > 0) {
            String typeNameAtt = null;
            if (mapping != null) {
                typeNameAtt = DOMUtils.getAttributeValueEmptyNull(mapping, "name");
            }
            String extensibleElements = null;
            if (mapping != null) {
                extensibleElements = mapping.getAttribute("extensibleElements");
            }
            String extensibleAttributes = null;
            if (mapping != null) {
                extensibleAttributes = mapping.getAttribute("extensibleAttributes");
            }
            String defaultNS = NamespaceHelper.makeNamespaceFromClassName(relatedClass.getName(), "http");
            QName name = null;
            if (typeNameAtt != null) {
                name = NamespaceHelper.createQName(mapping, typeNameAtt, defaultNS);
                defaultNS = name.getNamespaceURI();
            }
            XMLBeanTypeInfo btinfo = new XMLBeanTypeInfo(relatedClass, mappings, defaultNS);
            btinfo.setTypeMapping(this.getTypeMapping());
            btinfo.setDefaultMinOccurs(this.getConfiguration().getDefaultMinOccurs());
            btinfo.setDefaultNillable(this.getConfiguration().isDefaultNillable());
            if (extensibleElements != null) {
                btinfo.setExtensibleElements(Boolean.valueOf(extensibleElements));
            } else {
                btinfo.setExtensibleElements(this.getConfiguration().isDefaultExtensibleElements());
            }
            if (extensibleAttributes != null) {
                btinfo.setExtensibleAttributes(Boolean.valueOf(extensibleAttributes));
            } else {
                btinfo.setExtensibleAttributes(this.getConfiguration().isDefaultExtensibleAttributes());
            }
            btinfo.setQualifyAttributes(this.getConfiguration().isQualifyAttributes());
            btinfo.setQualifyElements(this.getConfiguration().isQualifyElements());
            BeanType type = new BeanType(btinfo);
            if (name == null) {
                name = this.createQName(relatedClass);
            }
            type.setSchemaType(name);
            type.setTypeClass(info.getType());
            type.setTypeMapping(this.getTypeMapping());
            return type;
        }
        return this.nextCreator.createDefaultType(info);
    }

    @Override
    public TypeClassInfo createClassInfo(Method m, int index) {
        Element mapping = this.findMapping(m.getDeclaringClass());
        if (mapping == null) {
            return this.nextCreator.createClassInfo(m, index);
        }
        TypeClassInfo info = this.nextCreator.createClassInfo(m, index);
        if (info == null) {
            info = new TypeClassInfo();
        }
        info.setDescription("method " + m.getName() + " parameter " + index);
        if (index >= 0) {
            if (index >= m.getParameterTypes().length) {
                throw new DatabindingException("Method " + m + " does not have a parameter at index " + index);
            }
            List<Element> nodes = this.getMatches(mapping, "./method[@name='" + m.getName() + "']/parameter[@index='" + index + "']/parent::*");
            if (nodes.size() == 0) {
                return info;
            }
            Element bestMatch = this.getBestMatch(mapping, m, nodes);
            if (bestMatch == null) {
                return info;
            }
            info.setType(m.getGenericParameterTypes()[index]);
            Element parameter = this.getMatch(bestMatch, "parameter[@index='" + index + "']");
            this.readMetadata(info, mapping, parameter);
        } else {
            List<Element> nodes = this.getMatches(mapping, "./method[@name='" + m.getName() + "']/return-type/parent::*");
            if (nodes.size() == 0) {
                return info;
            }
            Element bestMatch = this.getBestMatch(mapping, m, nodes);
            if (bestMatch == null) {
                return info;
            }
            info.setType(m.getGenericReturnType());
            Element rtElement = DOMUtils.getFirstChildWithName(bestMatch, "", "return-type");
            this.readMetadata(info, mapping, rtElement);
        }
        return info;
    }

    protected void readMetadata(TypeClassInfo info, Element mapping, Element parameter) {
        String nillable;
        String flat;
        String max;
        info.setTypeName(this.createQName(parameter, DOMUtils.getAttributeValueEmptyNull(parameter, "typeName")));
        info.setMappedName(this.createQName(parameter, DOMUtils.getAttributeValueEmptyNull(parameter, "mappedName")));
        Class<?> relatedClass = TypeUtil.getTypeRelatedClass(info.getType());
        if (Collection.class.isAssignableFrom(relatedClass)) {
            Type componentType = this.getComponentType(mapping, parameter);
            if (componentType != null) {
                ParameterizedType fullType = ParameterizedTypeFactory.createParameterizedType(relatedClass, new Type[]{componentType});
                info.setType(fullType);
            }
        } else if (Map.class.isAssignableFrom(relatedClass)) {
            Object valueType;
            Object keyType = this.getKeyType(mapping, parameter);
            if (keyType != null) {
                info.setKeyType((Type)keyType);
            }
            if ((valueType = this.getValueType(mapping, parameter)) != null) {
                info.setValueType((Type)valueType);
            }
            if (keyType != null || valueType != null) {
                if (keyType == null || valueType == null) {
                    if (keyType == null) {
                        keyType = TypeUtil.getSingleTypeParameter(info.getType(), 0);
                    }
                    if (keyType == null) {
                        keyType = Object.class;
                    }
                    if (valueType == null) {
                        valueType = TypeUtil.getSingleTypeParameter(info.getType(), 1);
                    }
                    if (valueType == null) {
                        valueType = Object.class;
                    }
                }
                ParameterizedType fullType = ParameterizedTypeFactory.createParameterizedType(relatedClass, new Type[]{keyType, valueType});
                info.setType(fullType);
            }
        }
        this.setType(info, parameter);
        String min = DOMUtils.getAttributeValueEmptyNull(parameter, "minOccurs");
        if (min != null) {
            info.setMinOccurs(Long.parseLong(min));
        }
        if ((max = DOMUtils.getAttributeValueEmptyNull(parameter, "maxOccurs")) != null) {
            info.setMaxOccurs(Long.parseLong(max));
        }
        if ((flat = DOMUtils.getAttributeValueEmptyNull(parameter, "flat")) != null) {
            info.setFlat(Boolean.valueOf(flat.toLowerCase()));
        }
        if ((nillable = DOMUtils.getAttributeValueEmptyNull(parameter, "nillable")) != null) {
            info.setNillable((boolean)Boolean.valueOf(nillable.toLowerCase()));
        }
    }

    @Override
    protected AegisType getOrCreateGenericType(TypeClassInfo info) {
        AegisType type = null;
        if (info.getType() instanceof ParameterizedType) {
            type = this.createTypeFromGeneric(info.getType());
        }
        if (type == null) {
            type = super.getOrCreateGenericType(info);
        }
        return type;
    }

    private AegisType createTypeFromGeneric(Object cType) {
        if (cType instanceof TypeClassInfo) {
            return this.createTypeForClass((TypeClassInfo)cType);
        }
        if (cType instanceof Class) {
            return this.createType((Class)cType);
        }
        return null;
    }

    @Override
    protected AegisType getOrCreateMapKeyType(TypeClassInfo info) {
        AegisType type = null;
        if (info.getKeyType() != null) {
            type = this.createTypeFromGeneric(info.getKeyType());
        }
        if (type == null) {
            type = super.getOrCreateMapKeyType(info);
        }
        return type;
    }

    @Override
    protected AegisType getOrCreateMapValueType(TypeClassInfo info) {
        AegisType type = null;
        if (info.getType() instanceof ParameterizedType) {
            type = this.createTypeFromGeneric(info.getValueType());
        }
        if (type == null) {
            type = super.getOrCreateMapValueType(info);
        }
        return type;
    }

    private Type getComponentType(Element mapping, Element parameter) {
        String componentSpec = DOMUtils.getAttributeValueEmptyNull(parameter, "componentType");
        if (componentSpec == null) {
            return null;
        }
        return this.getGenericParameterFromSpec(mapping, componentSpec);
    }

    private Type getKeyType(Element mapping, Element parameter) {
        String spec = DOMUtils.getAttributeValueEmptyNull(parameter, "keyType");
        if (spec == null) {
            return null;
        }
        return this.getGenericParameterFromSpec(mapping, spec);
    }

    private Type getValueType(Element mapping, Element parameter) {
        String spec = DOMUtils.getAttributeValueEmptyNull(parameter, "valueType");
        if (spec == null) {
            return null;
        }
        return this.getGenericParameterFromSpec(mapping, spec);
    }

    private Type getGenericParameterFromSpec(Element mapping, String componentType) {
        if (componentType.startsWith("#")) {
            String name = componentType.substring(1);
            Element propertyEl = this.getMatch(mapping, "./component[@name='" + name + "']");
            if (propertyEl == null) {
                throw new DatabindingException("Could not find <component> element in mapping named '" + name + "'");
            }
            String className = DOMUtils.getAttributeValueEmptyNull(propertyEl, "class");
            if (className == null) {
                throw new DatabindingException("A 'class' attribute must be specified for <component> " + name);
            }
            return this.loadComponentClass(className);
        }
        return this.loadComponentClass(componentType);
    }

    private Class loadComponentClass(String componentType) {
        try {
            return ClassLoaderUtils.loadClass(componentType, this.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new DatabindingException("Unable to load component type class " + componentType, (Throwable)e);
        }
    }

    protected void setType(TypeClassInfo info, Element parameter) {
        String type = DOMUtils.getAttributeValueEmptyNull(parameter, "type");
        if (type != null) {
            try {
                Class<?> aegisTypeClass = ClassLoaderUtils.loadClass(type, this.getClass());
                info.setAegisTypeClass(Java5TypeCreator.castToAegisTypeClass(aegisTypeClass));
            }
            catch (ClassNotFoundException e) {
                throw new DatabindingException("Unable to load type class " + type, (Throwable)e);
            }
        }
    }

    private Element getBestMatch(Element mapping, Method method, List<Element> availableNodes) {
        List<Element> nodes = this.getMatches(mapping, "./method[@name='" + method.getName() + "']");
        if (availableNodes != null) {
            nodes.retainAll(availableNodes);
        }
        if (nodes.size() == 0) {
            return null;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            return nodes.get(0);
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            Iterator<Element> iterator = nodes.iterator();
            while (iterator.hasNext()) {
                Element element = iterator.next();
                Element match = this.getMatch(element, "parameter[@index='" + i + "']");
                if (match == null || DOMUtils.getAttributeValueEmptyNull(match, "class") == null || DOMUtils.getAttributeValueEmptyNull(match, "class").equals(parameterType.getName())) continue;
                iterator.remove();
            }
        }
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        Element bestCandidate = null;
        int highestSpecified = 0;
        for (Element element : nodes) {
            List<Element> params = DOMUtils.getChildrenWithName(element, "", "parameter");
            int availableParameters = params.size();
            if (availableParameters <= highestSpecified) continue;
            bestCandidate = element;
            highestSpecified = availableParameters;
        }
        return bestCandidate;
    }

    private Element getMatch(Node doc, String xpath) {
        return (Element)this.getXPathUtils().getValue(xpath, doc, XPathConstants.NODE);
    }

    private List<Element> getMatches(Node doc, String xpath) {
        NodeList nl = (NodeList)this.getXPathUtils().getValue(xpath, doc, XPathConstants.NODESET);
        ArrayList<Element> r = new ArrayList<Element>();
        for (int x = 0; x < nl.getLength(); ++x) {
            r.add((Element)nl.item(x));
        }
        return r;
    }

    protected QName createQName(Element e, String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        int index = value.indexOf(":");
        if (index == -1) {
            return new QName(this.getTypeMapping().getMappingIdentifierURI(), value);
        }
        String prefix = value.substring(0, index);
        String localName = value.substring(index + 1);
        String ns = DOMUtils.getNamespace(e, prefix);
        if (ns == null || localName == null) {
            throw new DatabindingException("Invalid QName in mapping: " + value);
        }
        return new QName(ns, localName, prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        stopClasses.add(Object.class);
        stopClasses.add(Exception.class);
        stopClasses.add(RuntimeException.class);
        stopClasses.add(Throwable.class);
        AEGIS_DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
        AEGIS_DOCUMENT_BUILDER_FACTORY.setNamespaceAware(true);
        String path = "/META-INF/cxf/aegis.xsd";
        InputStream is = XMLTypeCreator.class.getResourceAsStream(path);
        if (is != null) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                Schema aegisSchema = schemaFactory.newSchema(new StreamSource(is));
                AEGIS_DOCUMENT_BUILDER_FACTORY.setSchema(aegisSchema);
            }
            catch (Throwable e) {
                LOG.log(Level.INFO, "Could not set aegis schema.  Not validating.", e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

