/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.databinding.jaxb;

import com.sun.tools.xjc.api.ErrorListener;
import org.apache.cxf.tools.common.ToolException;
import org.xml.sax.SAXParseException;

public class JAXBBindErrorListener
implements ErrorListener {
    private boolean isVerbose;
    private String prefix = "Thrown by JAXB: ";
    private StringBuilder errors = new StringBuilder();
    private Exception firstException;

    public JAXBBindErrorListener(boolean verbose) {
        this.isVerbose = verbose;
    }

    public boolean hasErrors() {
        return this.errors.length() != 0;
    }

    public void throwError() {
        throw new ToolException(this.prefix + "\n" + this.errors.toString(), (Throwable)this.firstException);
    }

    public void error(SAXParseException exception) {
        if (this.errors.length() == 0) {
            this.errors.append(this.prefix);
        }
        this.errors.append("\n");
        if (exception.getLineNumber() > 0) {
            this.errors.append(exception.getLocalizedMessage() + "\n" + " at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + " of schema " + exception.getSystemId() + "\n");
        } else {
            this.errors.append(this.prefix + this.mapMessage(exception.getLocalizedMessage()) + "\n");
        }
        if (this.firstException == null) {
            this.firstException = exception;
            this.firstException.fillInStackTrace();
        }
    }

    public void fatalError(SAXParseException exception) {
        throw new ToolException(this.prefix + exception.getLocalizedMessage() + " of schema " + exception.getSystemId(), (Throwable)exception);
    }

    public void info(SAXParseException exception) {
        if (this.isVerbose) {
            System.out.println("JAXB Info: " + exception.toString() + " in schema " + exception.getSystemId());
        }
    }

    public void warning(SAXParseException exception) {
        if (this.isVerbose) {
            System.out.println("JAXB parsing schema warning " + exception.toString() + " in schema " + exception.getSystemId());
        }
    }

    private String mapMessage(String msg) {
        if (msg.contains("Use a class customization to resolve") && msg.contains("with the same name")) {
            int idx = msg.lastIndexOf("class customization") + 19;
            msg = msg.substring(0, idx) + " or the -autoNameResolution option" + msg.substring(idx);
        }
        return msg;
    }
}

