/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.persistence.jdbc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.persistence.PersistenceUtils;
import org.apache.cxf.ws.rm.persistence.RMMessage;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.persistence.RMStoreException;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations
public class RMTxStore
implements RMStore {
    public static final String DEFAULT_DATABASE_NAME = "rmdb";
    private static final String CREATE_DEST_SEQUENCES_TABLE_STMT = "CREATE TABLE CXF_RM_DEST_SEQUENCES (SEQ_ID VARCHAR(256) NOT NULL, ACKS_TO VARCHAR(1024) NOT NULL, LAST_MSG_NO DECIMAL(19, 0), ENDPOINT_ID VARCHAR(1024), ACKNOWLEDGED BLOB, PRIMARY KEY (SEQ_ID))";
    private static final String CREATE_SRC_SEQUENCES_TABLE_STMT = "CREATE TABLE CXF_RM_SRC_SEQUENCES (SEQ_ID VARCHAR(256) NOT NULL, CUR_MSG_NO DECIMAL(19, 0) DEFAULT 1 NOT NULL, LAST_MSG CHAR(1), EXPIRY DECIMAL(19, 0), OFFERING_SEQ_ID VARCHAR(256), ENDPOINT_ID VARCHAR(1024), PRIMARY KEY (SEQ_ID))";
    private static final String CREATE_MESSAGES_TABLE_STMT = "CREATE TABLE {0} (SEQ_ID VARCHAR(256) NOT NULL, MSG_NO DECIMAL(19, 0) NOT NULL, SEND_TO VARCHAR(256), CONTENT BLOB, PRIMARY KEY (SEQ_ID, MSG_NO))";
    private static final String INBOUND_MSGS_TABLE_NAME = "CXF_RM_INBOUND_MESSAGES";
    private static final String OUTBOUND_MSGS_TABLE_NAME = "CXF_RM_OUTBOUND_MESSAGES";
    private static final String CREATE_DEST_SEQUENCE_STMT_STR = "INSERT INTO CXF_RM_DEST_SEQUENCES (SEQ_ID, ACKS_TO, ENDPOINT_ID) VALUES(?, ?, ?)";
    private static final String CREATE_SRC_SEQUENCE_STMT_STR = "INSERT INTO CXF_RM_SRC_SEQUENCES VALUES(?, 1, '0', ?, ?, ?)";
    private static final String DELETE_DEST_SEQUENCE_STMT_STR = "DELETE FROM CXF_RM_DEST_SEQUENCES WHERE SEQ_ID = ?";
    private static final String DELETE_SRC_SEQUENCE_STMT_STR = "DELETE FROM CXF_RM_SRC_SEQUENCES WHERE SEQ_ID = ?";
    private static final String UPDATE_DEST_SEQUENCE_STMT_STR = "UPDATE CXF_RM_DEST_SEQUENCES SET LAST_MSG_NO = ?, ACKNOWLEDGED = ? WHERE SEQ_ID = ?";
    private static final String UPDATE_SRC_SEQUENCE_STMT_STR = "UPDATE CXF_RM_SRC_SEQUENCES SET CUR_MSG_NO = ?, LAST_MSG = ? WHERE SEQ_ID = ?";
    private static final String CREATE_MESSAGE_STMT_STR = "INSERT INTO {0} VALUES(?, ?, ?, ?)";
    private static final String DELETE_MESSAGE_STMT_STR = "DELETE FROM {0} WHERE SEQ_ID = ? AND MSG_NO = ?";
    private static final String SELECT_DEST_SEQUENCE_STMT_STR = "SELECT ACKS_TO, LAST_MSG_NO, ACKNOWLEDGED FROM CXF_RM_DEST_SEQUENCES WHERE SEQ_ID = ?";
    private static final String SELECT_SRC_SEQUENCE_STMT_STR = "SELECT CUR_MSG_NO, LAST_MSG, EXPIRY, OFFERING_SEQ_ID FROM CXF_RM_SRC_SEQUENCES WHERE SEQ_ID = ?";
    private static final String SELECT_DEST_SEQUENCES_STMT_STR = "SELECT SEQ_ID, ACKS_TO, LAST_MSG_NO, ACKNOWLEDGED FROM CXF_RM_DEST_SEQUENCES WHERE ENDPOINT_ID = ?";
    private static final String SELECT_SRC_SEQUENCES_STMT_STR = "SELECT SEQ_ID, CUR_MSG_NO, LAST_MSG, EXPIRY, OFFERING_SEQ_ID FROM CXF_RM_SRC_SEQUENCES WHERE ENDPOINT_ID = ?";
    private static final String SELECT_MESSAGES_STMT_STR = "SELECT MSG_NO, SEND_TO, CONTENT FROM {0} WHERE SEQ_ID = ?";
    private static final String CREATE_SCHEMA_STMT_STR = "CREATE SCHEMA {0}";
    private static final String[] SET_SCHEMA_STMT_STRS = new String[]{"SET SCHEMA {0}", "SET CURRENT_SCHEMA = {0}", "ALTER SESSION SET CURRENT_SCHEMA = {0}"};
    private static final String DERBY_TABLE_EXISTS_STATE = "X0Y32";
    private static final int ORACLE_TABLE_EXISTS_CODE = 955;
    private static final Logger LOG = LogUtils.getL7dLogger(RMTxStore.class);
    private Connection connection;
    private boolean createdConnection = true;
    private Lock writeLock = new ReentrantLock();
    private PreparedStatement createDestSequenceStmt;
    private PreparedStatement createSrcSequenceStmt;
    private PreparedStatement deleteDestSequenceStmt;
    private PreparedStatement deleteSrcSequenceStmt;
    private PreparedStatement updateDestSequenceStmt;
    private PreparedStatement updateSrcSequenceStmt;
    private PreparedStatement selectDestSequencesStmt;
    private PreparedStatement selectSrcSequencesStmt;
    private PreparedStatement selectDestSequenceStmt;
    private PreparedStatement selectSrcSequenceStmt;
    private PreparedStatement createInboundMessageStmt;
    private PreparedStatement createOutboundMessageStmt;
    private PreparedStatement deleteInboundMessageStmt;
    private PreparedStatement deleteOutboundMessageStmt;
    private PreparedStatement selectInboundMessagesStmt;
    private PreparedStatement selectOutboundMessagesStmt;
    private DataSource dataSource;
    private String driverClassName = "org.apache.derby.jdbc.EmbeddedDriver";
    private String url = MessageFormat.format("jdbc:derby:{0};create=true", "rmdb");
    private String userName;
    private String password;
    private String schemaName;
    private String tableExistsState = "X0Y32";
    private int tableExistsCode = 955;

    public void destroy() {
        if (this.connection != null && this.createdConnection) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void setDriverClassName(String dcn) {
        this.driverClassName = dcn;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setPassword(String p) {
        this.password = p;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUrl(String u) {
        this.url = u;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUserName(String un) {
        this.userName = un;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String sn) {
        if (sn != null && !Pattern.matches("[a-zA-Z\\d]{1,32}", sn)) {
            throw new IllegalArgumentException("Invalid schema name: " + sn);
        }
        this.schemaName = sn;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    public String getTableExistsState() {
        return this.tableExistsState;
    }

    public void setTableExistsState(String tableExistsState) {
        this.tableExistsState = tableExistsState;
    }

    public int getTableExistsCode() {
        return this.tableExistsCode;
    }

    public void setTableExistsCode(int tableExistsCode) {
        this.tableExistsCode = tableExistsCode;
    }

    public void setConnection(Connection c) {
        this.connection = c;
        this.createdConnection = false;
    }

    @Override
    public void createDestinationSequence(DestinationSequence seq) {
        String sequenceIdentifier = seq.getIdentifier().getValue();
        String endpointIdentifier = seq.getEndpointIdentifier();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.info("Creating destination sequence: " + sequenceIdentifier + ", (endpoint: " + endpointIdentifier + ")");
        }
        try {
            this.beginTransaction();
            this.createDestSequenceStmt.setString(1, sequenceIdentifier);
            String addr = seq.getAcksTo().getAddress().getValue();
            this.createDestSequenceStmt.setString(2, addr);
            this.createDestSequenceStmt.setString(3, endpointIdentifier);
            this.createDestSequenceStmt.execute();
            this.commit();
        }
        catch (SQLException ex) {
            this.abort();
            throw new RMStoreException(ex);
        }
    }

    @Override
    public void createSourceSequence(SourceSequence seq) {
        String sequenceIdentifier = seq.getIdentifier().getValue();
        String endpointIdentifier = seq.getEndpointIdentifier();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating source sequence: " + sequenceIdentifier + ", (endpoint: " + endpointIdentifier + ")");
        }
        try {
            this.beginTransaction();
            this.createSrcSequenceStmt.setString(1, sequenceIdentifier);
            Date expiry = seq.getExpires();
            this.createSrcSequenceStmt.setLong(2, expiry == null ? 0L : expiry.getTime());
            Identifier osid = seq.getOfferingSequenceIdentifier();
            this.createSrcSequenceStmt.setString(3, osid == null ? null : osid.getValue());
            this.createSrcSequenceStmt.setString(4, endpointIdentifier);
            this.createSrcSequenceStmt.execute();
            this.commit();
        }
        catch (SQLException ex) {
            this.abort();
            throw new RMStoreException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DestinationSequence getDestinationSequence(Identifier sid, ProtocolVariation protocol) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.info("Getting destination sequence for id: " + sid);
        }
        ResultSet res = null;
        try {
            PreparedStatement preparedStatement = this.selectDestSequenceStmt;
            synchronized (preparedStatement) {
                block21: {
                    this.selectDestSequenceStmt.setString(1, sid.getValue());
                    res = this.selectDestSequenceStmt.executeQuery();
                    if (!res.next()) break block21;
                    EndpointReferenceType acksTo = RMUtils.createReference(res.getString(1));
                    long lm = res.getLong(2);
                    InputStream is = res.getBinaryStream(3);
                    SequenceAcknowledgement ack = null;
                    if (null != is) {
                        ack = PersistenceUtils.getInstance().deserialiseAcknowledgment(is);
                    }
                    DestinationSequence destinationSequence = new DestinationSequence(sid, acksTo, lm, ack, protocol);
                    return destinationSequence;
                }
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.WARNING, new Message("SELECT_DEST_SEQ_FAILED_MSG", LOG, new Object[0]).toString(), ex);
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceSequence getSourceSequence(Identifier sid, ProtocolVariation protocol) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.info("Getting source sequences for id: " + sid);
        }
        ResultSet res = null;
        try {
            PreparedStatement preparedStatement = this.selectSrcSequenceStmt;
            synchronized (preparedStatement) {
                block21: {
                    this.selectSrcSequenceStmt.setString(1, sid.getValue());
                    res = this.selectSrcSequenceStmt.executeQuery();
                    if (!res.next()) break block21;
                    long cmn = res.getLong(1);
                    boolean lm = res.getBoolean(2);
                    long lval = res.getLong(3);
                    Date expiry = 0L == lval ? null : new Date(lval);
                    String oidValue = res.getString(4);
                    Identifier oi = null;
                    if (null != oidValue) {
                        oi = RMUtils.getWSRMFactory().createIdentifier();
                        oi.setValue(oidValue);
                    }
                    SourceSequence sourceSequence = new SourceSequence(sid, expiry, oi, cmn, lm, protocol);
                    return sourceSequence;
                }
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.WARNING, new Message("SELECT_SRC_SEQ_FAILED_MSG", LOG, new Object[0]).toString(), ex);
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException e) {}
            }
        }
        return null;
    }

    @Override
    public void removeDestinationSequence(Identifier sid) {
        try {
            this.beginTransaction();
            this.deleteDestSequenceStmt.setString(1, sid.getValue());
            this.deleteDestSequenceStmt.execute();
            this.commit();
        }
        catch (SQLException ex) {
            this.abort();
            throw new RMStoreException(ex);
        }
    }

    @Override
    public void removeSourceSequence(Identifier sid) {
        try {
            this.beginTransaction();
            this.deleteSrcSequenceStmt.setString(1, sid.getValue());
            this.deleteSrcSequenceStmt.execute();
            this.commit();
        }
        catch (SQLException ex) {
            this.abort();
            throw new RMStoreException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DestinationSequence> getDestinationSequences(String endpointIdentifier, ProtocolVariation protocol) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.info("Getting destination sequences for endpoint: " + endpointIdentifier);
        }
        ArrayList<DestinationSequence> seqs = new ArrayList<DestinationSequence>();
        ResultSet res = null;
        try {
            PreparedStatement preparedStatement = this.selectDestSequencesStmt;
            synchronized (preparedStatement) {
                this.selectDestSequencesStmt.setString(1, endpointIdentifier);
                res = this.selectDestSequencesStmt.executeQuery();
                while (res.next()) {
                    Identifier sid = new Identifier();
                    sid.setValue(res.getString(1));
                    EndpointReferenceType acksTo = RMUtils.createReference(res.getString(2));
                    long lm = res.getLong(3);
                    InputStream is = res.getBinaryStream(4);
                    SequenceAcknowledgement ack = null;
                    if (null != is) {
                        ack = PersistenceUtils.getInstance().deserialiseAcknowledgment(is);
                    }
                    DestinationSequence seq = new DestinationSequence(sid, acksTo, lm, ack, protocol);
                    seqs.add(seq);
                }
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.WARNING, new Message("SELECT_DEST_SEQ_FAILED_MSG", LOG, new Object[0]).toString(), ex);
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException e) {}
            }
        }
        return seqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SourceSequence> getSourceSequences(String endpointIdentifier, ProtocolVariation protocol) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.info("Getting source sequences for endpoint: " + endpointIdentifier);
        }
        ArrayList<SourceSequence> seqs = new ArrayList<SourceSequence>();
        ResultSet res = null;
        try {
            PreparedStatement preparedStatement = this.selectSrcSequencesStmt;
            synchronized (preparedStatement) {
                this.selectSrcSequencesStmt.setString(1, endpointIdentifier);
                res = this.selectSrcSequencesStmt.executeQuery();
                while (res.next()) {
                    Identifier sid = new Identifier();
                    sid.setValue(res.getString(1));
                    long cmn = res.getLong(2);
                    boolean lm = res.getBoolean(3);
                    long lval = res.getLong(4);
                    Date expiry = 0L == lval ? null : new Date(lval);
                    String oidValue = res.getString(5);
                    Identifier oi = null;
                    if (null != oidValue) {
                        oi = new Identifier();
                        oi.setValue(oidValue);
                    }
                    SourceSequence seq = new SourceSequence(sid, expiry, oi, cmn, lm, protocol);
                    seqs.add(seq);
                }
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.WARNING, new Message("SELECT_SRC_SEQ_FAILED_MSG", LOG, new Object[0]).toString(), ex);
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException e) {}
            }
        }
        return seqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<RMMessage> getMessages(Identifier sid, boolean outbound) {
        ArrayList<RMMessage> msgs = new ArrayList<RMMessage>();
        ResultSet res = null;
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = outbound ? this.selectOutboundMessagesStmt : this.selectInboundMessagesStmt;
            synchronized (preparedStatement) {
                stmt.setString(1, sid.getValue());
                res = stmt.executeQuery();
                while (res.next()) {
                    long mn = res.getLong(1);
                    String to = res.getString(2);
                    Blob blob = res.getBlob(3);
                    RMMessage msg = new RMMessage();
                    msg.setMessageNumber(mn);
                    msg.setTo(to);
                    msg.setContent(blob.getBinaryStream());
                    msgs.add(msg);
                }
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, new Message(outbound ? "SELECT_OUTBOUND_MSGS_FAILED_MSG" : "SELECT_INBOUND_MSGS_FAILED_MSG", LOG, new Object[0]).toString(), ex);
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException e) {}
            }
        }
        return msgs;
    }

    @Override
    public void persistIncoming(DestinationSequence seq, RMMessage msg) {
        try {
            this.beginTransaction();
            this.updateDestinationSequence(seq);
            if (msg != null && msg.getCachedOutputStream() != null) {
                this.storeMessage(seq.getIdentifier(), msg, false);
            }
            this.commit();
        }
        catch (SQLException ex) {
            this.abort();
            throw new RMStoreException(ex);
        }
        catch (IOException ex) {
            this.abort();
            throw new RMStoreException(ex);
        }
    }

    @Override
    public void persistOutgoing(SourceSequence seq, RMMessage msg) {
        try {
            this.beginTransaction();
            this.updateSourceSequence(seq);
            if (msg != null && msg.getCachedOutputStream() != null) {
                this.storeMessage(seq.getIdentifier(), msg, true);
            }
            this.commit();
        }
        catch (SQLException ex) {
            this.abort();
            throw new RMStoreException(ex);
        }
        catch (IOException ex) {
            this.abort();
            throw new RMStoreException(ex);
        }
    }

    @Override
    public void removeMessages(Identifier sid, Collection<Long> messageNrs, boolean outbound) {
        try {
            PreparedStatement stmt = outbound ? this.deleteOutboundMessageStmt : this.deleteInboundMessageStmt;
            this.beginTransaction();
            stmt.setString(1, sid.getValue());
            for (Long messageNr : messageNrs) {
                stmt.setLong(2, messageNr);
                stmt.execute();
            }
            this.commit();
        }
        catch (SQLException ex) {
            this.abort();
            throw new RMStoreException(ex);
        }
    }

    protected void beginTransaction() {
        this.writeLock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit() throws SQLException {
        try {
            this.connection.commit();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abort() {
        try {
            this.connection.rollback();
        }
        catch (SQLException ex) {
            LogUtils.log(LOG, Level.SEVERE, "ABORT_FAILED_MSG", ex);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeMessage(Identifier sid, RMMessage msg, boolean outbound) throws IOException, SQLException {
        String id = sid.getValue();
        long nr = msg.getMessageNumber();
        String to = msg.getTo();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Storing {0} message number {1} for sequence {2}, to = {3}", new Object[]{outbound ? "outbound" : "inbound", nr, id, to});
        }
        InputStream msgin = null;
        try {
            msgin = msg.getInputStream();
            PreparedStatement stmt = outbound ? this.createOutboundMessageStmt : this.createInboundMessageStmt;
            int i = 1;
            stmt.setString(i++, id);
            stmt.setLong(i++, nr);
            stmt.setString(i++, to);
            stmt.setBinaryStream(i++, msgin, (int)msg.getSize());
            stmt.execute();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Successfully stored {0} message number {1} for sequence {2}", new Object[]{outbound ? "outbound" : "inbound", nr, id});
            }
        }
        finally {
            if (msgin != null) {
                try {
                    msgin.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSourceSequence(SourceSequence seq) throws SQLException {
        PreparedStatement preparedStatement = this.updateSrcSequenceStmt;
        synchronized (preparedStatement) {
            this.updateSrcSequenceStmt.setLong(1, seq.getCurrentMessageNr());
            this.updateSrcSequenceStmt.setString(2, seq.isLastMessage() ? "1" : "0");
            this.updateSrcSequenceStmt.setString(3, seq.getIdentifier().getValue());
            this.updateSrcSequenceStmt.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDestinationSequence(DestinationSequence seq) throws SQLException, IOException {
        PreparedStatement preparedStatement = this.updateDestSequenceStmt;
        synchronized (preparedStatement) {
            long lastMessageNr = seq.getLastMessageNumber();
            this.updateDestSequenceStmt.setLong(1, lastMessageNr);
            InputStream is = PersistenceUtils.getInstance().serialiseAcknowledgment(seq.getAcknowledgment());
            this.updateDestSequenceStmt.setBinaryStream(2, is, is.available());
            this.updateDestSequenceStmt.setString(3, seq.getIdentifier().getValue());
            this.updateDestSequenceStmt.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTables() throws SQLException {
        Statement stmt = null;
        stmt = this.connection.createStatement();
        try {
            stmt.executeUpdate(CREATE_SRC_SEQUENCES_TABLE_STMT);
        }
        catch (SQLException ex) {
            if (!this.isTableExistsError(ex)) {
                throw ex;
            }
            LOG.fine("Table CXF_RM_SRC_SEQUENCES already exists.");
        }
        finally {
            stmt.close();
        }
        stmt = this.connection.createStatement();
        try {
            stmt.executeUpdate(CREATE_DEST_SEQUENCES_TABLE_STMT);
        }
        catch (SQLException ex) {
            if (!this.isTableExistsError(ex)) {
                throw ex;
            }
            LOG.fine("Table CXF_RM_DEST_SEQUENCES already exists.");
        }
        finally {
            stmt.close();
        }
        for (String tableName : new String[]{OUTBOUND_MSGS_TABLE_NAME, INBOUND_MSGS_TABLE_NAME}) {
            stmt = this.connection.createStatement();
            try {
                stmt.executeUpdate(MessageFormat.format(CREATE_MESSAGES_TABLE_STMT, tableName));
            }
            catch (SQLException ex) {
                if (!this.isTableExistsError(ex)) {
                    throw ex;
                }
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Table " + tableName + " already exists.");
            }
            finally {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCurrentSchema() throws SQLException {
        if (this.schemaName == null || this.connection == null) {
            return;
        }
        Statement stmt = this.connection.createStatement();
        try {
            stmt.executeUpdate(MessageFormat.format(CREATE_SCHEMA_STMT_STR, this.schemaName));
        }
        catch (SQLException ex) {
        }
        finally {
            stmt.close();
        }
        stmt = this.connection.createStatement();
        SQLException ex0 = null;
        for (int i = 0; i < SET_SCHEMA_STMT_STRS.length; ++i) {
            try {
                stmt.executeUpdate(MessageFormat.format(SET_SCHEMA_STMT_STRS[i], this.schemaName));
                break;
            }
            catch (SQLException ex) {
                ex.setNextException(ex0);
                ex0 = ex;
                if (i != SET_SCHEMA_STMT_STRS.length - 1) continue;
                throw ex0;
            }
            finally {
                if (ex0 == null || i == SET_SCHEMA_STMT_STRS.length - 1) {
                    stmt.close();
                }
            }
        }
    }

    private void createStatements() throws SQLException {
        this.createDestSequenceStmt = this.connection.prepareStatement(CREATE_DEST_SEQUENCE_STMT_STR);
        this.createSrcSequenceStmt = this.connection.prepareStatement(CREATE_SRC_SEQUENCE_STMT_STR);
        this.deleteDestSequenceStmt = this.connection.prepareStatement(DELETE_DEST_SEQUENCE_STMT_STR);
        this.deleteSrcSequenceStmt = this.connection.prepareStatement(DELETE_SRC_SEQUENCE_STMT_STR);
        this.updateDestSequenceStmt = this.connection.prepareStatement(UPDATE_DEST_SEQUENCE_STMT_STR);
        this.updateSrcSequenceStmt = this.connection.prepareStatement(UPDATE_SRC_SEQUENCE_STMT_STR);
        this.selectDestSequencesStmt = this.connection.prepareStatement(SELECT_DEST_SEQUENCES_STMT_STR);
        this.selectSrcSequencesStmt = this.connection.prepareStatement(SELECT_SRC_SEQUENCES_STMT_STR);
        this.selectDestSequenceStmt = this.connection.prepareStatement(SELECT_DEST_SEQUENCE_STMT_STR);
        this.selectSrcSequenceStmt = this.connection.prepareStatement(SELECT_SRC_SEQUENCE_STMT_STR);
        this.createInboundMessageStmt = this.connection.prepareStatement(MessageFormat.format(CREATE_MESSAGE_STMT_STR, INBOUND_MSGS_TABLE_NAME));
        this.createOutboundMessageStmt = this.connection.prepareStatement(MessageFormat.format(CREATE_MESSAGE_STMT_STR, OUTBOUND_MSGS_TABLE_NAME));
        this.deleteInboundMessageStmt = this.connection.prepareStatement(MessageFormat.format(DELETE_MESSAGE_STMT_STR, INBOUND_MSGS_TABLE_NAME));
        this.deleteOutboundMessageStmt = this.connection.prepareStatement(MessageFormat.format(DELETE_MESSAGE_STMT_STR, OUTBOUND_MSGS_TABLE_NAME));
        this.selectInboundMessagesStmt = this.connection.prepareStatement(MessageFormat.format(SELECT_MESSAGES_STMT_STR, INBOUND_MSGS_TABLE_NAME));
        this.selectOutboundMessagesStmt = this.connection.prepareStatement(MessageFormat.format(SELECT_MESSAGES_STMT_STR, OUTBOUND_MSGS_TABLE_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        if (null == this.connection) {
            LOG.log(Level.FINE, "Using derby.system.home: {0}", SystemPropertyAction.getProperty("derby.system.home"));
            if (null != this.dataSource) {
                try {
                    LOG.log(Level.FINE, "Using dataSource: " + this.dataSource);
                    this.connection = this.dataSource.getConnection();
                }
                catch (SQLException ex) {
                    LogUtils.log(LOG, Level.SEVERE, "CONNECT_EXC", ex);
                    return;
                }
            }
            assert (null != this.url);
            assert (null != this.driverClassName);
            try {
                Class.forName(this.driverClassName);
            }
            catch (ClassNotFoundException ex) {
                LogUtils.log(LOG, Level.SEVERE, "CONNECT_EXC", ex);
                return;
            }
            try {
                LOG.log(Level.FINE, "Using url: " + this.url);
                this.connection = DriverManager.getConnection(this.url, this.userName, this.password);
            }
            catch (SQLException ex) {
                LogUtils.log(LOG, Level.SEVERE, "CONNECT_EXC", ex);
                return;
            }
        }
        try {
            this.connection.setAutoCommit(true);
            this.setCurrentSchema();
            this.createTables();
            this.createStatements();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            LogUtils.log(LOG, Level.SEVERE, "CONNECT_EXC", ex);
            SQLException se = ex;
            while (se.getNextException() != null) {
                se = se.getNextException();
                LogUtils.log(LOG, Level.SEVERE, "CONNECT_EXC", se);
            }
            throw new RMStoreException(ex);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                this.connection.setAutoCommit(false);
            }
            catch (SQLException ex) {
                LogUtils.log(LOG, Level.SEVERE, "CONNECT_EXC", ex);
                throw new RMStoreException(ex);
            }
        }
    }

    Connection getConnection() {
        return this.connection;
    }

    public static void deleteDatabaseFiles() {
        RMTxStore.deleteDatabaseFiles(DEFAULT_DATABASE_NAME, true);
    }

    public static void deleteDatabaseFiles(String dbName, boolean now) {
        String dsh = SystemPropertyAction.getPropertyOrNull("derby.system.home");
        File root = null;
        File log = null;
        if (null == dsh) {
            log = new File("derby.log");
            root = new File(dbName);
        } else {
            log = new File(dsh, "derby.log");
            root = new File(dsh, dbName);
        }
        if (log.exists()) {
            if (now) {
                boolean deleted = log.delete();
                LOG.log(Level.FINE, "Deleted log file {0}: {1}", new Object[]{log, deleted});
            } else {
                log.deleteOnExit();
            }
        }
        if (root.exists()) {
            LOG.log(Level.FINE, "Trying to delete directory {0}", root);
            RMTxStore.recursiveDelete(root, now);
        }
    }

    private static void recursiveDelete(File dir, boolean now) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                RMTxStore.recursiveDelete(f, now);
                continue;
            }
            if (now) {
                f.delete();
                continue;
            }
            f.deleteOnExit();
        }
        if (now) {
            dir.delete();
        } else {
            dir.deleteOnExit();
        }
    }

    protected boolean isTableExistsError(SQLException ex) {
        return null != this.tableExistsState && this.tableExistsState.equals(ex.getSQLState()) || this.tableExistsCode == ex.getErrorCode();
    }
}

