/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.AsymmetricBinding;
import org.apache.cxf.ws.security.policy.model.Binding;
import org.apache.cxf.ws.security.policy.model.SymmetricBinding;
import org.apache.cxf.ws.security.policy.model.TransportBinding;
import org.apache.cxf.ws.security.wss4j.policyhandlers.AsymmetricBindingHandler;
import org.apache.cxf.ws.security.wss4j.policyhandlers.SymmetricBindingHandler;
import org.apache.cxf.ws.security.wss4j.policyhandlers.TransportBindingHandler;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.WSSecHeader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyBasedWSS4JOutInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    public static final String SECURITY_PROCESSED = PolicyBasedWSS4JOutInterceptor.class.getName() + ".DONE";
    public static final PolicyBasedWSS4JOutInterceptor INSTANCE = new PolicyBasedWSS4JOutInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyBasedWSS4JOutInterceptor.class);
    private PolicyBasedWSS4JOutInterceptorInternal ending;
    private SAAJOutInterceptor saajOut = new SAAJOutInterceptor();

    public PolicyBasedWSS4JOutInterceptor() {
        super("pre-protocol");
        this.getAfter().add(SAAJOutInterceptor.class.getName());
        this.ending = this.createEndingInterceptor();
    }

    @Override
    public void handleMessage(SoapMessage mc) throws Fault {
        if (mc.getContent(SOAPMessage.class) == null) {
            this.saajOut.handleMessage(mc);
        }
        mc.put(SECURITY_PROCESSED, (Object)Boolean.TRUE);
        mc.getInterceptorChain().add(this.ending);
    }

    @Override
    public void handleFault(SoapMessage message) {
        this.saajOut.handleFault(message);
    }

    public final PolicyBasedWSS4JOutInterceptorInternal createEndingInterceptor() {
        return new PolicyBasedWSS4JOutInterceptorInternal();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class PolicyBasedWSS4JOutInterceptorInternal
    implements PhaseInterceptor<SoapMessage> {
        @Override
        public void handleMessage(SoapMessage message) throws Fault {
            SOAPMessage saaj = message.getContent(SOAPMessage.class);
            boolean mustUnderstand = true;
            String actor = null;
            AssertionInfoMap aim = message.get(AssertionInfoMap.class);
            if (aim != null) {
                Binding transport = null;
                Collection ais = (Collection)aim.get(SP12Constants.TRANSPORT_BINDING);
                if (ais != null) {
                    for (AssertionInfo ai : ais) {
                        transport = (Binding)ai.getAssertion();
                        ai.setAsserted(true);
                    }
                }
                if ((ais = (Collection)aim.get(SP12Constants.ASYMMETRIC_BINDING)) != null) {
                    for (AssertionInfo ai : ais) {
                        transport = (Binding)ai.getAssertion();
                        ai.setAsserted(true);
                    }
                }
                if ((ais = (Collection)aim.get(SP12Constants.SYMMETRIC_BINDING)) != null) {
                    for (AssertionInfo ai : ais) {
                        transport = (Binding)ai.getAssertion();
                        ai.setAsserted(true);
                    }
                }
                if (transport == null && PolicyBasedWSS4JOutInterceptor.this.isRequestor(message)) {
                    transport = new TransportBinding(SP12Constants.INSTANCE, message.getExchange().getBus().getExtension(PolicyBuilder.class));
                }
                if (transport != null) {
                    WSSecHeader secHeader = new WSSecHeader(actor, mustUnderstand);
                    Element el = null;
                    try {
                        el = secHeader.insertSecurityHeader((Document)saaj.getSOAPPart());
                    }
                    catch (WSSecurityException e) {
                        throw new SoapFault(new org.apache.cxf.common.i18n.Message("SECURITY_FAILED", LOG, new Object[0]), (Throwable)e, message.getVersion().getSender());
                    }
                    try {
                        saaj.getSOAPHeader().removeChild((Node)el);
                        saaj.getSOAPHeader().appendChild((Node)el);
                    }
                    catch (SOAPException e) {
                        // empty catch block
                    }
                    WSSConfig config = (WSSConfig)message.getContextualProperty(WSSConfig.class.getName());
                    if (config == null) {
                        config = WSSConfig.getNewInstance();
                    }
                    this.translateProperties(message, config);
                    if (transport instanceof TransportBinding) {
                        new TransportBindingHandler(config, (TransportBinding)transport, saaj, secHeader, aim, message).handleBinding();
                    } else if (transport instanceof SymmetricBinding) {
                        new SymmetricBindingHandler(config, (SymmetricBinding)transport, saaj, secHeader, aim, message).handleBinding();
                    } else {
                        new AsymmetricBindingHandler(config, (AsymmetricBinding)transport, saaj, secHeader, aim, message).handleBinding();
                    }
                    if (el.getFirstChild() == null) {
                        el.getParentNode().removeChild(el);
                    }
                }
                if ((ais = (Collection)aim.get(SP12Constants.WSS10)) != null) {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
                if ((ais = (Collection)aim.get(SP12Constants.WSS11)) != null) {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
            }
        }

        @Override
        public Set<String> getAfter() {
            return Collections.emptySet();
        }

        @Override
        public Set<String> getBefore() {
            return Collections.emptySet();
        }

        @Override
        public String getId() {
            return PolicyBasedWSS4JOutInterceptorInternal.class.getName();
        }

        @Override
        public String getPhase() {
            return "post-protocol";
        }

        @Override
        public void handleFault(SoapMessage message) {
        }

        @Override
        public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
            return null;
        }

        private void translateProperties(SoapMessage msg, WSSConfig config) {
            String bspCompliant = (String)msg.getContextualProperty("ws-security.is-bsp-compliant");
            if ("1".equals(bspCompliant) || "true".equals(bspCompliant)) {
                config.setWsiBSPCompliant(true);
            } else if ("0".equals(bspCompliant) || "false".equals(bspCompliant)) {
                config.setWsiBSPCompliant(false);
            }
        }
    }
}

