/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.parser.Parser;
import org.apache.abdera.parser.ParserOptions;
import org.apache.abdera.writer.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAtomProvider<T extends Element>
implements MessageBodyWriter<T>,
MessageBodyReader<T> {
    private static final Abdera ATOM_ENGINE = new Abdera();
    private boolean autodetectCharset;
    private boolean formattedOutput;

    public long getSize(T element, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    public void writeTo(T element, Class<?> clazz, Type type, Annotation[] a, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        if (MediaType.APPLICATION_JSON_TYPE.isCompatible(mt)) {
            Writer w = ATOM_ENGINE.getWriterFactory().getWriter("json");
            element.writeTo(w, os);
        } else if (this.formattedOutput) {
            Writer w = ATOM_ENGINE.getWriterFactory().getWriter("prettyxml");
            element.writeTo(w, os);
        } else {
            element.writeTo(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T readFrom(Class<T> clazz, Type t, Annotation[] a, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        Parser parser;
        Parser parser2 = parser = ATOM_ENGINE.getParser();
        synchronized (parser2) {
            ParserOptions options = parser.getDefaultParserOptions();
            if (options != null) {
                options.setAutodetectCharset(this.autodetectCharset);
            }
        }
        Document doc = parser.parse(is);
        return (T)doc.getRoot();
    }

    public void setFormattedOutput(boolean formattedOutput) {
        this.formattedOutput = formattedOutput;
    }

    public void setAutodetectCharset(boolean autodetectCharset) {
        this.autodetectCharset = autodetectCharset;
    }
}

