/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wadlto.jaxb;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.catalog.OASISCatalogManagerHelper;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.tools.common.ToolConstants;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.URIParserUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomizationParser {
    private static final Logger LOG = LogUtils.getL7dLogger(CustomizationParser.class);
    private final List<InputSource> jaxbBindings = new ArrayList<InputSource>();
    private final List<InputSource> packageFiles = new ArrayList<InputSource>();
    private final List<String> compilerArgs = new ArrayList<String>();
    private Bus bus;
    private String wadlPath;

    public CustomizationParser(ToolContext env) {
        this.bus = env.get(Bus.class);
        this.wadlPath = (String)env.get("wadl");
    }

    public void parse(ToolContext env) {
        Object jaxbCompilerArgs;
        String[] bindingFiles = this.getBindingFiles(env);
        for (int i = 0; i < bindingFiles.length; ++i) {
            try {
                this.addBinding(bindingFiles[i]);
                continue;
            }
            catch (XMLStreamException xse) {
                Message msg = new Message("STAX_PARSER_ERROR", LOG, new Object[0]);
                throw new ToolException(msg, (Throwable)xse);
            }
        }
        if (env.get("noAddressBinding") == null) {
            this.compilerArgs.add("-extension");
            String name = "/org/apache/cxf/tools/common/jaxb/W3CEPRJaxbBinding.xml";
            if (JAXBUtils.isJAXB22()) {
                name = "/org/apache/cxf/tools/common/jaxb/W3CEPRJaxbBinding_jaxb22.xml";
            }
            URL bindingFileUrl = this.getClass().getResource(name);
            InputSource ins = new InputSource(bindingFileUrl.toString());
            this.jaxbBindings.add(ins);
        }
        if ((jaxbCompilerArgs = env.get("xjc")) != null) {
            String[] stringArray;
            if (jaxbCompilerArgs instanceof String) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)jaxbCompilerArgs;
            } else {
                stringArray = (String[])jaxbCompilerArgs;
            }
            String[] jaxbArgs = stringArray;
            this.compilerArgs.addAll(Arrays.asList(jaxbArgs));
        }
        for (String ns : env.getNamespacePackageMap().keySet()) {
            File file = org.apache.cxf.tools.util.JAXBUtils.getPackageMappingSchemaBindingFile(ns, env.mapPackageName(ns));
            this.packageFiles.add(new InputSource(file.toURI().toString()));
        }
    }

    private void addBinding(String bindingFile) throws XMLStreamException {
        Element root = null;
        try {
            URIResolver resolver = new URIResolver(bindingFile);
            root = DOMUtils.readXml(resolver.getInputStream()).getDocumentElement();
        }
        catch (Exception e1) {
            Message msg = new Message("CAN_NOT_READ_AS_ELEMENT", LOG, bindingFile);
            throw new ToolException(msg, (Throwable)e1);
        }
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(root);
        StaxUtils.toNextTag(reader);
        if (this.isValidJaxbBindingFile(reader)) {
            String schemaLocation = root.getAttribute("schemaLocation");
            String resolvedSchemaLocation = this.resolveByCatalog(schemaLocation);
            if (resolvedSchemaLocation == null) {
                resolvedSchemaLocation = schemaLocation.length() == 0 ? this.wadlPath : this.getBaseWadlPath() + schemaLocation;
            }
            InputSource tmpIns = null;
            try {
                tmpIns = this.convertToTmpInputSource(root, resolvedSchemaLocation);
            }
            catch (Exception e1) {
                Message msg = new Message("FAILED_TO_ADD_SCHEMALOCATION", LOG, bindingFile);
                throw new ToolException(msg, (Throwable)e1);
            }
            this.jaxbBindings.add(tmpIns);
        }
    }

    private String getBaseWadlPath() {
        int lastSep = this.wadlPath.lastIndexOf("/");
        return lastSep != -1 ? this.wadlPath.substring(0, lastSep + 1) : this.wadlPath;
    }

    private InputSource convertToTmpInputSource(Element ele, String schemaLoc) throws Exception {
        InputSource result = null;
        ele.setAttribute("schemaLocation", schemaLoc);
        File tmpFile = FileUtils.createTempFile("jaxbbinding", ".xml");
        XMLUtils.writeTo((Node)ele, (OutputStream)new FileOutputStream(tmpFile));
        result = new InputSource(URIParserUtil.getAbsoluteURI(tmpFile.getAbsolutePath()));
        tmpFile.deleteOnExit();
        return result;
    }

    private String resolveByCatalog(String url) {
        if (StringUtils.isEmpty(url)) {
            return null;
        }
        OASISCatalogManager catalogResolver = OASISCatalogManager.getCatalogManager(this.bus);
        try {
            return new OASISCatalogManagerHelper().resolve(catalogResolver, url, null);
        }
        catch (Exception e1) {
            Message msg = new Message("FAILED_RESOLVE_CATALOG", LOG, url);
            throw new ToolException(msg, (Throwable)e1);
        }
    }

    private boolean isValidJaxbBindingFile(XMLStreamReader reader) {
        return ToolConstants.JAXB_BINDINGS.equals(reader.getName());
    }

    private String[] getBindingFiles(ToolContext env) {
        Object files = env.get("binding");
        if (files != null) {
            String[] stringArray;
            if (files instanceof String) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)files;
            } else {
                stringArray = (String[])files;
            }
            return stringArray;
        }
        return new String[0];
    }

    public List<InputSource> getJaxbBindings() {
        return this.jaxbBindings;
    }

    public List<InputSource> getSchemaPackageFiles() {
        return this.packageFiles;
    }

    public List<String> getCompilerArgs() {
        return this.compilerArgs;
    }
}

