/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common.idltypes;

import java.io.PrintWriter;
import java.util.List;
import org.apache.cxf.tools.corba.common.idltypes.IdlDefn;
import org.apache.cxf.tools.corba.common.idltypes.IdlField;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopeBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IdlStructBase
extends IdlScopeBase
implements IdlType {
    private String kind;

    protected IdlStructBase(IdlScopeBase parent, String name, String type) {
        super(parent, name);
        this.kind = new String(type);
    }

    void addField(IdlField f) {
        this.addToScope(f);
    }

    @Override
    public void write(PrintWriter pw) {
        pw.println(IdlStructBase.indent() + this.kind + " " + this.localName() + " {");
        IdlStructBase.indentMore();
        super.write(pw);
        IdlStructBase.indentLess();
        pw.println(IdlStructBase.indent() + "};");
    }

    @Override
    public void writeFwd(PrintWriter pw) {
        if (this.isCircular()) {
            pw.println(IdlStructBase.indent() + this.kind + " " + this.localName() + ";");
        }
    }

    @Override
    public boolean isEmptyDef() {
        if (this.isCircular()) {
            return false;
        }
        if (this.definitions().size() == 0) {
            return true;
        }
        boolean hasNonEmptyMembers = false;
        for (IdlDefn defn : this.definitions()) {
            if (defn.isEmptyDef()) continue;
            hasNonEmptyMembers = true;
            break;
        }
        return !hasNonEmptyMembers;
    }

    @Override
    public IdlScopeBase getCircularScope(IdlScopeBase startScope, List<Object> doneDefn) {
        if (startScope == null) {
            startScope = this;
        }
        return super.getCircularScope(startScope, doneDefn);
    }
}

