/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.ProtectionToken;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectionTokenBuilder
implements AssertionBuilder<Element> {
    PolicyBuilder builder;

    public ProtectionTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.PROTECTION_TOKEN, SP12Constants.PROTECTION_TOKEN};
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        ProtectionToken protectionToken = new ProtectionToken(consts, this.builder);
        Policy policy = this.builder.getPolicy(DOMUtils.getFirstElement(element));
        Iterator iterator = (policy = policy.normalize(this.builder.getPolicyRegistry(), false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), protectionToken);
        }
        return protectionToken;
    }

    private void processAlternative(List assertions, ProtectionToken parent) {
        Object token = assertions.get(0);
        if (token instanceof Token) {
            parent.setToken((Token)token);
        }
    }
}

