/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.sql;

import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchConditionVisitor;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLPrinterVisitor<T>
implements SearchConditionVisitor<T> {
    private static final Logger LOG = LogUtils.getL7dLogger(SQLPrinterVisitor.class);
    private StringBuilder sb;
    private String table;
    private String[] columns;
    private Map<String, String> fieldMap;

    public SQLPrinterVisitor(String table, String ... columns) {
        this((Map<String, String>)null, table, columns);
    }

    public SQLPrinterVisitor(Map<String, String> fieldMap, String table, String ... columns) {
        this.fieldMap = fieldMap;
        this.columns = columns;
        this.table = table;
    }

    @Override
    public void visit(SearchCondition<T> sc) {
        PrimitiveStatement statement;
        if (this.sb == null) {
            this.sb = new StringBuilder();
            if (this.table != null) {
                SearchUtils.startSqlQuery(this.sb, this.table, this.columns);
            }
        }
        if ((statement = sc.getStatement()) != null) {
            if (statement.getProperty() != null) {
                String rvalStr = statement.getValue().toString().replaceAll("\\*", "%");
                String name = statement.getProperty();
                if (this.fieldMap != null) {
                    if (this.fieldMap.containsKey(name)) {
                        name = this.fieldMap.get(name);
                    } else {
                        LOG.warning("Unrecognized field alias : " + name);
                        return;
                    }
                }
                this.sb.append(name).append(" ").append(SearchUtils.conditionTypeToSqlOperator(sc.getConditionType(), rvalStr)).append(" ").append("'").append(rvalStr).append("'");
            }
        } else {
            boolean first = true;
            for (SearchCondition<T> condition : sc.getSearchConditions()) {
                if (!first) {
                    this.sb.append(" ").append(sc.getConditionType().toString()).append(" ");
                } else {
                    first = false;
                }
                this.sb.append("(");
                condition.accept(this);
                this.sb.append(")");
            }
        }
    }

    @Override
    public String getResult() {
        return this.sb == null ? null : this.sb.toString();
    }
}

