/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.spi.ServiceDelegate;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.ServiceContractResolverRegistry;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.DispatchImpl;
import org.apache.cxf.jaxws.JaxWsClientFactoryBean;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.binding.soap.JaxWsSoapBindingConfiguration;
import org.apache.cxf.jaxws.handler.HandlerResolverImpl;
import org.apache.cxf.jaxws.handler.PortInfoImpl;
import org.apache.cxf.jaxws.support.BindingID;
import org.apache.cxf.jaxws.support.DummyImpl;
import org.apache.cxf.jaxws.support.JaxWsClientEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.tools.common.extensions.soap.SoapAddress;
import org.apache.cxf.tools.common.extensions.soap.SoapBinding;
import org.apache.cxf.tools.util.URIParserUtil;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.workqueue.OneShotAsyncExecutor;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.VersionTransformer;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl.http.AddressType;
import org.apache.cxf.wsdl11.WSDLServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceImpl
extends ServiceDelegate {
    private static final Logger LOG = LogUtils.getL7dLogger(ServiceImpl.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();
    private Bus bus;
    private String wsdlURL;
    private HandlerResolver handlerResolver;
    private Executor executor;
    private QName serviceName;
    private Class<?> clazz;
    private Map<QName, PortInfoImpl> portInfos = new HashMap<QName, PortInfoImpl>();
    private WebServiceFeature[] serviceFeatures;

    public ServiceImpl(Bus b, URL url, QName name, Class<?> cls, WebServiceFeature ... f) {
        URI uri;
        ServiceContractResolverRegistry registry;
        this.bus = b;
        this.serviceName = name;
        this.clazz = cls;
        this.serviceFeatures = f;
        this.handlerResolver = new HandlerResolverImpl(this.bus, name, this.clazz);
        if (null == url && null != this.bus && null != (registry = this.bus.getExtension(ServiceContractResolverRegistry.class)) && null != (uri = registry.getContractLocation(name))) {
            try {
                url = uri.toURL();
            }
            catch (MalformedURLException e) {
                LOG.log(Level.FINE, "resolve qname failed", name);
                throw new WebServiceException((Throwable)e);
            }
        }
        String string = this.wsdlURL = url == null ? null : url.toString();
        if (url != null) {
            try {
                this.initializePorts();
            }
            catch (ServiceConstructionException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
    }

    private void initializePorts() {
        try {
            Definition def = this.bus.getExtension(WSDLManager.class).getDefinition(this.wsdlURL);
            javax.wsdl.Service serv = def.getService(this.serviceName);
            if (serv == null) {
                throw new WebServiceException("Could not find service named " + this.serviceName + " in wsdl " + this.wsdlURL);
            }
            Map wsdlports = CastUtils.cast(serv.getPorts());
            for (Port port : wsdlports.values()) {
                ExtensibilityElement e;
                QName name = new QName(this.serviceName.getNamespaceURI(), port.getName());
                String tpId = null;
                String address = null;
                String bindingID = null;
                List extensions = CastUtils.cast(port.getBinding().getExtensibilityElements());
                if (!extensions.isEmpty()) {
                    e = (ExtensibilityElement)extensions.get(0);
                    if (e instanceof SoapBinding) {
                        bindingID = "http://schemas.xmlsoap.org/wsdl/soap/http";
                    } else if (e instanceof SOAP12Binding) {
                        bindingID = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
                    } else if (e instanceof SOAPBinding) {
                        bindingID = "http://schemas.xmlsoap.org/wsdl/soap/http";
                    }
                }
                if (!(extensions = CastUtils.cast(port.getExtensibilityElements())).isEmpty()) {
                    e = (ExtensibilityElement)extensions.get(0);
                    if (tpId == null) {
                        tpId = e.getElementType().getNamespaceURI();
                    }
                    if (e instanceof SoapAddress) {
                        address = ((SoapAddress)e).getLocationURI();
                    } else if (e instanceof AddressType) {
                        address = ((AddressType)e).getLocation();
                    } else if (e instanceof SOAP12Address) {
                        address = ((SOAP12Address)e).getLocationURI();
                    } else if (e instanceof SOAPAddress) {
                        address = ((SOAPAddress)e).getLocationURI();
                    }
                }
                this.addPort(name, bindingID, address);
            }
        }
        catch (WebServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            WSDLServiceFactory sf = new WSDLServiceFactory(this.bus, this.wsdlURL, this.serviceName);
            Service service = sf.create();
            for (ServiceInfo si : service.getServiceInfos()) {
                for (EndpointInfo ei : si.getEndpoints()) {
                    String bindingID = BindingID.getJaxwsBindingID(ei.getTransportId());
                    this.addPort(ei.getName(), bindingID, ei.getAddress());
                }
            }
        }
    }

    public final void addPort(QName portName, String bindingId, String address) {
        PortInfoImpl portInfo = new PortInfoImpl(bindingId, portName, this.serviceName);
        portInfo.setAddress(address);
        this.portInfos.put(portName, portInfo);
    }

    private WebServiceFeature[] getAllFeatures(WebServiceFeature[] features) {
        if (this.serviceFeatures == null || this.serviceFeatures.length == 0) {
            return features;
        }
        if (features == null || features.length == 0) {
            return this.serviceFeatures;
        }
        ArrayList<WebServiceFeature> f = new ArrayList<WebServiceFeature>(Arrays.asList(features));
        f.addAll(Arrays.asList(this.serviceFeatures));
        return f.toArray(new WebServiceFeature[f.size()]);
    }

    private JaxWsClientEndpointImpl getJaxwsEndpoint(QName portName, AbstractServiceFactoryBean sf, WebServiceFeature ... features) {
        PortInfoImpl portInfo;
        Service service = sf.getService();
        EndpointInfo ei = null;
        if (portName == null) {
            ei = service.getServiceInfos().get(0).getEndpoints().iterator().next();
        } else {
            ei = service.getEndpointInfo(portName);
            if (ei == null && null != (portInfo = this.getPortInfo(portName))) {
                try {
                    ei = this.createEndpointInfo(sf, portName, portInfo);
                }
                catch (BusException e) {
                    throw new WebServiceException((Throwable)e);
                }
            }
        }
        if (ei == null) {
            Message msg = new Message("INVALID_PORT", BUNDLE, portName);
            throw new WebServiceException(msg.toString());
        }
        portInfo = this.getPortInfo(portName);
        if (portInfo != null && !portInfo.getAddress().equals(ei.getAddress())) {
            ei.setAddress(portInfo.getAddress());
        }
        try {
            return new JaxWsClientEndpointImpl(this.bus, service, ei, this, this.getAllFeatures(features));
        }
        catch (EndpointException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private AbstractServiceFactoryBean createDispatchService(DataBinding db) {
        AbstractServiceFactoryBean serviceFactory;
        AbstractServiceFactoryBean sf;
        Service dispatchService = null;
        if (null != this.wsdlURL) {
            sf = new WSDLServiceFactory(this.bus, this.wsdlURL, this.serviceName);
            dispatchService = ((WSDLServiceFactory)sf).create();
            dispatchService.setDataBinding(db);
            serviceFactory = sf;
        } else {
            sf = new JaxWsServiceFactoryBean();
            sf.setBus(this.bus);
            ((ReflectionServiceFactoryBean)sf).setServiceName(this.serviceName);
            ((ReflectionServiceFactoryBean)sf).setServiceClass(DummyImpl.class);
            sf.setDataBinding(db);
            dispatchService = ((ReflectionServiceFactoryBean)sf).create();
            serviceFactory = sf;
        }
        this.configureObject(dispatchService);
        for (ServiceInfo si : dispatchService.getServiceInfos()) {
            si.setProperty("soap.force.doclit.bare", Boolean.TRUE);
        }
        return serviceFactory;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public HandlerResolver getHandlerResolver() {
        return this.handlerResolver;
    }

    public <T> T getPort(Class<T> serviceEndpointInterface) {
        return this.getPort(serviceEndpointInterface, new WebServiceFeature[0]);
    }

    public <T> T getPort(Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        try {
            return this.createPort(null, null, serviceEndpointInterface, features);
        }
        catch (ServiceConstructionException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public <T> T getPort(QName portName, Class<T> serviceEndpointInterface) {
        return this.getPort(portName, serviceEndpointInterface, new WebServiceFeature[0]);
    }

    public <T> T getPort(QName portName, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        if (portName == null) {
            throw new WebServiceException(BUNDLE.getString("PORT_NAME_NULL_EXC"));
        }
        if (!this.portInfos.containsKey(portName)) {
            throw new WebServiceException(new Message("INVALID_PORT", BUNDLE, portName).toString());
        }
        try {
            return this.createPort(portName, null, serviceEndpointInterface, features);
        }
        catch (ServiceConstructionException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public <T> T getPort(EndpointReferenceType endpointReference, Class<T> type) {
        return this.getPort(endpointReference, type, new WebServiceFeature[0]);
    }

    public <T> T getPort(EndpointReferenceType endpointReference, Class<T> type, WebServiceFeature ... features) {
        endpointReference = EndpointReferenceUtils.resolve(endpointReference, this.bus);
        QName serviceQName = EndpointReferenceUtils.getServiceName(endpointReference, this.bus);
        String portName = EndpointReferenceUtils.getPortName(endpointReference);
        QName portQName = null;
        if (portName != null && serviceQName != null) {
            String ns = serviceQName.getNamespaceURI();
            if (StringUtils.isEmpty(ns)) {
                for (QName qn : this.portInfos.keySet()) {
                    if (!portName.equals(qn.getLocalPart())) continue;
                    ns = qn.getNamespaceURI();
                }
            }
            if (StringUtils.isEmpty(ns) && this.serviceName != null) {
                ns = this.serviceName.getNamespaceURI();
            }
            portQName = new QName(ns, portName);
        }
        return this.createPort(portQName, endpointReference, type, features);
    }

    public Iterator<QName> getPorts() {
        return this.portInfos.keySet().iterator();
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public URL getWSDLDocumentLocation() {
        try {
            return new URL(this.wsdlURL);
        }
        catch (MalformedURLException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public void setExecutor(Executor e) {
        this.executor = e;
    }

    public void setHandlerResolver(HandlerResolver hr) {
        this.handlerResolver = hr;
    }

    public Bus getBus() {
        return this.bus;
    }

    protected <T> T createPort(QName portName, EndpointReferenceType epr, Class<T> serviceEndpointInterface) {
        return this.createPort(portName, epr, serviceEndpointInterface, new WebServiceFeature[0]);
    }

    protected <T> T createPort(QName portName, EndpointReferenceType epr, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        PortInfoImpl portInfo;
        LOG.log(Level.FINE, "creating port for portName", portName);
        LOG.log(Level.FINE, "endpoint reference:", epr);
        LOG.log(Level.FINE, "endpoint interface:", serviceEndpointInterface);
        JaxWsProxyFactoryBean proxyFac = new JaxWsProxyFactoryBean();
        JaxWsClientFactoryBean clientFac = (JaxWsClientFactoryBean)proxyFac.getClientFactoryBean();
        JaxWsServiceFactoryBean serviceFactory = (JaxWsServiceFactoryBean)proxyFac.getServiceFactory();
        proxyFac.initFeatures();
        WebServiceFeature[] f = this.getAllFeatures(features);
        if (f != null) {
            serviceFactory.setWsFeatures(Arrays.asList(f));
        }
        proxyFac.setBus(this.bus);
        proxyFac.setServiceClass(serviceEndpointInterface);
        proxyFac.setServiceName(this.serviceName);
        if (epr != null && epr.getAddress() != null && epr.getAddress().getValue() != null) {
            clientFac.setAddress(epr.getAddress().getValue());
        }
        if (this.wsdlURL != null) {
            proxyFac.setWsdlURL(this.wsdlURL);
        }
        this.configureObject(proxyFac);
        this.configureObject(clientFac);
        if (portName == null) {
            EndpointInfo ei;
            QName portTypeName = this.getPortTypeName(serviceEndpointInterface);
            Service service = serviceFactory.getService();
            if (service == null) {
                serviceFactory.setServiceClass(serviceEndpointInterface);
                serviceFactory.setBus(this.getBus());
                service = serviceFactory.create();
            }
            portName = (ei = ServiceModelUtil.findBestEndpointInfo(portTypeName, service.getServiceInfos())) != null ? ei.getName() : serviceFactory.getEndpointName();
        }
        serviceFactory.setEndpointName(portName);
        if (epr != null) {
            clientFac.setEndpointReference(epr);
        }
        if ((portInfo = this.portInfos.get(portName)) != null) {
            clientFac.setBindingId(portInfo.getBindingID());
            clientFac.setAddress(portInfo.getAddress());
        }
        if (this.clazz != ServiceImpl.class) {
            proxyFac.setLoadHandlers(false);
        }
        Object obj = proxyFac.create();
        Service service = serviceFactory.getService();
        service.setExecutor(new Executor(){

            public void execute(Runnable command) {
                Executor ex = ServiceImpl.this.getExecutor();
                if (ex == null) {
                    ex = OneShotAsyncExecutor.getInstance();
                }
                ex.execute(command);
            }
        });
        this.configureObject(service);
        Client client = ClientProxy.getClient(obj);
        client.getEndpoint().setExecutor(this.executor);
        client.setExecutor(this.executor);
        JaxWsEndpointImpl jaxwsEndpoint = (JaxWsEndpointImpl)client.getEndpoint();
        this.configureObject(jaxwsEndpoint);
        List hc = jaxwsEndpoint.getJaxwsBinding().getHandlerChain();
        hc.addAll(this.handlerResolver.getHandlerChain((PortInfo)this.portInfos.get(portName)));
        jaxwsEndpoint.getJaxwsBinding().setHandlerChain(hc);
        LOG.log(Level.FINE, "created proxy", obj);
        if (portInfo == null) {
            this.addPort(portName, clientFac.getBindingId(), clientFac.getAddress());
        }
        return serviceEndpointInterface.cast(obj);
    }

    private EndpointInfo createEndpointInfo(AbstractServiceFactoryBean serviceFactory, QName portName, PortInfoImpl portInfo) throws BusException {
        EndpointInfo ei = null;
        String address = portInfo.getAddress();
        String bindingID = BindingID.getBindingID(portInfo.getBindingID());
        DestinationFactoryManager dfm = this.bus.getExtension(DestinationFactoryManager.class);
        try {
            dfm.getDestinationFactory(bindingID);
        }
        catch (BusException ex) {
            // empty catch block
        }
        DestinationFactory df = dfm.getDestinationFactoryForUri(address);
        String transportId = null;
        transportId = df != null && df.getTransportIds() != null && !df.getTransportIds().isEmpty() ? df.getTransportIds().get(0) : bindingID;
        JaxWsSoapBindingConfiguration config = null;
        if (serviceFactory instanceof JaxWsServiceFactoryBean) {
            config = new JaxWsSoapBindingConfiguration((JaxWsServiceFactoryBean)serviceFactory);
        }
        BindingInfo bindingInfo = this.bus.getExtension(BindingFactoryManager.class).getBindingFactory(bindingID).createBindingInfo(serviceFactory.getService(), bindingID, config);
        Service service = serviceFactory.getService();
        service.getServiceInfos().get(0).addBinding(bindingInfo);
        ei = new EndpointInfo(service.getServiceInfos().get(0), transportId);
        ei.setName(portName);
        ei.setAddress(address);
        ei.setBinding(bindingInfo);
        service.getServiceInfos().get(0).addEndpoint(ei);
        return ei;
    }

    private void configureObject(Object instance) {
        this.configureObject(null, instance);
    }

    private void configureObject(String name, Object instance) {
        Configurer configurer = this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(name, instance);
        }
    }

    private PortInfoImpl getPortInfo(QName portName) {
        return this.portInfos.get(portName);
    }

    private QName getPortTypeName(Class<?> serviceEndpointInterface) {
        String tns;
        String name;
        WebService webService;
        String epi;
        Class<?> seiClass = serviceEndpointInterface;
        if (!serviceEndpointInterface.isAnnotationPresent(WebService.class)) {
            Message msg = new Message("SEI_NO_WEBSERVICE_ANNOTATION", BUNDLE, serviceEndpointInterface.getCanonicalName());
            throw new WebServiceException(msg.toString());
        }
        if (!serviceEndpointInterface.isInterface() && (epi = (webService = serviceEndpointInterface.getAnnotation(WebService.class)).endpointInterface()).length() > 0) {
            try {
                seiClass = Thread.currentThread().getContextClassLoader().loadClass(epi);
            }
            catch (ClassNotFoundException e) {
                Message msg = new Message("COULD_NOT_LOAD_CLASS", BUNDLE, seiClass.getCanonicalName());
                throw new WebServiceException(msg.toString());
            }
            if (!seiClass.isAnnotationPresent(WebService.class)) {
                Message msg = new Message("SEI_NO_WEBSERVICE_ANNOTATION", BUNDLE, seiClass.getCanonicalName());
                throw new WebServiceException(msg.toString());
            }
        }
        if ((name = (webService = seiClass.getAnnotation(WebService.class)).name()).length() == 0) {
            name = seiClass.getSimpleName();
        }
        if ((tns = webService.targetNamespace()).length() == 0) {
            tns = URIParserUtil.getNamespace(PackageUtils.getPackageName(seiClass));
        }
        return new QName(tns, name);
    }

    public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode) {
        return this.createDispatch(portName, type, mode, new WebServiceFeature[0]);
    }

    public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode, WebServiceFeature ... features) {
        PortInfoImpl portInfo;
        JaxWsClientFactoryBean clientFac = new JaxWsClientFactoryBean();
        this.configureObject(portName.toString() + ".jaxws-client.proxyFactory", clientFac);
        AbstractServiceFactoryBean sf = null;
        try {
            sf = this.createDispatchService(new SourceDataBinding());
        }
        catch (ServiceConstructionException e) {
            throw new WebServiceException((Throwable)e);
        }
        JaxWsClientEndpointImpl endpoint = this.getJaxwsEndpoint(portName, sf, features);
        ClientImpl client = new ClientImpl(this.getBus(), (Endpoint)endpoint, clientFac.getConduitSelector());
        for (AbstractFeature af : clientFac.getFeatures()) {
            af.initialize(client, this.bus);
        }
        for (AbstractFeature af : endpoint.getFeatures()) {
            af.initialize(client, this.bus);
        }
        this.initIntercepors(client, clientFac);
        if (this.executor != null) {
            client.getEndpoint().setExecutor(this.executor);
        }
        if ((portInfo = this.portInfos.get(portName)) != null && !StringUtils.isEmpty(portInfo.getAddress())) {
            client.getEndpoint().getEndpointInfo().setAddress(portInfo.getAddress());
        }
        DispatchImpl<T> disp = new DispatchImpl<T>(client, mode, type);
        this.configureObject(disp);
        return disp;
    }

    public <T> Dispatch<T> createDispatch(EndpointReference endpointReference, Class<T> type, Service.Mode mode, WebServiceFeature ... features) {
        EndpointReferenceType ref = VersionTransformer.convertToInternal(endpointReference);
        QName portName = EndpointReferenceUtils.getPortQName(ref, this.bus);
        this.updatePortInfoAddress(portName, EndpointReferenceUtils.getAddress(ref));
        return this.createDispatch(portName, type, mode, features);
    }

    public Dispatch<Object> createDispatch(QName portName, JAXBContext context, Service.Mode mode) {
        return this.createDispatch(portName, context, mode, new WebServiceFeature[0]);
    }

    public Dispatch<Object> createDispatch(QName portName, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
        JaxWsClientFactoryBean clientFac = new JaxWsClientFactoryBean();
        this.configureObject(portName.toString() + ".jaxws-client.proxyFactory", clientFac);
        AbstractServiceFactoryBean sf = null;
        try {
            JAXBDataBinding db = new JAXBDataBinding(context);
            sf = this.createDispatchService(db);
        }
        catch (ServiceConstructionException e) {
            throw new WebServiceException((Throwable)e);
        }
        JaxWsClientEndpointImpl endpoint = this.getJaxwsEndpoint(portName, sf, features);
        ClientImpl client = new ClientImpl(this.getBus(), (Endpoint)endpoint, clientFac.getConduitSelector());
        for (AbstractFeature af : clientFac.getFeatures()) {
            af.initialize(client, this.bus);
        }
        this.initIntercepors(client, clientFac);
        if (this.executor != null) {
            client.getEndpoint().setExecutor(this.executor);
        }
        DispatchImpl<Object> disp = new DispatchImpl<Object>(client, mode, context, Object.class);
        this.configureObject(disp);
        return disp;
    }

    public Dispatch<Object> createDispatch(EndpointReference endpointReference, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
        EndpointReferenceType ref = VersionTransformer.convertToInternal(endpointReference);
        QName portName = EndpointReferenceUtils.getPortQName(ref, this.bus);
        this.updatePortInfoAddress(portName, EndpointReferenceUtils.getAddress(ref));
        return this.createDispatch(portName, context, mode, features);
    }

    public <T> T getPort(EndpointReference endpointReference, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        return this.getPort(VersionTransformer.convertToInternal(endpointReference), serviceEndpointInterface, features);
    }

    private void initIntercepors(Client client, JaxWsClientFactoryBean clientFact) {
        client.getInInterceptors().addAll(clientFact.getInInterceptors());
        client.getOutInterceptors().addAll(clientFact.getOutInterceptors());
        client.getInFaultInterceptors().addAll(clientFact.getInFaultInterceptors());
        client.getOutFaultInterceptors().addAll(clientFact.getOutFaultInterceptors());
    }

    private void updatePortInfoAddress(QName portName, String eprAddress) {
        PortInfoImpl portInfo = this.portInfos.get(portName);
        if (!StringUtils.isEmpty(eprAddress) && portInfo != null) {
            portInfo.setAddress(eprAddress);
        }
    }
}

