/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.ServiceImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.MessageObserver;

public class ChainInitiationObserver
implements MessageObserver {
    protected Endpoint endpoint;
    protected Bus bus;
    private PhaseChainCache chainCache = new PhaseChainCache();

    public ChainInitiationObserver(Endpoint endpoint, Bus bus) {
        this.endpoint = endpoint;
        this.bus = bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(Message m) {
        Bus origBus = BusFactory.getThreadDefaultBus(false);
        BusFactory.setThreadDefaultBus(this.bus);
        try {
            Message message;
            Exchange exchange;
            InterceptorChain phaseChain = null;
            if (m.getInterceptorChain() != null) {
                InterceptorChain interceptorChain = phaseChain = m.getInterceptorChain();
                synchronized (interceptorChain) {
                    if (phaseChain.getState() == InterceptorChain.State.PAUSED || phaseChain.getState() == InterceptorChain.State.SUSPENDED) {
                        phaseChain.resume();
                        return;
                    }
                }
            }
            if ((exchange = (message = this.getBinding().createMessage(m)).getExchange()) == null) {
                exchange = new ExchangeImpl();
                m.setExchange(exchange);
            }
            exchange.setInMessage(message);
            this.setExchangeProperties(exchange, message);
            InterceptorProvider dbp = null;
            if (this.endpoint.getService().getDataBinding() instanceof InterceptorProvider) {
                dbp = (InterceptorProvider)((Object)this.endpoint.getService().getDataBinding());
            }
            phaseChain = dbp == null ? this.chainCache.get(this.bus.getExtension(PhaseManager.class).getInPhases(), this.bus.getInInterceptors(), this.endpoint.getService().getInInterceptors(), this.endpoint.getInInterceptors(), this.getBinding().getInInterceptors()) : this.chainCache.get(this.bus.getExtension(PhaseManager.class).getInPhases(), this.bus.getInInterceptors(), this.endpoint.getService().getInInterceptors(), this.endpoint.getInInterceptors(), this.getBinding().getInInterceptors(), dbp.getInInterceptors());
            message.setInterceptorChain(phaseChain);
            phaseChain.setFaultObserver(this.endpoint.getOutFaultObserver());
            this.addToChain(phaseChain, message);
            phaseChain.doIntercept(message);
            return;
        }
        finally {
            BusFactory.setThreadDefaultBus(origBus);
        }
    }

    private void addToChain(InterceptorChain chain, Message m) {
        Collection<Interceptor<? extends Message>> is;
        Collection<InterceptorProvider> providers = CastUtils.cast((Collection)m.get(Message.INTERCEPTOR_PROVIDERS));
        if (providers != null) {
            for (InterceptorProvider p : providers) {
                chain.add(p.getInInterceptors());
            }
        }
        if ((is = CastUtils.cast((Collection)m.get(Message.IN_INTERCEPTORS))) != null) {
            chain.add(is);
        }
        if (m.getDestination() instanceof InterceptorProvider) {
            chain.add(((InterceptorProvider)((Object)m.getDestination())).getInInterceptors());
        }
    }

    protected Binding getBinding() {
        return this.endpoint.getBinding();
    }

    protected void setExchangeProperties(Exchange exchange, Message m) {
        exchange.put(Endpoint.class, this.endpoint);
        exchange.put(Service.class, this.endpoint.getService());
        exchange.put(Binding.class, this.getBinding());
        exchange.put(Bus.class, this.bus);
        if (exchange.getDestination() == null) {
            exchange.setDestination(m.getDestination());
        }
        if (this.endpoint != null && this.endpoint.getService() instanceof ServiceImpl) {
            EndpointInfo endpointInfo = this.endpoint.getEndpointInfo();
            QName serviceQName = endpointInfo.getService().getName();
            exchange.put("javax.xml.ws.wsdl.service", serviceQName);
            QName interfaceQName = endpointInfo.getService().getInterface().getName();
            exchange.put("javax.xml.ws.wsdl.interface", interfaceQName);
            QName portQName = endpointInfo.getName();
            exchange.put("javax.xml.ws.wsdl.port", portQName);
            URI wsdlDescription = endpointInfo.getProperty("URI", URI.class);
            if (wsdlDescription == null) {
                String address = endpointInfo.getAddress();
                try {
                    wsdlDescription = new URI(address + "?wsdl");
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
                endpointInfo.setProperty("URI", wsdlDescription);
            }
            exchange.put("javax.xml.ws.wsdl.description", wsdlDescription);
        }
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }
}

