/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.AbstractWrappedOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.local.LocalDestination;
import org.apache.cxf.transport.local.LocalTransportFactory;

public class LocalConduit
extends AbstractConduit {
    public static final String IN_CONDUIT = LocalConduit.class.getName() + ".inConduit";
    public static final String RESPONSE_CONDUIT = LocalConduit.class.getName() + ".inConduit";
    public static final String IN_EXCHANGE = LocalConduit.class.getName() + ".inExchange";
    public static final String DIRECT_DISPATCH = LocalConduit.class.getName() + ".directDispatch";
    public static final String MESSAGE_FILTER_PROPERTIES = LocalTransportFactory.MESSAGE_FILTER_PROPERTIES;
    private static final Logger LOG = LogUtils.getL7dLogger(LocalConduit.class);
    private LocalDestination destination;
    private LocalTransportFactory transportFactory;

    public LocalConduit(LocalTransportFactory transportFactory, LocalDestination destination) {
        super(destination.getAddress());
        this.destination = destination;
        this.transportFactory = transportFactory;
    }

    public void prepare(Message message) throws IOException {
        if (!Boolean.TRUE.equals(message.get(DIRECT_DISPATCH))) {
            this.dispatchViaPipe(message);
        } else {
            CachedOutputStream stream = new CachedOutputStream();
            message.setContent(OutputStream.class, stream);
        }
    }

    public void close(Message message) throws IOException {
        if (Boolean.TRUE.equals(message.get(DIRECT_DISPATCH)) && !Boolean.TRUE.equals(message.get("org.apache.cxf.message.inbound"))) {
            this.dispatchDirect(message);
        }
        super.close(message);
    }

    private void dispatchDirect(Message message) throws IOException {
        if (this.destination.getMessageObserver() == null) {
            throw new IllegalStateException("Local destination does not have a MessageObserver on address " + this.destination.getAddress().getAddress().getValue());
        }
        MessageImpl copy = new MessageImpl();
        copy.put(IN_CONDUIT, (Object)this);
        copy.setDestination(this.destination);
        this.transportFactory.copy(message, copy);
        MessageImpl.copyContent(message, copy);
        CachedOutputStream stream = (CachedOutputStream)message.getContent(OutputStream.class);
        copy.setContent(InputStream.class, stream.getInputStream());
        ExchangeImpl ex = new ExchangeImpl();
        ex.setInMessage(copy);
        ex.put(IN_EXCHANGE, (Object)message.getExchange());
        ex.put(DIRECT_DISPATCH, (Object)true);
        ex.setDestination(this.destination);
        this.destination.getMessageObserver().onMessage(copy);
    }

    private void dispatchViaPipe(final Message message) throws IOException {
        final LocalConduit conduit = this;
        final Exchange exchange = message.getExchange();
        if (this.destination.getMessageObserver() == null) {
            throw new IllegalStateException("Local destination does not have a MessageObserver on address " + this.destination.getAddress().getAddress().getValue());
        }
        AbstractWrappedOutputStream cout = new AbstractWrappedOutputStream(){

            protected void onFirstWrite() throws IOException {
                PipedInputStream stream = new PipedInputStream();
                this.wrappedStream = new PipedOutputStream(stream);
                final MessageImpl inMsg = new MessageImpl();
                LocalConduit.this.transportFactory.copy(message, inMsg);
                inMsg.setContent(InputStream.class, stream);
                inMsg.setDestination(LocalConduit.this.destination);
                inMsg.put(IN_CONDUIT, (Object)conduit);
                Runnable receiver = new Runnable(){

                    public void run() {
                        ExchangeImpl ex = new ExchangeImpl();
                        ex.setInMessage(inMsg);
                        ex.put(IN_EXCHANGE, (Object)exchange);
                        LocalConduit.this.destination.getMessageObserver().onMessage(inMsg);
                    }
                };
                new Thread(receiver).start();
            }
        };
        message.setContent(OutputStream.class, cout);
    }

    protected Logger getLogger() {
        return LOG;
    }
}

