/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"text/html"})
@Provider
public class RequestDispatcherProvider
extends AbstractConfigurableProvider
implements MessageBodyWriter<Object> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(RequestDispatcherProvider.class);
    private static final Logger LOG = LogUtils.getL7dLogger(RequestDispatcherProvider.class);
    private static final String ABSOLUTE_PATH_PARAMETER = "absolute.path";
    private static final String BASE_PATH_PARAMETER = "base.path";
    private static final String RELATIVE_PATH_PARAMETER = "relative.path";
    private static final String REQUEST_SCOPE = "request";
    private static final String SESSION_SCOPE = "session";
    private String servletContextPath;
    private String resourcePath;
    private Map<String, String> classResources = Collections.emptyMap();
    private String scope = "request";
    private Map<String, String> beanNames = Collections.emptyMap();
    private String dispatcherName;
    private String servletPath;
    @Context
    private MessageContext mc;

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return this.resourcePath != null || this.classResources.containsKey(type.getName());
    }

    public void writeTo(Object o, Class<?> clazz, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        ServletContext sc = this.getServletContext();
        String path = this.resourcePath != null ? this.resourcePath : this.classResources.get(clazz.getName());
        RequestDispatcher rd = this.getRequestDispatcher(sc, clazz, path);
        try {
            this.mc.put("http.request.redirected", Boolean.TRUE);
            String theServletPath = this.servletPath == null ? "/" : this.servletPath;
            HttpServletRequestFilter servletRequest = new HttpServletRequestFilter(this.mc.getHttpServletRequest(), path, theServletPath);
            if (REQUEST_SCOPE.equals(this.scope)) {
                servletRequest.setAttribute(this.getBeanName(o), o);
            } else if (SESSION_SCOPE.equals(this.scope)) {
                servletRequest.getSession(true).setAttribute(this.getBeanName(o), o);
            }
            this.setRequestParameters(servletRequest);
            rd.forward((ServletRequest)servletRequest, (ServletResponse)this.mc.getHttpServletResponse());
        }
        catch (Throwable ex) {
            this.mc.put("http.request.redirected", Boolean.FALSE);
            ex.printStackTrace();
            throw new WebApplicationException(ex);
        }
    }

    protected ServletContext getServletContext() {
        ServletContext sc = this.mc.getServletContext();
        if (this.servletContextPath != null && (sc = sc.getContext(this.servletContextPath)) == null) {
            String message = new Message("RESOURCE_DISPATCH_NOT_FOUND", BUNDLE, this.servletContextPath).toString();
            LOG.severe(message);
            throw new WebApplicationException();
        }
        return sc;
    }

    protected RequestDispatcher getRequestDispatcher(ServletContext sc, Class<?> clazz, String path) {
        RequestDispatcher rd;
        RequestDispatcher requestDispatcher = rd = this.dispatcherName != null ? sc.getNamedDispatcher(this.dispatcherName) : sc.getRequestDispatcher(path);
        if (rd == null) {
            String message = new Message("RESOURCE_PATH_NOT_FOUND", BUNDLE, path).toString();
            LOG.severe(message);
            throw new WebApplicationException();
        }
        return rd;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setServletContextPath(String servletContextPath) {
        this.servletContextPath = servletContextPath;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setBeanNames(Map<String, String> beanNames) {
        this.beanNames = beanNames;
    }

    protected String getBeanName(Object bean) {
        String name = this.beanNames.get(bean.getClass().getName());
        return name != null ? name : bean.getClass().getSimpleName().toLowerCase();
    }

    protected void setRequestParameters(HttpServletRequestFilter request) {
        if (this.mc != null) {
            UriInfo ui = this.mc.getUriInfo();
            MultivaluedMap params = ui.getPathParameters();
            for (Map.Entry entry : params.entrySet()) {
                String value = (String)((List)entry.getValue()).get(0);
                int ind = value.indexOf(";");
                if (ind > 0) {
                    value = value.substring(0, ind);
                }
                request.setParameter((String)entry.getKey(), value);
            }
            List segments = ui.getPathSegments();
            if (segments.size() > 0) {
                this.doSetRequestParameters(request, (MultivaluedMap<String, String>)((PathSegment)segments.get(segments.size() - 1)).getMatrixParameters());
            }
            this.doSetRequestParameters(request, (MultivaluedMap<String, String>)ui.getQueryParameters());
            request.setParameter(ABSOLUTE_PATH_PARAMETER, ui.getAbsolutePath().toString());
            request.setParameter(RELATIVE_PATH_PARAMETER, ui.getPath());
            request.setParameter(BASE_PATH_PARAMETER, ui.getBaseUri().toString());
        }
    }

    protected void doSetRequestParameters(HttpServletRequestFilter req, MultivaluedMap<String, String> params) {
        for (Map.Entry entry : params.entrySet()) {
            req.setParameters((String)entry.getKey(), (List)entry.getValue());
        }
    }

    public void setDispatcherName(String name) {
        this.dispatcherName = name;
    }

    public void setServletPath(String path) {
        this.servletPath = path;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HttpServletRequestFilter
    extends HttpServletRequestWrapper {
        private Map<String, String[]> params;
        private String path;
        private String servletPath;

        public HttpServletRequestFilter(HttpServletRequest request, String path, String servletPath) {
            super(request);
            this.path = path;
            this.servletPath = servletPath;
            this.params = new HashMap<String, String[]>(request.getParameterMap());
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public String getPathInfo() {
            return this.path;
        }

        public String getRequestURI() {
            return this.path;
        }

        public void setParameter(String name, String value) {
            this.params.put(name, new String[]{value});
        }

        public void setParameters(String name, List<String> values) {
            this.params.put(name, values.toArray(new String[0]));
        }

        public String getParameter(String name) {
            String[] values = this.params.get(name);
            if (values == null || values.length == 0) {
                return null;
            }
            return values[0];
        }

        public Map<String, String[]> getParameterMap() {
            return this.params;
        }
    }
}

