/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search;

import org.apache.cxf.jaxrs.ext.search.FiqlParseException;
import org.apache.cxf.jaxrs.ext.search.FiqlParser;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchContext;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchContextImpl
implements SearchContext {
    public static final String SEARCH_QUERY = "_search";
    public static final String SHORT_SEARCH_QUERY = "_s";
    private Message message;

    public SearchContextImpl(Message message) {
        this.message = message;
    }

    @Override
    public <T> SearchCondition<T> getCondition(Class<T> cls) {
        FiqlParser<T> parser = this.getParser(cls);
        String expression = this.getExpression();
        if (expression != null) {
            try {
                return parser.parse(expression);
            }
            catch (FiqlParseException ex) {
                return null;
            }
        }
        return null;
    }

    private String getExpression() {
        int ind;
        String queryStr = (String)this.message.get(Message.QUERY_STRING);
        if (queryStr != null && (queryStr.startsWith(SEARCH_QUERY) || queryStr.startsWith(SHORT_SEARCH_QUERY)) && (ind = queryStr.indexOf(61)) + 1 < queryStr.length()) {
            return HttpUtils.urlDecode(queryStr.substring(ind + 1));
        }
        return null;
    }

    private <T> FiqlParser<T> getParser(Class<T> cls) {
        return new FiqlParser<T>(cls);
    }
}

