/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.jws.WebParam;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaReturn;
import org.apache.cxf.tools.common.model.JavaType;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBinding;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.AbstractProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.FaultProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ParameterProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.WSActionAnnotator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.WebMethodAnnotator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.WebResultAnnotator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.WrapperAnnotator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.mapper.MethodMapper;

public class OperationProcessor
extends AbstractProcessor {
    private JavaParameter wrapperRequest;
    private JavaParameter wrapperResponse;

    public OperationProcessor(ToolContext c) {
        super(c);
    }

    public void process(JavaInterface intf, OperationInfo operation) throws ToolException {
        JavaMethod method = new MethodMapper().map(operation);
        method.setInterface(intf);
        this.processMethod(method, operation);
        Collection<FaultInfo> faults = operation.getFaults();
        FaultProcessor faultProcessor = new FaultProcessor(this.context);
        faultProcessor.process(method, faults);
        method.annotate(new WSActionAnnotator(operation));
        intf.addMethod(method);
    }

    void processMethod(JavaMethod method, OperationInfo operation) throws ToolException {
        if (this.isAsyncMethod(method)) {
            return;
        }
        MessageInfo inputMessage = operation.getInput();
        MessageInfo outputMessage = operation.getOutput();
        if (inputMessage == null) {
            LOG.log(Level.WARNING, "NO_INPUT_MESSAGE", new Object[]{operation.getName()});
            Message msg = new Message("INVALID_MEP", LOG, operation.getName());
            throw new ToolException(msg);
        }
        ParameterProcessor paramProcessor = new ParameterProcessor(this.context);
        method.clear();
        paramProcessor.process(method, inputMessage, outputMessage, operation.getParameterOrdering());
        method.annotate(new WebMethodAnnotator());
        if (method.isWrapperStyle()) {
            this.setWrapper(operation);
            method.annotate(new WrapperAnnotator(this.wrapperRequest, this.wrapperResponse));
        }
        method.annotate(new WebResultAnnotator());
        JAXWSBinding opBinding = operation.getExtensor(JAXWSBinding.class);
        JAXWSBinding ptBinding = operation.getInterface().getExtensor(JAXWSBinding.class);
        JAXWSBinding defBinding = operation.getInterface().getService().getDescription().getExtensor(JAXWSBinding.class);
        boolean enableAsync = false;
        boolean enableMime = false;
        if (defBinding != null) {
            if (defBinding.isSetEnableMime()) {
                enableMime = defBinding.isEnableMime();
            }
            if (defBinding.isSetEnableAsyncMapping()) {
                enableAsync = defBinding.isEnableAsyncMapping();
            }
        }
        if (ptBinding != null) {
            if (ptBinding.isSetEnableMime()) {
                enableMime = ptBinding.isEnableMime();
            }
            if (ptBinding.isSetEnableAsyncMapping()) {
                enableAsync = ptBinding.isEnableAsyncMapping();
            }
        }
        if (opBinding != null) {
            if (opBinding.isSetEnableMime()) {
                enableMime = opBinding.isEnableMime();
            }
            if (opBinding.isSetEnableAsyncMapping()) {
                enableAsync = opBinding.isEnableAsyncMapping();
            }
        }
        if (!method.isOneWay() && enableAsync && !this.isAddedAsycMethod(method)) {
            this.addAsyncMethod(method);
        }
        if (enableMime) {
            method.setMimeEnable(true);
        }
    }

    private void setWrapper(OperationInfo operation) {
        MessagePartInfo inputPart = null;
        if (operation.getInput() != null && operation.getInput().getMessageParts() != null) {
            inputPart = operation.getInput().getMessageParts().iterator().next();
        }
        MessagePartInfo outputPart = null;
        if (operation.getOutput() != null && operation.getOutput().getMessageParts() != null) {
            outputPart = operation.getOutput().getMessageParts().iterator().next();
        }
        if (inputPart != null) {
            this.wrapperRequest = new JavaParameter();
            this.wrapperRequest.setName(ProcessorUtil.resolvePartName(inputPart));
            this.wrapperRequest.setType(ProcessorUtil.getPartType(inputPart));
            this.wrapperRequest.setTargetNamespace(ProcessorUtil.resolvePartNamespace(inputPart));
            this.wrapperRequest.setClassName(ProcessorUtil.getFullClzName(inputPart, this.context, false));
        }
        if (outputPart != null) {
            this.wrapperResponse = new JavaParameter();
            this.wrapperResponse.setName(ProcessorUtil.resolvePartName(outputPart));
            this.wrapperResponse.setType(ProcessorUtil.getPartType(outputPart));
            this.wrapperResponse.setTargetNamespace(ProcessorUtil.resolvePartNamespace(outputPart));
            this.wrapperResponse.setClassName(ProcessorUtil.getFullClzName(outputPart, this.context, false));
        }
    }

    private boolean isAsyncMethod(JavaMethod method) {
        if (method.getName().endsWith("Async") && method.getReturn() != null && method.getReturn().getClassName() != null) {
            if (method.getReturn().getClassName().startsWith("Response<")) {
                return true;
            }
            if (method.getParameterCount() > 0 && method.getParameters().get(method.getParameterCount() - 1).getClassName().startsWith("AsyncHandler<")) {
                return true;
            }
        }
        return false;
    }

    private void addAsyncMethod(JavaMethod method) throws ToolException {
        this.addPollingMethod(method);
        this.addCallbackMethod(method);
        method.getInterface().addImport("javax.xml.ws.AsyncHandler");
        method.getInterface().addImport("java.util.concurrent.Future");
        method.getInterface().addImport("javax.xml.ws.Response");
    }

    private void addCallbackMethod(JavaMethod method) throws ToolException {
        JavaMethod callbackMethod = new JavaMethod(method.getInterface());
        callbackMethod.setAsync(true);
        callbackMethod.setName(method.getName() + "Async");
        callbackMethod.setStyle(method.getStyle());
        callbackMethod.setWrapperStyle(method.isWrapperStyle());
        callbackMethod.setSoapAction(method.getSoapAction());
        callbackMethod.setOperationName(method.getOperationName());
        JavaReturn future = new JavaReturn();
        future.setClassName("Future<?>");
        callbackMethod.setReturn(future);
        callbackMethod.annotate(new WebMethodAnnotator());
        callbackMethod.addAnnotation("ResponseWrapper", method.getAnnotationMap().get("ResponseWrapper"));
        callbackMethod.addAnnotation("RequestWrapper", method.getAnnotationMap().get("RequestWrapper"));
        callbackMethod.addAnnotation("SOAPBinding", method.getAnnotationMap().get("SOAPBinding"));
        boolean convertOutToAsync = !method.isWrapperStyle() && "void".equals(method.getReturn().getClassName());
        String asyncCname = null;
        for (JavaParameter param : method.getParameters()) {
            if (convertOutToAsync) {
                if (param.isHolder()) {
                    if (param.isINOUT()) {
                        JavaParameter p2 = new JavaParameter();
                        p2.setName(param.getName());
                        p2.setClassName(param.getHolderName());
                        p2.setStyle(JavaType.Style.IN);
                        callbackMethod.addParameter(p2);
                        for (String s : param.getAnnotationTags()) {
                            JAnnotation ann = param.getAnnotation(s);
                            p2.addAnnotation(s, ann);
                        }
                        continue;
                    }
                    if (param.isHeader() || asyncCname != null) continue;
                    asyncCname = param.getClassName();
                    continue;
                }
                callbackMethod.addParameter(param);
                continue;
            }
            callbackMethod.addParameter(param);
        }
        JavaParameter asyncHandler = new JavaParameter();
        asyncHandler.setName("asyncHandler");
        asyncHandler.setCallback(true);
        asyncHandler.setClassName(this.getAsyncClassName(method, "AsyncHandler", asyncCname));
        asyncHandler.setStyle(JavaType.Style.IN);
        callbackMethod.addParameter(asyncHandler);
        JAnnotation asyncHandlerAnnotation = new JAnnotation(WebParam.class);
        asyncHandlerAnnotation.addElement(new JAnnotationElement("name", "asyncHandler"));
        asyncHandlerAnnotation.addElement(new JAnnotationElement("targetNamespace", ""));
        asyncHandler.addAnnotation("WebParam", asyncHandlerAnnotation);
        method.getInterface().addImport("javax.jws.WebParam");
        method.getInterface().addMethod(callbackMethod);
    }

    private void addPollingMethod(JavaMethod method) throws ToolException {
        JavaMethod pollingMethod = new JavaMethod(method.getInterface());
        pollingMethod.setAsync(true);
        pollingMethod.setName(method.getName() + "Async");
        pollingMethod.setStyle(method.getStyle());
        pollingMethod.setWrapperStyle(method.isWrapperStyle());
        pollingMethod.setSoapAction(method.getSoapAction());
        pollingMethod.setOperationName(method.getOperationName());
        boolean convertOutToAsync = !method.isWrapperStyle() && "void".equals(method.getReturn().getClassName());
        String asyncCname = null;
        for (JavaParameter param : method.getParameters()) {
            if (convertOutToAsync) {
                if (param.isHolder()) {
                    if (param.isINOUT()) {
                        JavaParameter p2 = new JavaParameter();
                        p2.setName(param.getName());
                        p2.setClassName(param.getHolderName());
                        p2.setStyle(JavaType.Style.IN);
                        pollingMethod.addParameter(p2);
                        for (String s : param.getAnnotationTags()) {
                            JAnnotation ann = param.getAnnotation(s);
                            p2.addAnnotation(s, ann);
                        }
                        continue;
                    }
                    if (param.isHeader() || asyncCname != null) continue;
                    asyncCname = param.getClassName();
                    continue;
                }
                pollingMethod.addParameter(param);
                continue;
            }
            pollingMethod.addParameter(param);
        }
        JavaReturn response = new JavaReturn();
        response.setClassName(this.getAsyncClassName(method, "Response", asyncCname));
        pollingMethod.setReturn(response);
        pollingMethod.annotate(new WebMethodAnnotator());
        pollingMethod.addAnnotation("RequestWrapper", method.getAnnotationMap().get("RequestWrapper"));
        pollingMethod.addAnnotation("ResponseWrapper", method.getAnnotationMap().get("ResponseWrapper"));
        pollingMethod.addAnnotation("SOAPBinding", method.getAnnotationMap().get("SOAPBinding"));
        method.getInterface().addMethod(pollingMethod);
    }

    private String getAsyncClassName(JavaMethod method, String clzName, String name) {
        Class<?> mappedClass;
        String response = name;
        if (response == null && (mappedClass = JAXBUtils.holderClass(response = this.wrapperResponse != null ? this.wrapperResponse.getClassName() : method.getReturn().getClassName())) != null) {
            response = mappedClass.getName();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(clzName);
        sb.append("<");
        if ("void".equals(response)) {
            sb.append('?');
        } else {
            sb.append(response);
        }
        sb.append(">");
        return sb.toString();
    }

    private boolean isAddedAsycMethod(JavaMethod method) {
        List<JavaMethod> jmethods = method.getInterface().getMethods();
        int counter = 0;
        for (JavaMethod jm : jmethods) {
            if (!jm.getOperationName().equals(method.getOperationName())) continue;
            ++counter;
        }
        return counter > 1;
    }
}

