/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.MessageContextImpl;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.HttpServletResponseFilter;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.PathSegmentImpl;
import org.apache.cxf.jaxrs.impl.ProvidersImpl;
import org.apache.cxf.jaxrs.impl.RequestImpl;
import org.apache.cxf.jaxrs.impl.SecurityContextImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfoComparator;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfoComparator;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.jaxrs.utils.multipart.AttachmentUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXRSUtils {
    public static final MediaType ALL_TYPES = new MediaType();
    public static final String ROOT_RESOURCE_CLASS = "root.resource.class";
    public static final String IGNORE_MESSAGE_WRITERS = "ignore.message.writers";
    public static final String ROOT_INSTANCE = "service.root.instance";
    public static final String ROOT_PROVIDER = "service.root.provider";
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSUtils.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSUtils.class);
    private static final String PROPOGATE_EXCEPTION = "org.apache.cxf.propogate.exception";
    private static final String FORM_PARAM_MAP = JAXRSUtils.class.getName() + ".FORM_DATA";

    private JAXRSUtils() {
    }

    public static List<PathSegment> getPathSegments(String thePath, boolean decode) {
        return JAXRSUtils.getPathSegments(thePath, decode, true);
    }

    public static List<PathSegment> getPathSegments(String thePath, boolean decode, boolean ignoreLastSlash) {
        String[] segments = thePath.split("/");
        ArrayList<PathSegment> theList = new ArrayList<PathSegment>();
        for (String path : segments) {
            if (StringUtils.isEmpty(path)) continue;
            theList.add(new PathSegmentImpl(path, decode));
        }
        int len = thePath.length();
        if (len > 0 && thePath.charAt(len - 1) == '/') {
            String value = ignoreLastSlash ? "" : "/";
            theList.add(new PathSegmentImpl(value, false));
        }
        return theList;
    }

    private static String[] getUserMediaTypes(Object provider, String methodName) {
        String[] values = null;
        if (AbstractConfigurableProvider.class.isAssignableFrom(provider.getClass())) {
            try {
                Method m = provider.getClass().getMethod(methodName, new Class[0]);
                List types = (List)m.invoke(provider, new Object[0]);
                if (types != null) {
                    String[] stringArray;
                    if (types.size() > 0) {
                        stringArray = types.toArray(new String[0]);
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = "*/*";
                    }
                    values = stringArray;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return values;
    }

    public static List<MediaType> getProviderConsumeTypes(MessageBodyReader provider) {
        String[] values = JAXRSUtils.getUserMediaTypes(provider, "getConsumeMediaTypes");
        if (values == null) {
            String[] stringArray;
            Consumes c = provider.getClass().getAnnotation(Consumes.class);
            if (c == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "*/*";
            } else {
                stringArray = c.value();
            }
            values = stringArray;
        }
        return JAXRSUtils.getMediaTypes(values);
    }

    public static List<MediaType> getProviderProduceTypes(MessageBodyWriter provider) {
        String[] values = JAXRSUtils.getUserMediaTypes(provider, "getProduceMediaTypes");
        if (values == null) {
            String[] stringArray;
            Produces c = provider.getClass().getAnnotation(Produces.class);
            if (c == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "*/*";
            } else {
                stringArray = c.value();
            }
            values = stringArray;
        }
        return JAXRSUtils.getMediaTypes(values);
    }

    public static List<MediaType> getMediaTypes(String[] values) {
        ArrayList<MediaType> supportedMimeTypes = new ArrayList<MediaType>(values.length);
        for (int i = 0; i < values.length; ++i) {
            supportedMimeTypes.add(MediaType.valueOf((String)values[i]));
        }
        return supportedMimeTypes;
    }

    public static void handleSetters(OperationResourceInfo ori, Object requestObject, Message message) {
        Object o;
        Parameter p;
        ClassResourceInfo cri = ori.getClassResourceInfo();
        InjectionUtils.injectContextMethods(requestObject, cri, message);
        MultivaluedMap values = (MultivaluedMap)message.get("jaxrs.template.parameters");
        for (Method m : cri.getParameterMethods()) {
            p = ResourceUtils.getParameter(0, m.getAnnotations());
            o = JAXRSUtils.createHttpParameterValue(p, m.getParameterTypes()[0], m.getGenericParameterTypes()[0], message, (MultivaluedMap<String, String>)values, ori);
            if (o == null) continue;
            InjectionUtils.injectThroughMethod(requestObject, m, o);
        }
        for (Field f : cri.getParameterFields()) {
            p = ResourceUtils.getParameter(0, f.getAnnotations());
            o = JAXRSUtils.createHttpParameterValue(p, f.getType(), f.getGenericType(), message, (MultivaluedMap<String, String>)values, ori);
            if (o == null) continue;
            InjectionUtils.injectFieldValue(f, requestObject, o);
        }
    }

    public static ClassResourceInfo selectResourceClass(List<ClassResourceInfo> resources, String path, MultivaluedMap<String, String> values, Message message) {
        LOG.fine(new org.apache.cxf.common.i18n.Message("START_CRI_MATCH", BUNDLE, path).toString());
        if (resources.size() == 1) {
            return resources.get(0).getURITemplate().match(path, values) ? resources.get(0) : null;
        }
        TreeMap<ClassResourceInfo, MetadataMap<String, String>> candidateList = new TreeMap<ClassResourceInfo, MetadataMap<String, String>>(new ClassResourceInfoComparator(message));
        for (ClassResourceInfo cri : resources) {
            MetadataMap<String, String> map = new MetadataMap<String, String>();
            if (cri.getURITemplate().match(path, map)) {
                candidateList.put(cri, map);
                LOG.fine(new org.apache.cxf.common.i18n.Message("CRI_SELECTED_POSSIBLY", BUNDLE, cri.getServiceClass().getName(), path, cri.getURITemplate().getValue()).toString());
                continue;
            }
            LOG.fine(new org.apache.cxf.common.i18n.Message("NO_CRI_MATCH", BUNDLE, path, cri.getServiceClass().getName()).toString());
        }
        if (!candidateList.isEmpty()) {
            ClassResourceInfo cri;
            Map.Entry firstEntry = candidateList.entrySet().iterator().next();
            values.putAll((Map)firstEntry.getValue());
            cri = (ClassResourceInfo)firstEntry.getKey();
            LOG.fine(new org.apache.cxf.common.i18n.Message("CRI_SELECTED", BUNDLE, cri.getServiceClass().getName(), path, cri.getURITemplate().getValue()).toString());
            return cri;
        }
        return null;
    }

    public static OperationResourceInfo findTargetMethod(ClassResourceInfo resource, Message message, String httpMethod, MultivaluedMap<String, String> values, String requestContentType, List<MediaType> acceptContentTypes, boolean logNow) {
        String path;
        if (LOG.isLoggable(Level.FINE)) {
            org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("START_OPER_MATCH", BUNDLE, resource.getServiceClass().getName());
            LOG.fine(msg.toString());
        }
        if ((path = (String)values.getFirst((Object)"FINAL_MATCH_GROUP")) == null) {
            path = "/";
        }
        TreeMap<OperationResourceInfo, MetadataMap<String, String>> candidateList = new TreeMap<OperationResourceInfo, MetadataMap<String, String>>(new OperationResourceInfoComparator(message, httpMethod));
        MediaType requestType = requestContentType == null ? ALL_TYPES : MediaType.valueOf((String)requestContentType);
        int pathMatched = 0;
        int methodMatched = 0;
        int consumeMatched = 0;
        int produceMatched = 0;
        boolean subresourcesOnly = true;
        for (MediaType acceptType : acceptContentTypes) {
            for (OperationResourceInfo ori : resource.getMethodDispatcher().getOperationResourceInfos()) {
                URITemplate uriTemplate = ori.getURITemplate();
                MetadataMap<String, String> map = new MetadataMap<String, String>((Map<String, List<String>>)values);
                if (uriTemplate != null && uriTemplate.match(path, map)) {
                    boolean added = false;
                    if (ori.isSubResourceLocator()) {
                        candidateList.put(ori, map);
                        added = true;
                    } else {
                        String finalGroup = (String)map.getFirst("FINAL_MATCH_GROUP");
                        if (finalGroup == null || StringUtils.isEmpty(finalGroup) || finalGroup.equals("/")) {
                            ++pathMatched;
                            boolean mMatched = JAXRSUtils.matchHttpMethod(ori.getHttpMethod(), httpMethod);
                            boolean cMatched = JAXRSUtils.matchConsumeTypes(requestType, ori);
                            boolean pMatched = JAXRSUtils.matchProduceTypes(acceptType, ori);
                            if (mMatched && cMatched && pMatched) {
                                subresourcesOnly = false;
                                candidateList.put(ori, map);
                                added = true;
                            } else {
                                methodMatched = mMatched ? methodMatched + 1 : methodMatched;
                                produceMatched = pMatched ? produceMatched + 1 : produceMatched;
                                consumeMatched = cMatched ? consumeMatched + 1 : consumeMatched;
                                JAXRSUtils.logNoMatchMessage(ori, path, httpMethod, requestType, acceptContentTypes);
                            }
                        } else {
                            JAXRSUtils.logNoMatchMessage(ori, path, httpMethod, requestType, acceptContentTypes);
                        }
                    }
                    if (!added || !LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine(new org.apache.cxf.common.i18n.Message("OPER_SELECTED_POSSIBLY", BUNDLE, ori.getMethodToInvoke().getName()).toString());
                    continue;
                }
                JAXRSUtils.logNoMatchMessage(ori, path, httpMethod, requestType, acceptContentTypes);
            }
            if (candidateList.isEmpty() || subresourcesOnly) continue;
            break;
        }
        if (!candidateList.isEmpty()) {
            Map.Entry firstEntry = candidateList.entrySet().iterator().next();
            values.clear();
            values.putAll((Map)firstEntry.getValue());
            OperationResourceInfo ori = (OperationResourceInfo)firstEntry.getKey();
            if (JAXRSUtils.headMethodPossible(ori.getHttpMethod(), httpMethod)) {
                LOG.info(new org.apache.cxf.common.i18n.Message("GET_INSTEAD_OF_HEAD", BUNDLE, resource.getServiceClass().getName(), ori.getMethodToInvoke().getName()).toString());
            }
            LOG.fine(new org.apache.cxf.common.i18n.Message("OPER_SELECTED", BUNDLE, ori.getMethodToInvoke().getName(), resource.getServiceClass().getName()).toString());
            return ori;
        }
        int status = pathMatched == 0 ? 404 : (methodMatched == 0 ? 405 : (consumeMatched == 0 ? 415 : (produceMatched == 0 ? 406 : 404)));
        String name = resource.isRoot() ? "NO_OP_EXC" : "NO_SUBRESOURCE_METHOD_FOUND";
        org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message(name, BUNDLE, path, httpMethod, requestType.toString(), JAXRSUtils.convertTypesToString(acceptContentTypes));
        if (!"OPTIONS".equalsIgnoreCase(httpMethod) && logNow) {
            LOG.warning(errorMsg.toString());
        }
        Response.ResponseBuilder rb = JAXRSUtils.createResponseBuilder(resource, status, methodMatched == 0);
        throw new WebApplicationException(rb.build());
    }

    private static void logNoMatchMessage(OperationResourceInfo ori, String path, String httpMethod, MediaType requestType, List<MediaType> acceptContentTypes) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message("OPER_NO_MATCH", BUNDLE, ori.getMethodToInvoke().getName(), path, ori.getURITemplate().getValue(), httpMethod, ori.getHttpMethod(), requestType.toString(), JAXRSUtils.convertTypesToString(ori.getConsumeTypes()), JAXRSUtils.convertTypesToString(acceptContentTypes), JAXRSUtils.convertTypesToString(ori.getProduceTypes()));
        LOG.fine(errorMsg.toString());
    }

    public static Response.ResponseBuilder createResponseBuilder(ClassResourceInfo cri, int status, boolean addAllow) {
        Response.ResponseBuilder rb = Response.status((int)status);
        if (addAllow) {
            Set<String> allowedMethods = cri.getAllowedMethods();
            for (String m : allowedMethods) {
                rb.header("Allow", (Object)m);
            }
            if (!allowedMethods.contains("OPTIONS")) {
                rb.header("Allow", (Object)"OPTIONS");
            }
            if (!allowedMethods.contains("HEAD") && allowedMethods.contains("GET")) {
                rb.header("Allow", (Object)"HEAD");
            }
        }
        return rb;
    }

    private static boolean matchHttpMethod(String expectedMethod, String httpMethod) {
        return expectedMethod.equalsIgnoreCase(httpMethod) || JAXRSUtils.headMethodPossible(expectedMethod, httpMethod);
    }

    public static boolean headMethodPossible(String expectedMethod, String httpMethod) {
        return "HEAD".equalsIgnoreCase(httpMethod) && "GET".equals(expectedMethod);
    }

    private static String convertTypesToString(List<MediaType> types) {
        StringBuilder sb = new StringBuilder();
        for (MediaType type : types) {
            sb.append(type.toString()).append(',');
        }
        return sb.toString();
    }

    public static List<MediaType> getConsumeTypes(Consumes cm) {
        return cm == null ? Collections.singletonList(ALL_TYPES) : JAXRSUtils.getMediaTypes(cm.value());
    }

    public static List<MediaType> getProduceTypes(Produces pm) {
        return pm == null ? Collections.singletonList(ALL_TYPES) : JAXRSUtils.getMediaTypes(pm.value());
    }

    public static int compareSortedMediaTypes(List<MediaType> mts1, List<MediaType> mts2) {
        int size1 = mts1.size();
        int size2 = mts2.size();
        for (int i = 0; i < size1 && i < size2; ++i) {
            int result = JAXRSUtils.compareMediaTypes(mts1.get(i), mts2.get(i));
            if (result == 0) continue;
            return result;
        }
        return size1 == size2 ? 0 : (size1 < size2 ? -1 : 1);
    }

    public static int compareMediaTypes(MediaType mt1, MediaType mt2) {
        if (mt1.isWildcardType() && !mt2.isWildcardType()) {
            return 1;
        }
        if (!mt1.isWildcardType() && mt2.isWildcardType()) {
            return -1;
        }
        if (mt1.isWildcardSubtype() && !mt2.isWildcardSubtype()) {
            return 1;
        }
        if (!mt1.isWildcardSubtype() && mt2.isWildcardSubtype()) {
            return -1;
        }
        return JAXRSUtils.compareMediaTypesQualityFactors(mt1, mt2);
    }

    public static int compareMediaTypesQualityFactors(MediaType mt1, MediaType mt2) {
        float q1 = JAXRSUtils.getMediaTypeQualityFactor((String)mt1.getParameters().get("q"));
        float q2 = JAXRSUtils.getMediaTypeQualityFactor((String)mt2.getParameters().get("q"));
        return Float.compare(q1, q2) * -1;
    }

    public static float getMediaTypeQualityFactor(String q) {
        if (q == null) {
            return 1.0f;
        }
        if (q.charAt(0) == '.') {
            q = '0' + q;
        }
        try {
            return Float.parseFloat(q);
        }
        catch (NumberFormatException numberFormatException) {
            return 1.0f;
        }
    }

    public static List<Object> processParameters(OperationResourceInfo ori, MultivaluedMap<String, String> values, Message message) {
        Method method = ori.getMethodToInvoke();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Parameter[] paramsInfo = ori.getParameters().toArray(new Parameter[0]);
        Method annotatedMethod = ori.getAnnotatedMethod();
        Type[] genericParameterTypes = annotatedMethod == null ? method.getGenericParameterTypes() : annotatedMethod.getGenericParameterTypes();
        Annotation[][] anns = annotatedMethod == null ? (Annotation[][])null : annotatedMethod.getParameterAnnotations();
        ArrayList<Object> params = new ArrayList<Object>(parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class param = parameterTypes[i];
            Type genericParam = genericParameterTypes[i];
            if (param == Object.class && genericParam instanceof TypeVariable) {
                genericParam = InjectionUtils.getSuperType(ori.getClassResourceInfo().getServiceClass(), (TypeVariable)genericParam);
                param = (Class)genericParam;
            }
            Object paramValue = JAXRSUtils.processParameter(param, genericParam, anns == null ? new Annotation[]{} : anns[i], paramsInfo[i], values, message, ori);
            params.add(paramValue);
        }
        return params;
    }

    private static Object processParameter(Class<?> parameterClass, Type parameterType, Annotation[] parameterAnns, Parameter parameter, MultivaluedMap<String, String> values, Message message, OperationResourceInfo ori) {
        InputStream is = message.getContent(InputStream.class);
        if (parameter.getType() == ParameterType.REQUEST_BODY) {
            String contentType = (String)message.get("Content-Type");
            if (contentType == null) {
                org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message("NO_CONTENT_TYPE_SPECIFIED", BUNDLE, ori.getHttpMethod());
                LOG.fine(errorMsg.toString());
                contentType = "*/*";
            }
            return JAXRSUtils.readFromMessageBody(parameterClass, parameterType, parameterAnns, is, MediaType.valueOf((String)contentType), ori.getConsumeTypes(), message);
        }
        if (parameter.getType() == ParameterType.CONTEXT) {
            return JAXRSUtils.createContextValue(message, parameterType, parameterClass);
        }
        return JAXRSUtils.createHttpParameterValue(parameter, parameterClass, parameterType, message, values, ori);
    }

    public static Object createHttpParameterValue(Parameter parameter, Class<?> parameterClass, Type genericParam, Message message, MultivaluedMap<String, String> values, OperationResourceInfo ori) {
        boolean isEncoded = parameter.isEncoded() || ori != null && ori.isEncodedEnabled();
        String defaultValue = parameter.getDefaultValue();
        if (defaultValue == null && ori != null) {
            defaultValue = ori.getDefaultParameterValue();
        }
        Object result = null;
        if (parameter.getType() == ParameterType.PATH) {
            result = JAXRSUtils.readFromUriParam(message, parameter.getName(), parameterClass, genericParam, values, defaultValue, !isEncoded);
        }
        if (parameter.getType() == ParameterType.QUERY) {
            result = JAXRSUtils.readQueryString(parameter.getName(), parameterClass, genericParam, message, defaultValue, !isEncoded);
        }
        if (parameter.getType() == ParameterType.MATRIX) {
            result = JAXRSUtils.processMatrixParam(message, parameter.getName(), parameterClass, genericParam, defaultValue, !isEncoded);
        }
        if (parameter.getType() == ParameterType.FORM) {
            result = JAXRSUtils.processFormParam(message, parameter.getName(), parameterClass, genericParam, defaultValue, !isEncoded);
        }
        if (parameter.getType() == ParameterType.COOKIE) {
            result = JAXRSUtils.processCookieParam(message, parameter.getName(), parameterClass, genericParam, defaultValue);
        }
        if (parameter.getType() == ParameterType.HEADER) {
            result = JAXRSUtils.processHeaderParam(message, parameter.getName(), parameterClass, genericParam, defaultValue);
        }
        return result;
    }

    private static Object processMatrixParam(Message m, String key, Class<?> pClass, Type genericType, String defaultValue, boolean decode) {
        List<PathSegment> segments = JAXRSUtils.getPathSegments((String)m.get(Message.REQUEST_URI), decode);
        if (segments.size() > 0) {
            MetadataMap<String, String> params = new MetadataMap<String, String>();
            for (PathSegment ps : segments) {
                MultivaluedMap matrix = ps.getMatrixParameters();
                for (Map.Entry entry : matrix.entrySet()) {
                    for (String value : (List)entry.getValue()) {
                        params.add(entry.getKey(), value);
                    }
                }
            }
            if ("".equals(key)) {
                return InjectionUtils.handleBean(pClass, params, ParameterType.MATRIX, m, false);
            }
            List values = (List)params.get(key);
            return InjectionUtils.createParameterObject(values, pClass, genericType, defaultValue, false, ParameterType.MATRIX, m);
        }
        return null;
    }

    private static Object processFormParam(Message m, String key, Class<?> pClass, Type genericType, String defaultValue, boolean decode) {
        MessageContextImpl mc = new MessageContextImpl(m);
        MediaType mt = mc.getHttpHeaders().getMediaType();
        MetadataMap<String, String> params = (MetadataMap<String, String>)m.get(FORM_PARAM_MAP);
        if (params == null) {
            Object body;
            params = new MetadataMap<String, String>();
            m.put(FORM_PARAM_MAP, params);
            if (mt == null || mt.isCompatible(MediaType.APPLICATION_FORM_URLENCODED_TYPE)) {
                body = (String)m.get("org.apache.cxf.jaxrs.provider.form.body");
                if (body == null) {
                    body = FormUtils.readBody(m.getContent(InputStream.class));
                    m.put("org.apache.cxf.jaxrs.provider.form.body", body);
                }
                HttpServletRequest request = (HttpServletRequest)m.get("HTTP.REQUEST");
                FormUtils.populateMapFromString(params, (String)body, decode, request);
            } else if (mt != null && "multipart".equalsIgnoreCase(mt.getType()) && MediaType.MULTIPART_FORM_DATA_TYPE.isCompatible(mt)) {
                body = AttachmentUtils.getMultipartBody(mc);
                FormUtils.populateMapFromMultipart(params, (MultipartBody)body, decode);
            } else {
                org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message("WRONG_FORM_MEDIA_TYPE", BUNDLE, mt == null ? "*/*" : mt.toString());
                LOG.warning(errorMsg.toString());
                throw new WebApplicationException(415);
            }
        }
        if ("".equals(key)) {
            return InjectionUtils.handleBean(pClass, params, ParameterType.FORM, m, false);
        }
        List results = (List)params.get(key);
        return InjectionUtils.createParameterObject(results, pClass, genericType, defaultValue, false, ParameterType.FORM, m);
    }

    public static MultivaluedMap<String, String> getMatrixParams(String path, boolean decode) {
        int index = path.indexOf(59);
        return index == -1 ? new MetadataMap<String, String>() : JAXRSUtils.getStructuredParams(path.substring(index + 1), ";", decode);
    }

    private static Object processHeaderParam(Message m, String header, Class<?> pClass, Type genericType, String defaultValue) {
        List<String> values = new HttpHeadersImpl(m).getRequestHeader(header);
        if (values != null && values.isEmpty()) {
            values = null;
        }
        return InjectionUtils.createParameterObject(values, pClass, genericType, defaultValue, false, ParameterType.HEADER, m);
    }

    private static Object processCookieParam(Message m, String cookieName, Class<?> pClass, Type genericType, String defaultValue) {
        Cookie c = new HttpHeadersImpl(m).getCookies().get(cookieName);
        if (c == null && defaultValue != null) {
            c = Cookie.valueOf((String)(cookieName + '=' + defaultValue));
        }
        if (c == null) {
            return null;
        }
        if (pClass.isAssignableFrom(Cookie.class)) {
            return c;
        }
        return InjectionUtils.handleParameter(c.getValue(), pClass, ParameterType.COOKIE, m);
    }

    public static <T> T createContextValue(Message m, Type genericType, Class<T> clazz) {
        Message contextMessage;
        Message message = contextMessage = m.getExchange() != null ? m.getExchange().getInMessage() : m;
        if (contextMessage == null && Boolean.FALSE.equals(m.get("org.apache.cxf.message.inbound"))) {
            contextMessage = m;
        }
        Object o = null;
        if (UriInfo.class.isAssignableFrom(clazz)) {
            o = JAXRSUtils.createUriInfo(contextMessage);
        } else if (HttpHeaders.class.isAssignableFrom(clazz)) {
            o = JAXRSUtils.createHttpHeaders(contextMessage);
        } else if (Request.class.isAssignableFrom(clazz)) {
            o = new RequestImpl(contextMessage);
        } else if (SecurityContext.class.isAssignableFrom(clazz)) {
            o = new SecurityContextImpl(contextMessage);
        } else if (Providers.class.isAssignableFrom(clazz)) {
            o = new ProvidersImpl(contextMessage);
        } else if (ContextResolver.class.isAssignableFrom(clazz)) {
            o = JAXRSUtils.createContextResolver(genericType, contextMessage);
        } else if (MessageContext.class.isAssignableFrom(clazz)) {
            o = new MessageContextImpl(m);
        }
        o = o == null ? JAXRSUtils.createServletResourceValue(contextMessage, clazz) : o;
        return clazz.cast(o);
    }

    private static UriInfo createUriInfo(Message m) {
        if (MessageUtils.isRequestor(m)) {
            m = m.getExchange() != null ? m.getExchange().getOutMessage() : m;
        }
        MultivaluedMap templateParams = (MultivaluedMap)m.get("jaxrs.template.parameters");
        return new UriInfoImpl(m, (MultivaluedMap<String, String>)templateParams);
    }

    private static HttpHeaders createHttpHeaders(Message m) {
        if (MessageUtils.isRequestor(m)) {
            m = m.getExchange() != null ? m.getExchange().getOutMessage() : m;
        }
        return new HttpHeadersImpl(m);
    }

    public static ContextResolver<?> createContextResolver(Type genericType, Message m) {
        if (genericType instanceof ParameterizedType) {
            return ProviderFactory.getInstance(m).createContextResolver(((ParameterizedType)genericType).getActualTypeArguments()[0], m);
        }
        if (m != null) {
            return ProviderFactory.getInstance(m).createContextResolver(genericType, m);
        }
        return null;
    }

    public static Object createResourceValue(Message m, Type genericType, Class<?> clazz) {
        return JAXRSUtils.createContextValue(m, genericType, clazz);
    }

    public static <T> T createServletResourceValue(Message m, Class<T> clazz) {
        HttpServletResponseFilter value = null;
        if (HttpServletRequest.class.isAssignableFrom(clazz)) {
            value = (HttpServletResponseFilter)((Object)m.get("HTTP.REQUEST"));
        }
        if (HttpServletResponse.class.isAssignableFrom(clazz)) {
            value = new HttpServletResponseFilter((HttpServletResponse)m.get("HTTP.RESPONSE"), m);
        }
        if (ServletContext.class.isAssignableFrom(clazz)) {
            value = (HttpServletResponseFilter)((Object)m.get("HTTP.CONTEXT"));
        }
        if (ServletConfig.class.isAssignableFrom(clazz)) {
            value = m.get("HTTP.CONFIG");
        }
        return clazz.cast((Object)value);
    }

    private static Object readFromUriParam(Message m, String parameterName, Class<?> paramType, Type genericType, MultivaluedMap<String, String> values, String defaultValue, boolean decoded) {
        if ("".equals(parameterName)) {
            return InjectionUtils.handleBean(paramType, values, ParameterType.PATH, m, decoded);
        }
        List results = (List)values.get((Object)parameterName);
        return InjectionUtils.createParameterObject(results, paramType, genericType, defaultValue, decoded, ParameterType.PATH, m);
    }

    private static Object readQueryString(String queryName, Class<?> paramType, Type genericType, Message m, String defaultValue, boolean decode) {
        if ("".equals(queryName)) {
            return InjectionUtils.handleBean(paramType, new UriInfoImpl(m, null).getQueryParameters(), ParameterType.QUERY, m, decode);
        }
        List results = (List)JAXRSUtils.getStructuredParams((String)m.get(Message.QUERY_STRING), "&", decode).get((Object)queryName);
        return InjectionUtils.createParameterObject(results, paramType, genericType, defaultValue, false, ParameterType.QUERY, m);
    }

    public static MultivaluedMap<String, String> getStructuredParams(String query, String sep, boolean decode) {
        MetadataMap<String, String> queries = new MetadataMap<String, String>(new LinkedHashMap());
        if (!StringUtils.isEmpty(query)) {
            List<String> parts = Arrays.asList(query.split(sep));
            for (String part : parts) {
                String[] values = part.split("=");
                String value = null;
                value = values.length == 1 ? "" : (decode ? ("&".equals(sep) ? HttpUtils.urlDecode(values[1]) : HttpUtils.pathDecode(values[1])) : values[1]);
                queries.add(HttpUtils.urlDecode(values[0]), value);
            }
        }
        return queries;
    }

    private static <T> Object readFromMessageBody(Class<T> targetTypeClass, Type parameterType, Annotation[] parameterAnnotations, InputStream is, MediaType contentType, List<MediaType> consumeTypes, Message m) {
        List<MediaType> types = JAXRSUtils.intersectMimeTypes(consumeTypes, contentType);
        MessageBodyReader<T> provider = null;
        Iterator<MediaType> i$ = types.iterator();
        if (i$.hasNext()) {
            MediaType type = i$.next();
            provider = ProviderFactory.getInstance(m).createMessageBodyReader(targetTypeClass, parameterType, parameterAnnotations, type, m);
            if (provider != null) {
                try {
                    HttpHeadersImpl headers = new HttpHeadersImpl(m);
                    return provider.readFrom(targetTypeClass, parameterType, parameterAnnotations, contentType, headers.getRequestHeaders(), is);
                }
                catch (IOException e) {
                    String errorMessage = "Error deserializing input stream into target class " + targetTypeClass.getSimpleName() + ", content type : " + contentType;
                    LOG.severe(errorMessage);
                    throw new WebApplicationException((Throwable)e);
                }
                catch (WebApplicationException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new WebApplicationException((Throwable)ex);
                }
            }
            String errorMessage = new org.apache.cxf.common.i18n.Message("NO_MSG_READER", BUNDLE, targetTypeClass.getSimpleName(), contentType).toString();
            LOG.warning(errorMessage);
            throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
        }
        return null;
    }

    public static boolean matchConsumeTypes(MediaType requestContentType, OperationResourceInfo ori) {
        return JAXRSUtils.intersectMimeTypes(ori.getConsumeTypes(), requestContentType).size() != 0;
    }

    public static boolean matchProduceTypes(MediaType acceptContentType, OperationResourceInfo ori) {
        return JAXRSUtils.intersectMimeTypes(ori.getProduceTypes(), acceptContentType).size() != 0;
    }

    public static boolean matchMimeTypes(MediaType requestContentType, MediaType acceptContentType, OperationResourceInfo ori) {
        return JAXRSUtils.intersectMimeTypes(ori.getConsumeTypes(), requestContentType).size() != 0 && JAXRSUtils.intersectMimeTypes(ori.getProduceTypes(), acceptContentType).size() != 0;
    }

    public static List<MediaType> parseMediaTypes(String types) {
        ArrayList<MediaType> acceptValues = new ArrayList<MediaType>();
        if (types != null) {
            while (types.length() > 0) {
                String tp = types;
                int index = types.indexOf(44);
                if (index != -1) {
                    tp = types.substring(0, index);
                    types = types.substring(index + 1).trim();
                } else {
                    types = "";
                }
                acceptValues.add(MediaType.valueOf((String)tp));
            }
        } else {
            acceptValues.add(ALL_TYPES);
        }
        return acceptValues;
    }

    public static List<MediaType> intersectMimeTypes(List<MediaType> requiredMediaTypes, List<MediaType> userMediaTypes) {
        LinkedHashSet<MediaType> supportedMimeTypeList = new LinkedHashSet<MediaType>();
        for (MediaType requiredType : requiredMediaTypes) {
            for (MediaType userType : userMediaTypes) {
                boolean isCompatible;
                boolean bl = isCompatible = requiredType.isCompatible(userType) || userType.isCompatible(requiredType);
                if (!isCompatible && requiredType.getType().equalsIgnoreCase(userType.getType())) {
                    String[] subtypes1 = requiredType.getSubtype().split("\\+");
                    String[] subtypes2 = userType.getSubtype().split("\\+");
                    if (subtypes1.length == 2 && subtypes2.length == 2 && subtypes1[1].equalsIgnoreCase(subtypes2[1]) && (subtypes1[0].equals("*") || subtypes2[0].equals("*"))) {
                        isCompatible = true;
                    }
                }
                if (!isCompatible) continue;
                boolean parametersMatched = true;
                for (Map.Entry entry : userType.getParameters().entrySet()) {
                    String value = (String)requiredType.getParameters().get(entry.getKey());
                    if (value == null || value.equals(entry.getValue())) continue;
                    parametersMatched = false;
                    break;
                }
                if (!parametersMatched) continue;
                String type = requiredType.getType().equals("*") ? userType.getType() : requiredType.getType();
                String subtype = requiredType.getSubtype().equals("*") ? userType.getSubtype() : requiredType.getSubtype();
                supportedMimeTypeList.add(new MediaType(type, subtype, userType.getParameters()));
            }
        }
        return new ArrayList<MediaType>(supportedMimeTypeList);
    }

    public static List<MediaType> intersectMimeTypes(List<MediaType> mimeTypesA, MediaType mimeTypeB) {
        return JAXRSUtils.intersectMimeTypes(mimeTypesA, Collections.singletonList(mimeTypeB));
    }

    public static List<MediaType> intersectMimeTypes(String mimeTypesA, String mimeTypesB) {
        return JAXRSUtils.intersectMimeTypes(JAXRSUtils.parseMediaTypes(mimeTypesA), JAXRSUtils.parseMediaTypes(mimeTypesB));
    }

    public static List<MediaType> sortMediaTypes(String mediaTypes) {
        return JAXRSUtils.sortMediaTypes(JAXRSUtils.parseMediaTypes(mediaTypes));
    }

    public static List<MediaType> sortMediaTypes(List<MediaType> types) {
        if (types.size() > 1) {
            Collections.sort(types, new Comparator<MediaType>(){

                @Override
                public int compare(MediaType mt1, MediaType mt2) {
                    return JAXRSUtils.compareMediaTypes(mt1, mt2);
                }
            });
        }
        return types;
    }

    public static Response convertFaultToResponse(Throwable ex, Message inMessage) {
        ExceptionMapper mapper = ProviderFactory.getInstance(inMessage).createExceptionMapper(ex.getClass(), inMessage);
        if (mapper != null) {
            try {
                return mapper.toResponse(ex);
            }
            catch (Exception mapperEx) {
                mapperEx.printStackTrace();
                return Response.serverError().build();
            }
        }
        return null;
    }

    public static String removeMediaTypeParameter(MediaType mt, String paramName) {
        StringBuilder sb = new StringBuilder();
        sb.append(mt.getType()).append('/').append(mt.getSubtype());
        if (mt.getParameters().size() > 1) {
            for (String key : mt.getParameters().keySet()) {
                if (paramName.equals(key)) continue;
                sb.append(';').append(key).append('=').append((String)mt.getParameters().get(key));
            }
        }
        return sb.toString();
    }

    public static boolean propogateException(Message m) {
        Object value = m.getContextualProperty(PROPOGATE_EXCEPTION);
        if (value == null) {
            return true;
        }
        return Boolean.TRUE.equals(value) || "true".equalsIgnoreCase(value.toString());
    }

    public static QName getClassQName(Class<?> type) {
        String nsURI = PackageUtils.getNamespace(PackageUtils.getPackageName(type));
        if (nsURI.endsWith("/")) {
            nsURI = nsURI.substring(0, nsURI.length() - 1);
        }
        return new QName(nsURI, type.getSimpleName(), "ns1");
    }
}

