/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.servlet.AbstractServletController;
import org.apache.cxf.transport.servlet.ServletDestination;
import org.apache.cxf.transport.servlet.ServletTransportFactory;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.transports.http.QueryHandlerRegistry;
import org.apache.cxf.wsdl.http.AddressType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletController
extends AbstractServletController {
    private static final Logger LOG = LogUtils.getL7dLogger(ServletController.class);
    private ServletTransportFactory transport;
    private ServletContext servletContext;
    private ServletConfig servletConfig;
    private Bus bus;
    private String lastBase = "";

    public ServletController(ServletTransportFactory df, ServletConfig config, ServletContext context, Bus b) {
        super(config);
        this.transport = df;
        this.servletConfig = config;
        this.servletContext = context;
        this.bus = b;
        this.init();
    }

    ServletController() {
    }

    String getLastBaseURL() {
        return this.lastBase;
    }

    protected synchronized void updateDests(HttpServletRequest request) {
        String base;
        if (this.disableAddressUpdates) {
            return;
        }
        String string = base = this.forcedBaseAddress == null ? this.getBaseURL(request) : this.forcedBaseAddress;
        if (base.equals(this.lastBase)) {
            return;
        }
        Set<String> paths = this.transport.getDestinationsPaths();
        for (String path : paths) {
            ServletDestination d2 = this.transport.getDestinationForPath(path);
            String ad = d2.getEndpointInfo().getAddress();
            if (!ad.equals(path) && !ad.equals(this.lastBase + path)) continue;
            d2.getEndpointInfo().setAddress(base + path);
            if (d2.getEndpointInfo().getExtensor(AddressType.class) == null) continue;
            d2.getEndpointInfo().getExtensor(AddressType.class).setLocation(base + path);
        }
        this.lastBase = base;
    }

    public void invoke(HttpServletRequest request, HttpServletResponse res) throws ServletException {
        block18: {
            try {
                EndpointInfo ei = new EndpointInfo();
                String address = request.getPathInfo() == null ? "" : request.getPathInfo();
                ei.setAddress(address);
                ServletDestination d = this.getDestination(ei.getAddress());
                if (d == null) {
                    if (!this.isHideServiceList && (request.getRequestURI().endsWith(this.serviceListRelativePath) || request.getRequestURI().endsWith(this.serviceListRelativePath + "/") || StringUtils.isEmpty(request.getPathInfo()) || "/".equals(request.getPathInfo()))) {
                        this.updateDests(request);
                        if (request.getParameter("stylesheet") != null) {
                            this.renderStyleSheet(request, res);
                        } else if ("false".equals(request.getParameter("formatted"))) {
                            this.generateUnformattedServiceList(request, res);
                        } else {
                            this.generateServiceList(request, res);
                        }
                    } else {
                        d = this.checkRestfulRequest(request);
                        if (d == null || d.getMessageObserver() == null) {
                            LOG.warning("Can't find the request for " + request.getRequestURL() + "'s Observer ");
                            this.generateNotFound(request, res);
                        } else {
                            this.updateDests(request);
                            this.invokeDestination(request, res, d);
                        }
                    }
                    break block18;
                }
                ei = d.getEndpointInfo();
                if (null != request.getQueryString() && request.getQueryString().length() > 0 && this.bus.getExtension(QueryHandlerRegistry.class) != null) {
                    String ctxUri = request.getPathInfo();
                    String baseUri = request.getRequestURL().toString() + "?" + request.getQueryString();
                    if ("GET".equals(request.getMethod())) {
                        this.updateDests(request);
                    }
                    for (QueryHandler qh : this.bus.getExtension(QueryHandlerRegistry.class).getHandlers()) {
                        if (!qh.isRecognizedQuery(baseUri, ctxUri, ei)) continue;
                        res.setContentType(qh.getResponseContentType(baseUri, ctxUri));
                        ServletOutputStream out = res.getOutputStream();
                        try {
                            qh.writeResponse(baseUri, ctxUri, ei, (OutputStream)out);
                        }
                        catch (Exception e) {
                            LogUtils.log(LOG, Level.WARNING, qh.getClass().getName() + " Exception caught writing response.", e);
                            throw new ServletException((Throwable)e);
                        }
                        out.flush();
                        return;
                    }
                }
                this.invokeDestination(request, res, d);
            }
            catch (Fault ex) {
                if (ex.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)ex.getCause();
                }
                throw new ServletException(ex.getCause());
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    protected ServletDestination getDestination(String address) {
        return this.transport.getDestinationForPath(address, true);
    }

    protected ServletDestination checkRestfulRequest(HttpServletRequest request) throws IOException {
        String address = request.getPathInfo() == null ? "" : request.getPathInfo();
        int len = -1;
        ServletDestination ret = null;
        for (String path : this.transport.getDestinationsPaths()) {
            if (!address.startsWith(path) || path.length() <= len) continue;
            ret = this.transport.getDestinationForPath(path);
            len = path.length();
        }
        return ret;
    }

    protected void generateServiceList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html; charset=UTF-8");
        response.getWriter().write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        response.getWriter().write("<HTML><HEAD>");
        if (this.serviceListStyleSheet != null) {
            response.getWriter().write("<LINK type=\"text/css\" rel=\"stylesheet\" href=\"" + request.getContextPath() + "/" + this.serviceListStyleSheet + "\">");
        } else {
            response.getWriter().write("<LINK type=\"text/css\" rel=\"stylesheet\" href=\"" + request.getRequestURI() + "/?stylesheet=1\">");
        }
        response.getWriter().write("<meta http-equiv=content-type content=\"text/html; charset=UTF-8\">");
        response.getWriter().write("<title>CXF - Service list</title>");
        response.getWriter().write("</head><body>");
        List<ServletDestination> destinations = this.getServletDestinations();
        if (destinations.size() > 0) {
            this.writeSOAPEndpoints(response, destinations);
            this.writeRESTfulEndpoints(response, destinations);
        } else {
            response.getWriter().write("<span class=\"heading\">No services have been found.</span>");
        }
        response.getWriter().write("</body></html>");
    }

    private void writeSOAPEndpoints(HttpServletResponse response, List<ServletDestination> destinations) throws IOException {
        response.getWriter().write("<span class=\"heading\">Available SOAP services:</span><br/>");
        response.getWriter().write("<table " + (this.serviceListStyleSheet == null ? "cellpadding=\"1\" cellspacing=\"1\" border=\"1\" width=\"100%\"" : "") + ">");
        for (ServletDestination sd : destinations) {
            if (null == sd.getEndpointInfo().getName() || null == sd.getEndpointInfo().getInterface()) continue;
            response.getWriter().write("<tr><td>");
            response.getWriter().write("<span class=\"porttypename\">" + sd.getEndpointInfo().getInterface().getName().getLocalPart() + "</span>");
            response.getWriter().write("<ul>");
            for (OperationInfo oi : sd.getEndpointInfo().getInterface().getOperations()) {
                if (oi.getProperty("operation.is.synthetic") == Boolean.TRUE) continue;
                response.getWriter().write("<li>" + oi.getName().getLocalPart() + "</li>");
            }
            response.getWriter().write("</ul>");
            response.getWriter().write("</td><td>");
            String address = sd.getEndpointInfo().getAddress();
            response.getWriter().write("<span class=\"field\">Endpoint address:</span> <span class=\"value\">" + address + "</span>");
            response.getWriter().write("<br/><span class=\"field\">WSDL :</span> <a href=\"" + address + "?wsdl\">" + sd.getEndpointInfo().getService().getName() + "</a>");
            response.getWriter().write("<br/><span class=\"field\">Target namespace:</span> <span class=\"value\">" + sd.getEndpointInfo().getService().getTargetNamespace() + "</span>");
            response.getWriter().write("</td></tr>");
        }
        response.getWriter().write("</table><br/><br/>");
    }

    private void writeRESTfulEndpoints(HttpServletResponse response, List<ServletDestination> destinations) throws IOException {
        ArrayList<ServletDestination> restfulDests = new ArrayList<ServletDestination>();
        for (ServletDestination sd : destinations) {
            if (null != sd.getEndpointInfo().getInterface()) continue;
            restfulDests.add(sd);
        }
        if (restfulDests.size() == 0) {
            return;
        }
        response.getWriter().write("<span class=\"heading\">Available RESTful services:</span><br/>");
        response.getWriter().write("<table " + (this.serviceListStyleSheet == null ? "cellpadding=\"1\" cellspacing=\"1\" border=\"1\" width=\"100%\"" : "") + ">");
        for (ServletDestination sd : destinations) {
            if (null != sd.getEndpointInfo().getInterface()) continue;
            response.getWriter().write("<tr><td>");
            String address = sd.getEndpointInfo().getAddress();
            response.getWriter().write("<span class=\"field\">Endpoint address:</span> <span class=\"value\">" + address + "</span>");
            response.getWriter().write("<br/><span class=\"field\">WADL :</span> <a href=\"" + address + "?_wadl&_type=xml\">" + address + "?_wadl&type=xml" + "</a>");
            response.getWriter().write("</td></tr>");
        }
        response.getWriter().write("</table>");
    }

    private void renderStyleSheet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/css; charset=UTF-8");
        URL url = this.getClass().getResource("servicelist.css");
        if (url != null) {
            IOUtils.copy(url.openStream(), (OutputStream)response.getOutputStream());
        }
    }

    private List<ServletDestination> getServletDestinations() {
        LinkedList<ServletDestination> destinations = new LinkedList<ServletDestination>(this.transport.getDestinations());
        Collections.sort(destinations, new Comparator<ServletDestination>(){

            @Override
            public int compare(ServletDestination o1, ServletDestination o2) {
                if (o1.getEndpointInfo().getInterface() == null) {
                    return -1;
                }
                if (o2.getEndpointInfo().getInterface() == null) {
                    return 1;
                }
                return o1.getEndpointInfo().getInterface().getName().getLocalPart().compareTo(o2.getEndpointInfo().getInterface().getName().getLocalPart());
            }
        });
        return destinations;
    }

    protected void generateUnformattedServiceList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/plain; charset=UTF-8");
        List<ServletDestination> destinations = this.getServletDestinations();
        if (destinations.size() > 0) {
            this.writeUnformattedSOAPEndpoints(response, destinations, request.getParameter("wsdlList"));
            this.writeUnformattedRESTfulEndpoints(response, destinations);
        } else {
            response.getWriter().write("No services have been found.");
        }
    }

    private void writeUnformattedSOAPEndpoints(HttpServletResponse response, List<ServletDestination> destinations, Object renderParam) throws IOException {
        boolean renderWsdlList = "true".equals(renderParam);
        for (ServletDestination sd : destinations) {
            if (null == sd.getEndpointInfo().getInterface()) continue;
            String address = sd.getEndpointInfo().getAddress();
            response.getWriter().write(address);
            if (renderWsdlList) {
                response.getWriter().write("?wsdl");
            }
            response.getWriter().write(10);
        }
        response.getWriter().write(10);
    }

    private void writeUnformattedRESTfulEndpoints(HttpServletResponse response, List<ServletDestination> destinations) throws IOException {
        for (ServletDestination sd : destinations) {
            if (null != sd.getEndpointInfo().getInterface()) continue;
            String address = sd.getEndpointInfo().getAddress();
            response.getWriter().write(address + "?_wadl&_type=xml");
            response.getWriter().write(10);
        }
    }

    protected void generateNotFound(HttpServletRequest request, HttpServletResponse res) throws IOException {
        res.setStatus(404);
        res.setContentType("text/html");
        res.getWriter().write("<html><body>No service was found.</body></html>");
    }

    public void invokeDestination(HttpServletRequest request, HttpServletResponse response, ServletDestination d) throws ServletException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Service http request on thread: " + Thread.currentThread());
        }
        try {
            d.invoke(this.servletConfig, this.servletContext, request, response);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Finished servicing http request on thread: " + Thread.currentThread());
            }
        }
    }

    private void init() {
        this.transport.setServletController(this);
    }
}

