/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.databinding.source;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDataReader
implements DataReader<Node> {
    private static final Logger LOG = LogUtils.getL7dLogger(NodeDataReader.class);

    @Override
    public Object read(MessagePartInfo part, Node input) {
        return this.read(input);
    }

    @Override
    public Object read(QName name, Node input, Class type) {
        if (SAXSource.class.isAssignableFrom(type)) {
            try {
                CachedOutputStream out = new CachedOutputStream();
                DOMUtils.writeXml(input, out);
                return new SAXSource(new InputSource(out.getInputStream()));
            }
            catch (IOException e) {
                throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
            }
            catch (TransformerException e) {
                throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
            }
        }
        if (StreamSource.class.isAssignableFrom(type)) {
            try {
                CachedOutputStream out = new CachedOutputStream();
                DOMUtils.writeXml(input, out);
                InputStream is = out.getInputStream();
                out.close();
                return new StreamSource(is);
            }
            catch (IOException e) {
                throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
            }
            catch (TransformerException e) {
                throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
            }
        }
        return this.read(input);
    }

    @Override
    public Object read(Node n) {
        return new DOMSource(n);
    }

    @Override
    public void setSchema(Schema s) {
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
    }

    @Override
    public void setProperty(String prop, Object value) {
    }
}

