/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSS4JInInterceptor
extends AbstractWSS4JInterceptor {
    public static final String TIMESTAMP_RESULT = "wss4j.timestamp.result";
    public static final String SIGNATURE_RESULT = "wss4j.signature.result";
    public static final String PRINCIPAL_RESULT = "wss4j.principal.result";
    public static final String PROCESSOR_MAP = "wss4j.processor.map";
    public static final String SECURITY_PROCESSED = WSS4JInInterceptor.class.getName() + ".DONE";
    private static final Logger LOG = LogUtils.getL7dLogger(WSS4JInInterceptor.class);
    private static final Logger TIME_LOG = LogUtils.getL7dLogger(WSS4JInInterceptor.class, null, WSS4JInInterceptor.class.getName() + "-Time");
    private SAAJInInterceptor saajIn = new SAAJInInterceptor();
    private boolean ignoreActions;
    private WSSecurityEngine secEngineOverride;

    public WSS4JInInterceptor() {
        this.setPhase("pre-protocol");
        this.getAfter().add(SAAJInInterceptor.class.getName());
    }

    public WSS4JInInterceptor(boolean ignore) {
        this();
        this.ignoreActions = ignore;
    }

    public WSS4JInInterceptor(Map<String, Object> properties) {
        this();
        this.setProperties(properties);
        Map<QName, Object> map = CastUtils.cast((Map)properties.get(PROCESSOR_MAP));
        if (map != null) {
            this.secEngineOverride = WSS4JInInterceptor.createSecurityEngine(map);
        }
    }

    public void setIgnoreActions(boolean i) {
        this.ignoreActions = i;
    }

    private SOAPMessage getSOAPMessage(SoapMessage msg) {
        SOAPMessage doc = msg.getContent(SOAPMessage.class);
        if (doc == null) {
            this.saajIn.handleMessage(msg);
            doc = msg.getContent(SOAPMessage.class);
        }
        return doc;
    }

    @Override
    public Object getProperty(Object msgContext, String key) {
        Object result = super.getProperty(msgContext, key);
        if (result == null && key == "_sendSignatureValues_" && this.isRequestor((SoapMessage)msgContext)) {
            result = ((SoapMessage)msgContext).getExchange().getOutMessage().get(key);
        }
        return result;
    }

    public final boolean isGET(SoapMessage message) {
        String method = (String)message.get("org.apache.cxf.request.method");
        return "GET".equals(method) && message.getContent(XMLStreamReader.class) == null;
    }

    @Override
    public void handleMessage(SoapMessage msg) throws Fault {
        WSSecurityEngine engine;
        if (msg.containsKey(SECURITY_PROCESSED) || this.isGET(msg)) {
            return;
        }
        msg.put(SECURITY_PROCESSED, (Object)Boolean.TRUE);
        WSSConfig config = (WSSConfig)msg.getContextualProperty(WSSConfig.class.getName());
        if (config != null) {
            engine = new WSSecurityEngine();
            engine.setWssConfig(config);
        } else {
            engine = this.getSecurityEngine();
        }
        SOAPMessage doc = this.getSOAPMessage(msg);
        boolean doDebug = LOG.isLoggable(Level.FINE);
        boolean doTimeLog = TIME_LOG.isLoggable(Level.FINE);
        SoapVersion version = msg.getVersion();
        if (doDebug) {
            LOG.fine("WSS4JInInterceptor: enter handleMessage()");
        }
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        if (doTimeLog) {
            t0 = System.currentTimeMillis();
        }
        RequestData reqData = new RequestData();
        try {
            reqData.setMsgContext((Object)msg);
            this.computeAction(msg, reqData);
            Vector actions = new Vector();
            String action = this.getAction(msg, version);
            int doAction = WSSecurityUtil.decodeAction((String)action, actions);
            String actor = (String)this.getOption("actor");
            CallbackHandler cbHandler = this.getCallback(reqData, doAction);
            this.doReceiverAction(doAction, reqData);
            Vector wsResult = null;
            if (doTimeLog) {
                t1 = System.currentTimeMillis();
            }
            wsResult = engine.processSecurityHeader((Document)doc.getSOAPPart(), actor, cbHandler, reqData.getSigCrypto(), reqData.getDecCrypto());
            if (doTimeLog) {
                t2 = System.currentTimeMillis();
            }
            if (wsResult != null) {
                if (reqData.getWssConfig().isEnableSignatureConfirmation()) {
                    this.checkSignatureConfirmation(reqData, wsResult);
                }
                this.checkSignatures(msg, reqData, wsResult);
                this.checkTimestamps(msg, reqData, wsResult);
                this.checkActions(msg, reqData, wsResult, actions);
                this.doResults(msg, actor, doc, wsResult);
            } else {
                wsResult = new Vector();
                if (doc.getSOAPPart().getEnvelope().getBody().hasFault()) {
                    LOG.warning("Request does not contain Security header, but it's a fault.");
                    this.doResults(msg, actor, doc, wsResult);
                } else {
                    this.checkActions(msg, reqData, wsResult, actions);
                    this.doResults(msg, actor, doc, wsResult);
                }
            }
            if (doTimeLog) {
                t3 = System.currentTimeMillis();
                TIME_LOG.fine("Receive request: total= " + (t3 - t0) + " request preparation= " + (t1 - t0) + " request processing= " + (t2 - t1) + " header, cert verify, timestamp= " + (t3 - t2) + "\n");
            }
            if (doDebug) {
                LOG.fine("WSS4JInInterceptor: exit handleMessage()");
            }
        }
        catch (WSSecurityException e) {
            LOG.log(Level.WARNING, "", e);
            SoapFault fault = this.createSoapFault(version, e);
            throw fault;
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new Message("STAX_EX", LOG, new Object[0]), (Throwable)e, version.getSender());
        }
        catch (SOAPException e) {
            throw new SoapFault(new Message("SAAJ_EX", LOG, new Object[0]), (Throwable)e, version.getSender());
        }
        finally {
            reqData.clear();
            reqData = null;
        }
    }

    private void checkActions(SoapMessage msg, RequestData reqData, Vector wsResult, Vector actions) throws WSSecurityException {
        if (!this.ignoreActions && !this.checkReceiverResultsAnyOrder(wsResult, actions)) {
            LOG.warning("Security processing failed (actions mismatch)");
            throw new WSSecurityException(3);
        }
    }

    private void checkSignatures(SoapMessage msg, RequestData reqData, Vector wsResult) throws WSSecurityException {
        Vector signatureResults = new Vector();
        if (!(signatureResults = WSSecurityUtil.fetchAllActionResults((Vector)wsResult, (int)2, signatureResults)).isEmpty()) {
            for (int i = 0; i < signatureResults.size(); ++i) {
                WSSecurityEngineResult result = (WSSecurityEngineResult)signatureResults.get(i);
                X509Certificate returnCert = (X509Certificate)result.get((Object)"x509-certificate");
                X509Certificate[] returnCertChain = (X509Certificate[])result.get((Object)"x509-certificates");
                if (returnCertChain != null && !this.verifyTrust(returnCertChain, reqData)) {
                    LOG.warning("The certificate chain used for the signature is not trusted");
                    throw new WSSecurityException(6);
                }
                if (returnCert != null && !this.verifyTrust(returnCert, reqData)) {
                    LOG.warning("The certificate used for the signature is not trusted");
                    throw new WSSecurityException(6);
                }
                msg.put(SIGNATURE_RESULT, (Object)result);
            }
        }
    }

    protected void checkTimestamps(SoapMessage msg, RequestData reqData, Vector wsResult) throws WSSecurityException {
        Vector timestampResults = new Vector();
        if (!(timestampResults = WSSecurityUtil.fetchAllActionResults((Vector)wsResult, (int)32, timestampResults)).isEmpty()) {
            for (int i = 0; i < timestampResults.size(); ++i) {
                WSSecurityEngineResult result = (WSSecurityEngineResult)timestampResults.get(i);
                Timestamp timestamp = (Timestamp)result.get((Object)"timestamp");
                if (timestamp != null && !this.verifyTimestamp(timestamp, this.decodeTimeToLive(reqData))) {
                    LOG.warning("The timestamp could not be validated");
                    throw new WSSecurityException(8);
                }
                msg.put(TIMESTAMP_RESULT, (Object)result);
            }
        }
    }

    protected void computeAction(SoapMessage msg, RequestData reqData) {
    }

    protected void doResults(SoapMessage msg, String actor, SOAPMessage doc, Vector wsResult) throws SOAPException, XMLStreamException, WSSecurityException {
        List results = CastUtils.cast((List)msg.get("RECV_RESULTS"));
        if (results == null) {
            results = new Vector();
            msg.put("RECV_RESULTS", (Object)results);
        }
        WSHandlerResult rResult = new WSHandlerResult(actor, wsResult);
        results.add(0, rResult);
        SOAPBody body = doc.getSOAPBody();
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(new DOMSource((Node)body));
        int evt = reader.next();
        for (int i = 0; reader.hasNext() && i < 1 && (evt != 2 || evt != 1); ++i) {
            reader.next();
        }
        msg.setContent(XMLStreamReader.class, reader);
        String pwType = (String)this.getProperty(msg, "passwordType");
        if ("PasswordDigest".equals(pwType)) {
            for (WSSecurityEngineResult o : CastUtils.cast(wsResult, WSSecurityEngineResult.class)) {
                WSUsernameTokenPrincipal princ;
                Integer actInt = (Integer)o.get((Object)"action");
                if (actInt != 1 || (princ = (WSUsernameTokenPrincipal)o.get((Object)"principal")).isPasswordDigest()) continue;
                LOG.warning("Non-digest UsernameToken found, but digest required");
                throw new WSSecurityException(3);
            }
        }
        for (WSSecurityEngineResult o : CastUtils.cast(wsResult, WSSecurityEngineResult.class)) {
            Principal p = (Principal)o.get((Object)"principal");
            if (p == null) continue;
            msg.put(PRINCIPAL_RESULT, (Object)p);
            SecurityContext sc = msg.get(SecurityContext.class);
            if (sc != null && sc.getUserPrincipal() != null) continue;
            msg.put(SecurityContext.class, this.createSecurityContext(p));
            break;
        }
    }

    protected SecurityContext createSecurityContext(final Principal p) {
        return new SecurityContext(){

            public Principal getUserPrincipal() {
                return p;
            }

            public boolean isUserInRole(String role) {
                return false;
            }
        };
    }

    private String getAction(SoapMessage msg, SoapVersion version) {
        String action = (String)this.getOption("action");
        if (action == null) {
            action = (String)msg.get("action");
        }
        if (action == null) {
            LOG.warning("No security action was defined!");
            throw new SoapFault("No security action was defined!", version.getReceiver());
        }
        return action;
    }

    protected CallbackHandler getCallback(RequestData reqData, int doAction) throws WSSecurityException {
        TokenStore store;
        Endpoint ep;
        CallbackHandler cbHandler = null;
        if ((doAction & 5) != 0) {
            Object o = ((SoapMessage)reqData.getMsgContext()).getContextualProperty("ws-security.callback-handler");
            if (o instanceof String) {
                try {
                    o = ClassLoaderUtils.loadClass((String)o, this.getClass()).newInstance();
                }
                catch (Exception e) {
                    throw new WSSecurityException(e.getMessage(), (Throwable)e);
                }
            }
            if (o instanceof CallbackHandler) {
                cbHandler = (CallbackHandler)o;
            }
            if (cbHandler == null) {
                try {
                    cbHandler = this.getPasswordCB(reqData);
                }
                catch (WSSecurityException sec) {
                    TokenStore store2;
                    Endpoint ep2 = ((SoapMessage)reqData.getMsgContext()).getExchange().get(Endpoint.class);
                    if (ep2 != null && ep2.getEndpointInfo() != null && (store2 = (TokenStore)ep2.getEndpointInfo().getProperty(TokenStore.class.getName())) != null) {
                        return new TokenStoreCallbackHandler(cbHandler, store2);
                    }
                    throw sec;
                }
            }
        }
        if ((ep = ((SoapMessage)reqData.getMsgContext()).getExchange().get(Endpoint.class)) != null && ep.getEndpointInfo() != null && (store = (TokenStore)ep.getEndpointInfo().getProperty(TokenStore.class.getName())) != null) {
            return new TokenStoreCallbackHandler(cbHandler, store);
        }
        return cbHandler;
    }

    protected WSSecurityEngine getSecurityEngine() {
        if (this.secEngineOverride != null) {
            return this.secEngineOverride;
        }
        return secEngine;
    }

    protected static WSSecurityEngine createSecurityEngine(Map<QName, Object> map) {
        assert (map != null);
        WSSConfig config = WSSConfig.getNewInstance();
        for (Map.Entry<QName, Object> entry : map.entrySet()) {
            QName key = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof String) {
                String valStr = ((String)val).trim();
                if ("null".equals(valStr) || valStr.length() == 0) {
                    valStr = null;
                }
                config.setProcessor(key, valStr);
                continue;
            }
            if (val instanceof Processor) {
                config.setProcessor(key, (Processor)val);
                continue;
            }
            if (val != null) continue;
            config.setProcessor(key, (String)val);
        }
        WSSecurityEngine ret = new WSSecurityEngine();
        ret.setWssConfig(config);
        return ret;
    }

    private SoapFault createSoapFault(SoapVersion version, WSSecurityException e) {
        SoapFault fault;
        QName faultCode = e.getFaultCode();
        if (version.getVersion() == 1.1 && faultCode != null) {
            fault = new SoapFault(e.getMessage(), (Throwable)e, faultCode);
        } else {
            fault = new SoapFault(e.getMessage(), (Throwable)e, version.getSender());
            if (version.getVersion() != 1.1 && faultCode != null) {
                fault.setSubCode(faultCode);
            }
        }
        return fault;
    }

    private class TokenStoreCallbackHandler
    implements CallbackHandler {
        private CallbackHandler internal;
        private TokenStore store;

        public TokenStoreCallbackHandler(CallbackHandler in, TokenStore st) {
            this.internal = in;
            this.store = st;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                String id = pc.getIdentifier();
                if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(pc.getKeyType())) {
                    for (SecurityToken token : this.store.getValidTokens()) {
                        if (!id.equals(token.getSHA1())) continue;
                        pc.setKey(token.getSecret());
                        return;
                    }
                    continue;
                }
                SecurityToken tok = this.store.getToken(id);
                if (tok == null) continue;
                pc.setKey(tok.getSecret());
                pc.setCustomToken(tok.getToken());
                return;
            }
            if (this.internal != null) {
                this.internal.handle(callbacks);
            }
        }
    }
}

