/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.message;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.io.DelegatingInputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.StringMapImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.Destination;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
extends StringMapImpl
implements Message {
    private static final Class<?>[] DEFAULT_CONTENTS;
    private static final int DEFAULT_CONTENTS_LENGTH;
    private Exchange exchange;
    private String id;
    private InterceptorChain interceptorChain;
    private Object[] defaultContents = new Object[DEFAULT_CONTENTS_LENGTH];
    private Map<Class<?>, Object> contents;

    @Override
    public Collection<Attachment> getAttachments() {
        return CastUtils.cast((Collection)this.get(ATTACHMENTS));
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
        this.put(ATTACHMENTS, attachments);
    }

    public String getAttachmentMimeType() {
        return null;
    }

    @Override
    public Destination getDestination() {
        return this.get(Destination.class);
    }

    @Override
    public Exchange getExchange() {
        return this.exchange;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public InterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    @Override
    public <T> T getContent(Class<T> format) {
        for (int x = 0; x < DEFAULT_CONTENTS_LENGTH; ++x) {
            if (DEFAULT_CONTENTS[x] != format) continue;
            return (T)this.defaultContents[x];
        }
        return (T)(this.contents == null ? null : this.contents.get(format));
    }

    @Override
    public <T> void setContent(Class<T> format, Object content) {
        for (int x = 0; x < DEFAULT_CONTENTS_LENGTH; ++x) {
            if (DEFAULT_CONTENTS[x] != format) continue;
            this.defaultContents[x] = content;
            return;
        }
        if (this.contents == null) {
            this.contents = new IdentityHashMap(6);
        }
        this.contents.put(format, content);
    }

    @Override
    public <T> void removeContent(Class<T> format) {
        for (int x = 0; x < DEFAULT_CONTENTS_LENGTH; ++x) {
            if (DEFAULT_CONTENTS[x] != format) continue;
            this.defaultContents[x] = null;
            return;
        }
        if (this.contents != null) {
            this.contents.remove(format);
        }
    }

    @Override
    public Set<Class<?>> getContentFormats() {
        HashSet<Object> c = this.contents == null ? new HashSet() : new HashSet(this.contents.keySet());
        for (int x = 0; x < DEFAULT_CONTENTS_LENGTH; ++x) {
            if (this.defaultContents[x] == null) continue;
            c.add(DEFAULT_CONTENTS[x]);
        }
        return c;
    }

    public void setDestination(Destination d) {
        this.put(Destination.class, d);
    }

    @Override
    public void setExchange(Exchange e) {
        this.exchange = e;
    }

    @Override
    public void setId(String i) {
        this.id = i;
    }

    @Override
    public void setInterceptorChain(InterceptorChain ic) {
        this.interceptorChain = ic;
    }

    @Override
    public Object getContextualProperty(String key) {
        Object ep;
        Object val = this.get(key);
        Exchange ex = this.getExchange();
        if (val == null && ex != null) {
            val = ex.get(key);
        }
        if (val == null && (ep = this.get(OperationInfo.class)) != null) {
            val = ((AbstractPropertiesHolder)ep).getProperty(key);
        }
        if (val == null && ex != null) {
            ep = ex.get(Endpoint.class);
            if (ep != null) {
                val = ep.get(key);
                if (val == null) {
                    val = ep.getEndpointInfo().getProperty(key);
                }
                if (val == null) {
                    val = ep.getEndpointInfo().getBinding().getProperty(key);
                }
            }
            if (val == null) {
                Bus bus;
                Service sv = ex.get(Service.class);
                if (sv != null) {
                    val = sv.get(key);
                }
                if (val == null && (bus = ex.get(Bus.class)) != null) {
                    val = bus.getProperty(key);
                }
            }
        }
        return val;
    }

    public static void copyContent(Message m1, Message m2) {
        for (Class<?> c : m1.getContentFormats()) {
            m2.setContent(c, m1.getContent(c));
        }
    }

    static {
        Class[] tmps;
        try {
            Class<?> cls = Class.forName("javax.xml.soap.SOAPMessage");
            tmps = new Class[]{XMLStreamReader.class, XMLStreamWriter.class, InputStream.class, OutputStream.class, List.class, Exception.class, Node.class, DelegatingInputStream.class, cls};
        }
        catch (Throwable e) {
            tmps = new Class[]{XMLStreamReader.class, XMLStreamWriter.class, InputStream.class, OutputStream.class, List.class, Exception.class, Node.class, DelegatingInputStream.class};
        }
        DEFAULT_CONTENTS = tmps;
        DEFAULT_CONTENTS_LENGTH = tmps.length;
    }
}

