/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.namespace.QName;
import javax.xml.ws.Action;
import javax.xml.ws.Holder;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.Response;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebFault;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.JaxWsConfigurationException;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.factory.AbstractServiceConfiguration;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsServiceConfiguration
extends AbstractServiceConfiguration {
    private static final Logger LOG = LogUtils.getL7dLogger(JaxWsServiceConfiguration.class);
    private JaxWsImplementorInfo implInfo;
    private Map<Object, Class> responseMethodClassCache = new HashMap<Object, Class>();
    private Map<Object, Class> requestMethodClassCache = new HashMap<Object, Class>();
    private Map<Method, Annotation[][]> methodAnnotationCache = new HashMap<Method, Annotation[][]>();

    @Override
    public void setServiceFactory(ReflectionServiceFactoryBean serviceFactory) {
        super.setServiceFactory(serviceFactory);
        this.implInfo = ((JaxWsServiceFactoryBean)serviceFactory).getJaxWsImplementorInfo();
    }

    @Override
    public String getServiceName() {
        QName service = this.implInfo.getServiceName();
        if (service == null) {
            return null;
        }
        return service.getLocalPart();
    }

    @Override
    public String getServiceNamespace() {
        String ret = super.getServiceNamespace();
        if (ret != null) {
            return ret;
        }
        QName service = this.implInfo.getServiceName();
        if (service == null) {
            return null;
        }
        return service.getNamespaceURI();
    }

    @Override
    public QName getEndpointName() {
        return this.implInfo.getEndpointName();
    }

    @Override
    public QName getInterfaceName() {
        return this.implInfo.getInterfaceName();
    }

    @Override
    public String getWsdlURL() {
        String wsdlLocation = this.implInfo.getWsdlLocation();
        if (wsdlLocation != null && wsdlLocation.length() > 0) {
            return wsdlLocation;
        }
        return null;
    }

    @Override
    public QName getOperationName(InterfaceInfo intf, Method method) {
        WebMethod wm = (method = this.getDeclaredMethod(method)).getAnnotation(WebMethod.class);
        if (wm != null) {
            String name = wm.operationName();
            if (name.length() == 0) {
                name = method.getName();
            }
            return new QName(intf.getName().getNamespaceURI(), name);
        }
        return new QName(intf.getName().getNamespaceURI(), method.getName());
    }

    public Boolean isWebMethod(Method method) {
        if (method == null || method.getReturnType().equals(Future.class) || method.getReturnType().equals(Response.class) || method.isSynthetic()) {
            return Boolean.FALSE;
        }
        WebMethod wm = method.getAnnotation(WebMethod.class);
        if (wm != null) {
            if (wm.exclude()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (method.getDeclaringClass().isInterface()) {
            return this.hasWebServiceAnnotation(method);
        }
        if (this.implInfo.getSEIClass() == null) {
            return this.hasWebServiceAnnotation(method) && !Modifier.isFinal(method.getModifiers()) && !Modifier.isStatic(method.getModifiers());
        }
        return this.implInfo.getSEIClass().isAssignableFrom(method.getDeclaringClass());
    }

    @Override
    public Boolean isOperation(Method method) {
        if (Object.class.equals(method.getDeclaringClass())) {
            return false;
        }
        Class<?> implClz = this.implInfo.getImplementorClass();
        if (this.isWebMethod(this.getDeclaredMethod(implClz, method)).booleanValue()) {
            return true;
        }
        return this.isWebMethod(this.getDeclaredMethod(method));
    }

    private boolean hasWebServiceAnnotation(Method method) {
        return method.getDeclaringClass().getAnnotation(WebService.class) != null;
    }

    Method getDeclaredMethod(Method method) {
        return this.getDeclaredMethod(this.implInfo.getEndpointClass(), method);
    }

    private Method getDeclaredMethod(Class<?> endpointClass, Method method) {
        if (!method.getDeclaringClass().equals(endpointClass)) {
            try {
                method = endpointClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (SecurityException e) {
                throw new ServiceConstructionException(e);
            }
            catch (NoSuchMethodException e) {
                return this.isWebMethod(method) != false ? method : null;
            }
        }
        return method;
    }

    @Override
    public QName getInPartName(OperationInfo op, Method method, int paramNumber) {
        if (paramNumber < 0) {
            return null;
        }
        return this.getPartName(op, method, paramNumber, op.getInput(), "arg", true);
    }

    @Override
    public QName getInParameterName(OperationInfo op, Method method, int paramNumber) {
        if (paramNumber < 0) {
            return null;
        }
        return this.getParameterName(op, method, paramNumber, op.getInput().size(), "arg", true);
    }

    private QName getPartName(OperationInfo op, Method method, int paramNumber, MessageInfo mi, String prefix, boolean isIn) {
        int partIndex = this.getPartIndex(method, paramNumber, isIn);
        method = this.getDeclaredMethod(method);
        WebParam param = this.getWebParam(method, paramNumber);
        String tns = mi.getName().getNamespaceURI();
        String local = null;
        if (param != null) {
            if (Boolean.TRUE.equals(this.isRPC(method)) || this.isDocumentBare(method) || param.header()) {
                local = param.partName();
            }
            if (local == null || local.length() == 0) {
                local = param.name();
            }
        }
        if (local == null || local.length() == 0) {
            local = Boolean.TRUE.equals(this.isRPC(method)) || !Boolean.FALSE.equals(this.isWrapped(method)) ? this.getDefaultLocalName(op, method, paramNumber, partIndex, prefix) : this.getOperationName(op.getInterface(), method).getLocalPart();
        }
        return new QName(tns, local);
    }

    private int getPartIndex(Method method, int paraNumber, boolean isIn) {
        int i;
        int ret = 0;
        if (isIn && this.isInParam(method, paraNumber).booleanValue()) {
            for (i = 0; i < paraNumber; ++i) {
                if (!this.isInParam(method, i).booleanValue()) continue;
                ++ret;
            }
        }
        if (!isIn && this.isOutParam(method, paraNumber).booleanValue()) {
            if (!method.getReturnType().equals(Void.class)) {
                ++ret;
            }
            for (i = 0; i < paraNumber; ++i) {
                if (!this.isOutParam(method, i).booleanValue()) continue;
                ++ret;
            }
        }
        return ret;
    }

    private QName getParameterName(OperationInfo op, Method method, int paramNumber, int curSize, String prefix, boolean input) {
        int partIndex = this.getPartIndex(method, paramNumber, input);
        method = this.getDeclaredMethod(method);
        WebParam param = this.getWebParam(method, paramNumber);
        String tns = null;
        String local = null;
        if (param != null) {
            tns = param.targetNamespace();
            local = param.name();
        }
        if (tns == null || tns.length() == 0) {
            QName wrappername = null;
            wrappername = input ? this.getRequestWrapperName(op, method) : this.getResponseWrapperName(op, method);
            if (wrappername != null) {
                tns = wrappername.getNamespaceURI();
            }
        }
        if (tns == null || tns.length() == 0) {
            tns = op.getName().getNamespaceURI();
        }
        if (local == null || local.length() == 0) {
            if (Boolean.TRUE.equals(this.isRPC(method)) || !Boolean.FALSE.equals(this.isWrapped(method))) {
                local = this.getDefaultLocalName(op, method, paramNumber, partIndex, prefix);
            } else {
                local = this.getOperationName(op.getInterface(), method).getLocalPart();
                if (!input) {
                    local = local + "Response";
                }
            }
        }
        return new QName(tns, local);
    }

    private String getDefaultLocalName(OperationInfo op, Method method, int paramNumber, int partIndex, String prefix) {
        String paramName = null;
        paramName = paramNumber != -1 ? prefix + partIndex : prefix;
        return paramName;
    }

    private WebParam getWebParam(Method method, int parameter) {
        Annotation[][] annotations = this.methodAnnotationCache.get(method);
        if (annotations == null) {
            annotations = method.getParameterAnnotations();
            this.methodAnnotationCache.put(method, annotations);
        }
        if (parameter >= annotations.length) {
            return null;
        }
        for (int i = 0; i < annotations[parameter].length; ++i) {
            Annotation annotation = annotations[parameter][i];
            if (!(annotation instanceof WebParam)) continue;
            return (WebParam)annotation;
        }
        return null;
    }

    @Override
    public String getRequestWrapperPartName(OperationInfo op, Method method) {
        RequestWrapper rw = (method = this.getDeclaredMethod(method)).getAnnotation(RequestWrapper.class);
        if (rw != null) {
            return this.getWithReflection(RequestWrapper.class, rw, "partName");
        }
        return null;
    }

    @Override
    public String getResponseWrapperPartName(OperationInfo op, Method method) {
        String pn;
        method = this.getDeclaredMethod(method);
        WebResult webResult = this.getWebResult(method);
        ResponseWrapper rw = method.getAnnotation(ResponseWrapper.class);
        if (rw != null && (pn = this.getWithReflection(ResponseWrapper.class, rw, "partName")) != null) {
            return pn;
        }
        int countOut = 0;
        int countHeaders = 0;
        if (webResult != null && webResult.header()) {
            ++countHeaders;
        } else if (method.getReturnType() != Void.TYPE) {
            ++countOut;
        }
        for (int x = 0; x < method.getParameterTypes().length; ++x) {
            WebParam parm = this.getWebParam(method, x);
            if (parm == null) continue;
            if (parm.header()) {
                ++countHeaders;
            }
            if (parm.mode() == WebParam.Mode.IN) continue;
            ++countOut;
        }
        if (countHeaders > 0 && countOut == 0) {
            return "result";
        }
        return null;
    }

    @Override
    public String getFaultMessageName(OperationInfo op, Class<?> exClass, Class<?> beanClass) {
        WebFault f = exClass.getAnnotation(WebFault.class);
        if (f != null) {
            return this.getWithReflection(WebFault.class, f, "messageName");
        }
        return null;
    }

    private <T> String getWithReflection(Class<T> cls, T obj, String name) {
        try {
            String s = cls.getMethod(name, new Class[0]).invoke(obj, new Object[0]).toString();
            if (!StringUtils.isEmpty(s)) {
                return s;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    @Override
    public QName getOutParameterName(OperationInfo op, Method method, int paramNumber) {
        QName wrappername;
        method = this.getDeclaredMethod(method);
        if (paramNumber >= 0) {
            return this.getParameterName(op, method, paramNumber, op.getOutput().size(), "return", false);
        }
        WebResult webResult = this.getWebResult(method);
        String tns = null;
        String local = null;
        if (webResult != null) {
            tns = webResult.targetNamespace();
            local = webResult.name();
        }
        if ((tns == null || tns.length() == 0) && (wrappername = this.getResponseWrapperName(op, method)) != null) {
            tns = wrappername.getNamespaceURI();
        }
        if (tns == null || tns.length() == 0) {
            tns = op.getName().getNamespaceURI();
        }
        if (local == null || local.length() == 0) {
            local = Boolean.TRUE.equals(this.isRPC(method)) || !Boolean.FALSE.equals(this.isWrapped(method)) ? this.getDefaultLocalName(op, method, paramNumber, op.getOutput().size(), "return") : this.getOperationName(op.getInterface(), method).getLocalPart() + "Response";
        }
        return new QName(tns, local);
    }

    @Override
    public QName getOutPartName(OperationInfo op, Method method, int paramNumber) {
        method = this.getDeclaredMethod(method);
        if (paramNumber >= 0) {
            return this.getPartName(op, method, paramNumber, op.getOutput(), "return", false);
        }
        WebResult webResult = this.getWebResult(method);
        String tns = op.getOutput().getName().getNamespaceURI();
        String local = null;
        if (webResult != null) {
            if (Boolean.TRUE.equals(this.isRPC(method)) || this.isDocumentBare(method)) {
                local = webResult.partName();
            }
            if (local == null || local.length() == 0) {
                local = webResult.name();
            }
        }
        if (local == null || local.length() == 0) {
            local = Boolean.TRUE.equals(this.isRPC(method)) || !Boolean.FALSE.equals(this.isWrapped(method)) ? "return" : this.getOperationName(op.getInterface(), method).getLocalPart() + "Response";
        }
        return new QName(tns, local);
    }

    @Override
    public Boolean isInParam(Method method, int j) {
        if (j < 0) {
            return Boolean.FALSE;
        }
        WebParam webParam = this.getWebParam(method = this.getDeclaredMethod(method), j);
        return webParam == null || webParam.mode().equals((Object)WebParam.Mode.IN) || webParam.mode().equals((Object)WebParam.Mode.INOUT);
    }

    private WebResult getWebResult(Method method) {
        return method.getAnnotation(WebResult.class);
    }

    @Override
    public Boolean isOutParam(Method method, int j) {
        method = this.getDeclaredMethod(method);
        if (j == -1) {
            return !method.getReturnType().equals(Void.TYPE);
        }
        WebParam webParam = this.getWebParam(method, j);
        if (webParam != null && (webParam.mode().equals((Object)WebParam.Mode.OUT) || webParam.mode().equals((Object)WebParam.Mode.INOUT))) {
            return Boolean.TRUE;
        }
        return method.getParameterTypes()[j] == Holder.class;
    }

    @Override
    public QName getRequestWrapperName(OperationInfo op, Method method) {
        WebMethod meth;
        Method m = this.getDeclaredMethod(method);
        RequestWrapper rw = m.getAnnotation(RequestWrapper.class);
        String nm = null;
        String lp = null;
        if (rw != null) {
            nm = rw.targetNamespace();
            lp = rw.localName();
        }
        if ((meth = m.getAnnotation(WebMethod.class)) != null && StringUtils.isEmpty(lp)) {
            lp = meth.operationName();
        }
        if (StringUtils.isEmpty(nm)) {
            nm = op.getName().getNamespaceURI();
        }
        if (!StringUtils.isEmpty(nm) && !StringUtils.isEmpty(lp)) {
            return new QName(nm, lp);
        }
        return null;
    }

    @Override
    public QName getResponseWrapperName(OperationInfo op, Method method) {
        WebMethod meth;
        Method m = this.getDeclaredMethod(method);
        ResponseWrapper rw = m.getAnnotation(ResponseWrapper.class);
        String nm = null;
        String lp = null;
        if (rw != null) {
            nm = rw.targetNamespace();
            lp = rw.localName();
        }
        if ((meth = m.getAnnotation(WebMethod.class)) != null && StringUtils.isEmpty(lp) && !StringUtils.isEmpty(lp = meth.operationName())) {
            lp = lp + "Response";
        }
        if (StringUtils.isEmpty(nm)) {
            nm = op.getName().getNamespaceURI();
        }
        if (!StringUtils.isEmpty(nm) && !StringUtils.isEmpty(lp)) {
            return new QName(nm, lp);
        }
        return null;
    }

    @Override
    public Class getResponseWrapper(Method selected) {
        Class cachedClass = this.responseMethodClassCache.get(selected);
        if (cachedClass != null) {
            return cachedClass;
        }
        Method m = this.getDeclaredMethod(selected);
        ResponseWrapper rw = m.getAnnotation(ResponseWrapper.class);
        String clsName = "";
        clsName = rw == null ? JaxWsServiceConfiguration.getPackageName(selected) + ".jaxws." + StringUtils.capitalize(selected.getName()) + "Response" : rw.className();
        if (clsName.length() > 0) {
            cachedClass = this.responseMethodClassCache.get(clsName);
            if (cachedClass != null) {
                this.responseMethodClassCache.put(selected, cachedClass);
                return cachedClass;
            }
            try {
                Class<?> r = ClassLoaderUtils.loadClass(clsName, this.implInfo.getEndpointClass());
                this.responseMethodClassCache.put(clsName, r);
                this.responseMethodClassCache.put(selected, r);
                if (r.equals(m.getReturnType())) {
                    LOG.log(Level.WARNING, "INVALID_RESPONSE_WRAPPER", new Object[]{clsName, m.getReturnType().getName()});
                }
                return r;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getResponseWrapperClassName(Method selected) {
        Method m = this.getDeclaredMethod(selected);
        ResponseWrapper rw = m.getAnnotation(ResponseWrapper.class);
        String clsName = "";
        if (rw != null) {
            clsName = rw.className();
        }
        if (clsName.length() > 0) {
            return clsName;
        }
        return null;
    }

    @Override
    public String getRequestWrapperClassName(Method selected) {
        Method m = this.getDeclaredMethod(selected);
        RequestWrapper rw = m.getAnnotation(RequestWrapper.class);
        String clsName = "";
        if (rw != null) {
            clsName = rw.className();
        }
        if (clsName.length() > 0) {
            return clsName;
        }
        return null;
    }

    @Override
    public Class getRequestWrapper(Method selected) {
        Class cachedClass = this.requestMethodClassCache.get(selected);
        if (cachedClass != null) {
            return cachedClass;
        }
        Method m = this.getDeclaredMethod(selected);
        RequestWrapper rw = m.getAnnotation(RequestWrapper.class);
        String clsName = "";
        clsName = rw == null ? JaxWsServiceConfiguration.getPackageName(selected) + ".jaxws." + StringUtils.capitalize(selected.getName()) : rw.className();
        if (clsName.length() > 0) {
            cachedClass = this.requestMethodClassCache.get(clsName);
            if (cachedClass != null) {
                this.requestMethodClassCache.put(selected, cachedClass);
                return cachedClass;
            }
            try {
                Class<?> r = ClassLoaderUtils.loadClass(clsName, this.implInfo.getEndpointClass());
                this.requestMethodClassCache.put(clsName, r);
                this.requestMethodClassCache.put(selected, r);
                if (m.getParameterTypes().length == 1 && r.equals(m.getParameterTypes()[0])) {
                    LOG.log(Level.WARNING, "INVALID_REQUEST_WRAPPER", new Object[]{clsName, m.getParameterTypes()[0].getName()});
                }
                return r;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return null;
    }

    private static String getPackageName(Method method) {
        return PackageUtils.getPackageName(method.getDeclaringClass());
    }

    @Override
    public QName getFaultName(InterfaceInfo service, OperationInfo o, Class<?> exClass, Class<?> beanClass) {
        WebFault fault = exClass.getAnnotation(WebFault.class);
        if (fault != null) {
            String ns;
            String name = fault.name();
            if (name.length() == 0) {
                name = exClass.getSimpleName();
            }
            if ((ns = fault.targetNamespace()).length() == 0) {
                ns = service.getName().getNamespaceURI();
            }
            return new QName(ns, name);
        }
        return null;
    }

    @Override
    public Boolean isWrapped(Method m) {
        if (this.getServiceFactory().getWrapped() != null) {
            return this.getServiceFactory().getWrapped();
        }
        SOAPBinding ann = (m = this.getDeclaredMethod(m)).getAnnotation(SOAPBinding.class);
        if (ann != null) {
            if (ann.style().equals((Object)SOAPBinding.Style.RPC)) {
                Message message = new Message("SOAPBinding_MESSAGE_RPC", LOG, m.getName());
                throw new Fault(new JaxWsConfigurationException(message));
            }
            return !ann.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.BARE);
        }
        return this.isWrapped();
    }

    @Override
    public Boolean isWrapped() {
        SOAPBinding ann = this.implInfo.getEndpointClass().getAnnotation(SOAPBinding.class);
        if (ann != null) {
            return !ann.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.BARE) && !ann.style().equals((Object)SOAPBinding.Style.RPC);
        }
        return null;
    }

    @Override
    public Boolean isHeader(Method method, int j) {
        method = this.getDeclaredMethod(method);
        if (j >= 0) {
            WebParam webParam = this.getWebParam(method, j);
            return webParam != null && webParam.header();
        }
        WebResult webResult = this.getWebResult(method);
        return webResult != null && webResult.header();
    }

    @Override
    public String getStyle() {
        SOAPBinding ann = this.implInfo.getEndpointClass().getAnnotation(SOAPBinding.class);
        if (ann != null) {
            return ann.style().toString().toLowerCase();
        }
        return super.getStyle();
    }

    private boolean isDocumentBare(Method method) {
        SOAPBinding ann = method.getAnnotation(SOAPBinding.class);
        if (ann != null) {
            return ann.style().equals((Object)SOAPBinding.Style.DOCUMENT) && ann.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.BARE);
        }
        ann = this.implInfo.getEndpointClass().getAnnotation(SOAPBinding.class);
        if (ann != null) {
            return ann.style().equals((Object)SOAPBinding.Style.DOCUMENT) && ann.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.BARE);
        }
        return false;
    }

    @Override
    public Boolean isRPC(Method method) {
        SOAPBinding ann = method.getAnnotation(SOAPBinding.class);
        if (ann != null) {
            return ann.style().equals((Object)SOAPBinding.Style.RPC);
        }
        ann = this.implInfo.getEndpointClass().getAnnotation(SOAPBinding.class);
        if (ann != null) {
            return ann.style().equals((Object)SOAPBinding.Style.RPC);
        }
        return super.isRPC(method);
    }

    @Override
    public Boolean hasOutMessage(Method method) {
        return !(method = this.getDeclaredMethod(method)).isAnnotationPresent(Oneway.class);
    }

    @Override
    public String getAction(OperationInfo op, Method method) {
        Action act;
        method = this.getDeclaredMethod(method);
        WebMethod wm = method.getAnnotation(WebMethod.class);
        String action = "";
        if (wm != null) {
            action = wm.action();
        }
        if (StringUtils.isEmpty(action) && (act = method.getAnnotation(Action.class)) != null) {
            action = act.input();
        }
        return action;
    }

    @Override
    public Boolean isHolder(Class<?> cls, Type type) {
        return Holder.class.equals(cls);
    }

    @Override
    public Type getHolderType(Class<?> cls, Type type) {
        if (cls.equals(Holder.class) && type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            return paramType.getActualTypeArguments()[0];
        }
        return cls;
    }

    @Override
    public Boolean isWrapperPartQualified(MessagePartInfo mpi) {
        Annotation[] annotations = (Annotation[])mpi.getProperty("parameter.annotations");
        if (annotations != null) {
            for (Annotation an : annotations) {
                String tns = null;
                if (an instanceof WebParam) {
                    tns = ((WebParam)an).targetNamespace();
                } else if (an instanceof WebResult) {
                    tns = ((WebResult)an).targetNamespace();
                }
                if (tns == null || StringUtils.isEmpty(tns)) continue;
                return Boolean.TRUE;
            }
        }
        return null;
    }

    @Override
    public Long getWrapperPartMinOccurs(MessagePartInfo mpi) {
        Annotation[] a = (Annotation[])mpi.getProperty("parameter.annotations");
        if (a != null) {
            for (Annotation a2 : a) {
                XmlElement e;
                if (!(a2 instanceof XmlElement) || !(e = (XmlElement)a2).required()) continue;
                return 1L;
            }
        }
        return null;
    }
}

