/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.InvocationHandlerAware;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.ThreadLocalClientState;
import org.apache.cxf.jaxrs.ext.form.Form;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebClient
extends AbstractClient {
    protected WebClient(String baseAddress) {
        this(URI.create(baseAddress));
    }

    protected WebClient(URI baseAddress) {
        super(baseAddress);
    }

    protected WebClient(ClientState state) {
        super(state);
    }

    public static WebClient create(String baseAddress) {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setAddress(baseAddress);
        return bean.createWebClient();
    }

    public static WebClient create(URI baseURI) {
        return WebClient.create(baseURI.toString());
    }

    public static WebClient create(String baseURI, boolean threadSafe) {
        return WebClient.create(baseURI, Collections.emptyList(), threadSafe);
    }

    public static WebClient create(String baseAddress, List<?> providers) {
        return WebClient.create(baseAddress, providers, null);
    }

    public static WebClient create(String baseAddress, List<?> providers, boolean threadSafe) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, null);
        bean.setProviders(providers);
        if (threadSafe) {
            bean.setInitialState(new ThreadLocalClientState(baseAddress));
        }
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, List<?> providers, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setProviders(providers);
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, String username, String password, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setUsername(username);
        bean.setPassword(password);
        return bean.createWebClient();
    }

    public static WebClient fromClient(Client client) {
        return WebClient.fromClient(client, false);
    }

    public static WebClient fromClient(Client client, boolean inheritHeaders) {
        WebClient webClient = null;
        ClientState clientState = WebClient.getClientState(client);
        if (clientState == null) {
            webClient = WebClient.create(client.getCurrentURI());
            if (inheritHeaders) {
                webClient.headers((MultivaluedMap)client.getHeaders());
            }
        } else {
            MultivaluedMap<String, String> headers = inheritHeaders ? client.getHeaders() : null;
            webClient = new WebClient(clientState.newState(client.getCurrentURI(), headers, null));
        }
        WebClient.copyProperties(webClient, client);
        return webClient;
    }

    public static Client client(Object proxy) {
        if (proxy instanceof Client) {
            return (Client)proxy;
        }
        return null;
    }

    public static ClientConfiguration getConfig(Object client) {
        if (client instanceof Client) {
            if (client instanceof WebClient) {
                return ((AbstractClient)client).getConfiguration();
            }
            if (client instanceof InvocationHandlerAware) {
                Object handler = ((InvocationHandlerAware)client).getInvocationHandler();
                return ((AbstractClient)handler).getConfiguration();
            }
        }
        throw new IllegalArgumentException("Not a valid Client");
    }

    public Response invoke(String httpMethod, Object body) {
        return this.doInvoke(httpMethod, body, InputStream.class, (Type)((Object)InputStream.class));
    }

    public Response post(Object body) {
        return this.invoke("POST", body);
    }

    public Response put(Object body) {
        return this.invoke("PUT", body);
    }

    public Response get() {
        return this.invoke("GET", null);
    }

    public Response head() {
        return this.invoke("HEAD", null);
    }

    public Response options() {
        return this.invoke("OPTIONS", null);
    }

    public Response delete() {
        return this.invoke("DELETE", null);
    }

    public Response form(Map<String, List<Object>> values) {
        this.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        return this.doInvoke("POST", values, InputStream.class, (Type)((Object)InputStream.class));
    }

    public Response form(Form form) {
        this.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        return this.doInvoke("POST", form.getData(), InputStream.class, (Type)((Object)InputStream.class));
    }

    public <T> T invoke(String httpMethod, Object body, Class<T> responseClass) {
        Response r = this.doInvoke(httpMethod, body, responseClass, responseClass);
        if (r.getStatus() >= 400 && responseClass != null) {
            throw new WebApplicationException(r);
        }
        return responseClass.cast(r.getEntity());
    }

    public <T> Collection<? extends T> invokeAndGetCollection(String httpMethod, Object body, Class<T> memberClass) {
        Response r = this.doInvoke(httpMethod, body, Collection.class, memberClass);
        if (r.getStatus() >= 400) {
            throw new WebApplicationException(r);
        }
        return CastUtils.cast((Collection)r.getEntity(), memberClass);
    }

    public <T> T post(Object body, Class<T> responseClass) {
        return this.invoke("POST", body, responseClass);
    }

    public <T> Collection<? extends T> postAndGetCollection(Object body, Class<T> memberClass) {
        return this.invokeAndGetCollection("POST", body, memberClass);
    }

    public <T> Collection<? extends T> getCollection(Class<T> memberClass) {
        return this.invokeAndGetCollection("GET", null, memberClass);
    }

    public <T> T get(Class<T> responseClass) {
        return this.invoke("GET", null, responseClass);
    }

    public WebClient path(Object path) {
        this.getCurrentBuilder().path(path.toString());
        return this;
    }

    public WebClient path(String path, Object ... values) {
        URI u = UriBuilder.fromUri((URI)URI.create("http://tempuri")).path(path).buildFromEncoded(values);
        this.getState().setTemplates(this.getTemplateParametersMap(new URITemplate(path), Arrays.asList(values)));
        return this.path(u.getRawPath());
    }

    public WebClient query(String name, Object ... values) {
        if (!"".equals(name)) {
            this.getCurrentBuilder().queryParam(name, values);
        } else {
            WebClient.addParametersToBuilder(this.getCurrentBuilder(), name, values[0], ParameterType.QUERY);
        }
        return this;
    }

    public WebClient matrix(String name, Object ... values) {
        if (!"".equals(name)) {
            this.getCurrentBuilder().matrixParam(name, values);
        } else {
            WebClient.addParametersToBuilder(this.getCurrentBuilder(), name, values[0], ParameterType.MATRIX);
        }
        return this;
    }

    public WebClient fragment(String name) {
        this.getCurrentBuilder().fragment(name);
        return this;
    }

    public WebClient to(String newAddress, boolean forward) {
        this.getState().setTemplates(null);
        if (forward) {
            if (!newAddress.startsWith(this.getBaseURI().toString())) {
                throw new IllegalArgumentException("Base address can not be preserved");
            }
            this.resetCurrentBuilder(URI.create(newAddress));
        } else {
            this.resetBaseAddress(URI.create(newAddress));
        }
        return this;
    }

    public WebClient back(boolean fast) {
        this.getState().setTemplates(null);
        if (fast) {
            this.getCurrentBuilder().replacePath(this.getBaseURI().getPath());
        } else {
            URI uri = this.getCurrentURI();
            if (uri == this.getBaseURI()) {
                return this;
            }
            List<PathSegment> segments = JAXRSUtils.getPathSegments(uri.getPath(), false);
            this.getCurrentBuilder().replacePath(null);
            for (int i = 0; i < segments.size() - 1; ++i) {
                this.getCurrentBuilder().path(HttpUtils.fromPathSegment(segments.get(i)));
            }
        }
        return this;
    }

    public WebClient resetQuery() {
        this.getCurrentBuilder().replaceQuery(null);
        return this;
    }

    @Override
    public WebClient type(MediaType ct) {
        return (WebClient)super.type(ct);
    }

    @Override
    public WebClient type(String type) {
        return (WebClient)super.type(type);
    }

    @Override
    public WebClient accept(MediaType ... types) {
        return (WebClient)super.accept(types);
    }

    @Override
    public WebClient accept(String ... types) {
        return (WebClient)super.accept(types);
    }

    @Override
    public WebClient language(String language) {
        return (WebClient)super.language(language);
    }

    @Override
    public WebClient acceptLanguage(String ... languages) {
        return (WebClient)super.acceptLanguage(languages);
    }

    @Override
    public WebClient encoding(String encoding) {
        return (WebClient)super.encoding(encoding);
    }

    @Override
    public WebClient acceptEncoding(String ... encodings) {
        return (WebClient)super.acceptEncoding(encodings);
    }

    @Override
    public WebClient match(EntityTag tag, boolean ifNot) {
        return (WebClient)super.match(tag, ifNot);
    }

    @Override
    public WebClient modified(Date date, boolean ifNot) {
        return (WebClient)super.modified(date, ifNot);
    }

    @Override
    public WebClient cookie(Cookie cookie) {
        return (WebClient)super.cookie(cookie);
    }

    @Override
    public WebClient header(String name, Object ... values) {
        return (WebClient)super.header(name, values);
    }

    @Override
    public WebClient headers(MultivaluedMap<String, String> map) {
        return (WebClient)super.headers(map);
    }

    @Override
    public WebClient reset() {
        return (WebClient)super.reset();
    }

    protected Response doInvoke(String httpMethod, Object body, Class<?> responseClass, Type genericType) {
        MultivaluedMap<String, String> headers = this.getHeaders();
        if (body != null) {
            if (headers.getFirst((Object)"Content-Type") == null) {
                headers.putSingle((Object)"Content-Type", (Object)MediaType.APPLICATION_XML_TYPE.toString());
            }
        } else {
            headers.putSingle((Object)"Content-Type", (Object)"*/*");
        }
        if (responseClass != null && headers.getFirst((Object)"Accept") == null) {
            headers.putSingle((Object)"Accept", (Object)MediaType.APPLICATION_XML_TYPE.toString());
        }
        this.resetResponse();
        return this.doChainedInvocation(httpMethod, headers, body, responseClass, genericType);
    }

    protected Response doChainedInvocation(String httpMethod, MultivaluedMap<String, String> headers, Object body, Class<?> responseClass, Type genericType) {
        Throwable primaryError = null;
        URI uri = this.getCurrentURI();
        Message m = this.createMessage(httpMethod, headers, uri);
        m.put("jaxrs.template.parameters", this.getState().getTemplates());
        if (body != null) {
            MessageContentsList contents = new MessageContentsList(body);
            m.setContent(List.class, contents);
            m.getInterceptorChain().add(new BodyWriter());
        } else {
            this.setEmptyRequestProperty(m, httpMethod);
        }
        this.setPlainOperationNameProperty(m, httpMethod + ":" + uri.toString());
        try {
            m.getInterceptorChain().doIntercept(m);
            primaryError = m.getExchange().get(Exception.class);
        }
        catch (Throwable ex) {
            primaryError = ex;
        }
        HttpURLConnection connect = (HttpURLConnection)m.get("http.connection");
        if (connect == null && primaryError != null) {
            throw new WebApplicationException(primaryError);
        }
        return this.handleResponse(connect, m, responseClass, genericType);
    }

    protected Response handleResponse(HttpURLConnection conn, Message outMessage, Class<?> responseClass, Type genericType) {
        try {
            Response.ResponseBuilder rb = this.setResponseBuilder(conn, outMessage.getExchange());
            Response currentResponse = rb.clone().build();
            Object entity = this.readBody(currentResponse, conn, outMessage, responseClass, genericType, new Annotation[0]);
            rb.entity(entity);
            return rb.build();
        }
        catch (Throwable ex) {
            throw new WebApplicationException(ex);
        }
    }

    protected HttpURLConnection getConnection(String methodName) {
        return WebClient.createHttpConnection(this.getCurrentBuilder().clone().buildFromEncoded(new Object[0]), methodName);
    }

    static void copyProperties(Client toClient, Client fromClient) {
        AbstractClient newClient = WebClient.toAbstractClient(toClient);
        AbstractClient oldClient = WebClient.toAbstractClient(fromClient);
        newClient.setConfiguration(oldClient.getConfiguration());
    }

    private static AbstractClient toAbstractClient(Client client) {
        if (client instanceof AbstractClient) {
            return (AbstractClient)client;
        }
        return (AbstractClient)((InvocationHandlerAware)((Object)client)).getInvocationHandler();
    }

    static JAXRSClientFactoryBean getBean(String baseAddress, String configLocation) {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        if (configLocation != null) {
            SpringBusFactory bf = new SpringBusFactory();
            Bus bus = bf.createBus(configLocation);
            bean.setBus(bus);
        }
        bean.setAddress(baseAddress);
        return bean;
    }

    static ClientState getClientState(Client client) {
        ClientState clientState = null;
        if (client instanceof WebClient) {
            clientState = ((AbstractClient)client).getState();
        } else if (client instanceof InvocationHandlerAware) {
            Object handler = ((InvocationHandlerAware)((Object)client)).getInvocationHandler();
            clientState = ((AbstractClient)handler).getState();
        }
        return clientState;
    }

    private class BodyWriter
    extends AbstractOutDatabindingInterceptor {
        public BodyWriter() {
            super("write");
        }

        public void handleMessage(Message outMessage) throws Fault {
            OutputStream os = outMessage.getContent(OutputStream.class);
            XMLStreamWriter writer = outMessage.getContent(XMLStreamWriter.class);
            if (os == null && writer == null) {
                return;
            }
            MessageContentsList objs = MessageContentsList.getContentsList(outMessage);
            if (objs == null || objs.size() == 0) {
                return;
            }
            MultivaluedMap headers = (MultivaluedMap)outMessage.get(Message.PROTOCOL_HEADERS);
            Object body = objs.get(0);
            try {
                WebClient.this.writeBody(body, outMessage, body.getClass(), body.getClass(), new Annotation[0], (MultivaluedMap<String, String>)headers, os);
                if (os != null) {
                    os.flush();
                }
            }
            catch (Exception ex) {
                throw new Fault(ex);
            }
        }
    }
}

