/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.transport.http_jetty.JettyHTTPDestination;
import org.mortbay.jetty.handler.AbstractHandler;

public class JettyHTTPHandler
extends AbstractHandler {
    private String urlName;
    private boolean contextMatchExact;
    private JettyHTTPDestination jettyHTTPDestination;
    private ServletContext servletContext;

    public JettyHTTPHandler(JettyHTTPDestination jhd, boolean cmExact) {
        this.contextMatchExact = cmExact;
        this.jettyHTTPDestination = jhd;
    }

    public void setServletContext(ServletContext sc) {
        this.servletContext = sc;
        if (this.jettyHTTPDestination != null) {
            this.jettyHTTPDestination.setServletContext(sc);
        }
    }

    public void setName(String name) {
        this.urlName = name;
    }

    public String getName() {
        return this.urlName;
    }

    boolean checkContextPath(String target) {
        String pathString = this.urlName;
        if (!pathString.endsWith("/")) {
            pathString = pathString + "/";
        }
        return target.startsWith(pathString);
    }

    public void handle(String target, HttpServletRequest req, HttpServletResponse resp, int dispatch) throws IOException {
        if (this.contextMatchExact) {
            if (target.equals(this.urlName)) {
                this.jettyHTTPDestination.doService(this.servletContext, req, resp);
            }
        } else if (target.equals(this.urlName) || this.checkContextPath(target)) {
            this.jettyHTTPDestination.doService(this.servletContext, req, resp);
        }
    }
}

