/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StreamWriterContentHandler;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public final class StaxUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(StaxUtils.class);
    private static final XMLInputFactory XML_NS_AWARE_INPUT_FACTORY = XMLInputFactory.newInstance();
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final String XML_NS = "http://www.w3.org/2000/xmlns/";

    private StaxUtils() {
    }

    public static boolean isWoodstox() {
        try {
            ClassLoaderUtils.loadClass("org.codehaus.stax2.XMLStreamReader2", StaxUtils.class);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static XMLInputFactory getXMLInputFactory() {
        return StaxUtils.getXMLInputFactory(true);
    }

    public static XMLInputFactory getXMLInputFactory(boolean nsAware) {
        return nsAware ? XML_NS_AWARE_INPUT_FACTORY : XML_INPUT_FACTORY;
    }

    public static XMLInputFactory createXMLInputFactory(boolean nsAware) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isNamespaceAware", nsAware);
        return factory;
    }

    public static XMLOutputFactory getXMLOutputFactory() {
        return XML_OUTPUT_FACTORY;
    }

    public static XMLStreamWriter createXMLStreamWriter(Writer out) {
        try {
            return StaxUtils.getXMLOutputFactory().createXMLStreamWriter(out);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Cant' create XMLStreamWriter", e);
        }
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out) {
        return StaxUtils.createXMLStreamWriter(out, null);
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out, String encoding) {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            return StaxUtils.getXMLOutputFactory().createXMLStreamWriter(out, encoding);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Cant' create XMLStreamWriter", e);
        }
    }

    public static XMLStreamWriter createXMLStreamWriter(Result r) {
        try {
            return StaxUtils.getXMLOutputFactory().createXMLStreamWriter(r);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Cant' create XMLStreamWriter", e);
        }
    }

    public static XMLStreamReader createFilteredReader(XMLStreamReader reader, StreamFilter filter) {
        try {
            return StaxUtils.getXMLInputFactory().createFilteredReader(reader, filter);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Cant' create XMLStreamReader", e);
        }
    }

    public static void nextEvent(XMLStreamReader dr) {
        try {
            dr.next();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
    }

    public static boolean toNextText(DepthXMLStreamReader reader) {
        if (reader.getEventType() == 4) {
            return true;
        }
        try {
            int depth = reader.getDepth();
            int event = reader.getEventType();
            while (reader.getDepth() >= depth && reader.hasNext()) {
                if (event == 4 && reader.getDepth() == depth + 1) {
                    return true;
                }
                event = reader.next();
            }
            return false;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
    }

    public static boolean toNextTag(XMLStreamReader reader) {
        try {
            int x = reader.getEventType();
            while (x != 1 && x != 2 && reader.hasNext()) {
                x = reader.next();
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
        return true;
    }

    public static boolean toNextTag(DepthXMLStreamReader reader, QName endTag) {
        try {
            int depth = reader.getDepth();
            int event = reader.getEventType();
            while (reader.getDepth() >= depth && reader.hasNext()) {
                if (event == 1 && reader.getName().equals(endTag) && reader.getDepth() == depth + 1) {
                    return true;
                }
                event = reader.next();
            }
            return false;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
    }

    public static void writeStartElement(XMLStreamWriter writer, String prefix, String name, String namespace) throws XMLStreamException {
        if (prefix == null) {
            prefix = "";
        }
        if (namespace.length() > 0) {
            writer.writeStartElement(prefix, name, namespace);
            if (prefix.length() > 0) {
                writer.writeNamespace(prefix, namespace);
            } else {
                writer.writeDefaultNamespace(namespace);
            }
        } else {
            writer.writeStartElement(name);
            writer.writeDefaultNamespace("");
        }
    }

    public static boolean skipToStartOfElement(XMLStreamReader in) throws XMLStreamException {
        int code = in.getEventType();
        while (code != 8) {
            if (code == 1) {
                return true;
            }
            code = in.next();
        }
        return false;
    }

    public static boolean toNextElement(DepthXMLStreamReader dr) {
        if (dr.getEventType() == 1) {
            return true;
        }
        if (dr.getEventType() == 2) {
            return false;
        }
        try {
            int depth = dr.getDepth();
            int event = dr.getEventType();
            while (dr.getDepth() >= depth && dr.hasNext()) {
                if (event == 1 && dr.getDepth() == depth + 1) {
                    return true;
                }
                if (event == 2) {
                    --depth;
                }
                event = dr.next();
            }
            return false;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
    }

    public static boolean skipToStartOfElement(DepthXMLStreamReader in) throws XMLStreamException {
        int code = in.getEventType();
        while (code != 8) {
            if (code == 1) {
                return true;
            }
            code = in.next();
        }
        return false;
    }

    public static void copy(Source source, XMLStreamWriter writer) throws XMLStreamException {
        InputSource src;
        if (source instanceof SAXSource && (src = ((SAXSource)source).getInputSource()).getByteStream() == null && src.getCharacterStream() == null && src.getSystemId() == null && src.getPublicId() == null && ((SAXSource)source).getXMLReader() != null) {
            StreamWriterContentHandler ch = new StreamWriterContentHandler(writer);
            XMLReader reader = ((SAXSource)source).getXMLReader();
            reader.setContentHandler(ch);
            try {
                reader.parse(((SAXSource)source).getInputSource());
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new XMLStreamException(e);
            }
        }
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(source);
        StaxUtils.copy(reader, writer);
        reader.close();
    }

    public static Document copy(Document doc) throws XMLStreamException, ParserConfigurationException {
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(doc);
        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
        StaxUtils.copy(reader, (XMLStreamWriter)writer);
        Document d = writer.getDocument();
        d.setDocumentURI(doc.getDocumentURI());
        return d;
    }

    public static void copy(Document doc, XMLStreamWriter writer) throws XMLStreamException {
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(doc);
        StaxUtils.copy(reader, writer);
    }

    public static void copy(Element node, XMLStreamWriter writer) throws XMLStreamException {
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(node);
        StaxUtils.copy(reader, writer);
    }

    public static void copy(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        StaxUtils.copy(reader, writer, false);
    }

    public static void copy(XMLStreamReader reader, XMLStreamWriter writer, boolean fragment) throws XMLStreamException {
        int read = 0;
        int event = reader.getEventType();
        while (reader.hasNext()) {
            switch (event) {
                case 1: {
                    ++read;
                    StaxUtils.writeStartElement(reader, writer);
                    break;
                }
                case 2: {
                    writer.writeEndElement();
                    if (--read > 0 || fragment) break;
                    return;
                }
                case 4: {
                    writer.writeCharacters(reader.getText());
                    break;
                }
                case 5: {
                    writer.writeComment(reader.getText());
                    break;
                }
                case 12: {
                    writer.writeCData(reader.getText());
                    break;
                }
                case 7: 
                case 8: 
                case 10: 
                case 13: {
                    break;
                }
            }
            event = reader.next();
        }
    }

    private static void writeStartElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        String nsPrefix;
        int i;
        String boundPrefix;
        String local = reader.getLocalName();
        String uri = reader.getNamespaceURI();
        String prefix = reader.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        boolean writeElementNS = false;
        if (!(uri == null || (boundPrefix = writer.getPrefix(uri)) != null && prefix.equals(boundPrefix))) {
            writeElementNS = true;
        }
        if (uri != null) {
            if (prefix.length() == 0 && StringUtils.isEmpty(uri)) {
                writer.writeStartElement(local);
                writer.setDefaultNamespace(uri);
            } else {
                writer.writeStartElement(prefix, local, uri);
                writer.setPrefix(prefix, uri);
            }
        } else {
            writer.writeStartElement(local);
        }
        for (i = 0; i < reader.getNamespaceCount(); ++i) {
            String nsURI = reader.getNamespaceURI(i);
            nsPrefix = reader.getNamespacePrefix(i);
            if (nsPrefix == null) {
                nsPrefix = "";
            }
            if (nsPrefix.length() == 0) {
                writer.writeDefaultNamespace(nsURI);
            } else {
                writer.writeNamespace(nsPrefix, nsURI);
            }
            if (!nsURI.equals(uri) || !nsPrefix.equals(prefix)) continue;
            writeElementNS = false;
        }
        if (writeElementNS) {
            if (prefix == null || prefix.length() == 0) {
                writer.writeDefaultNamespace(uri);
            } else {
                writer.writeNamespace(prefix, uri);
            }
        }
        for (i = 0; i < reader.getAttributeCount(); ++i) {
            String ns = reader.getAttributeNamespace(i);
            nsPrefix = reader.getAttributePrefix(i);
            if (ns == null || ns.length() == 0) {
                writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            if (nsPrefix == null || nsPrefix.length() == 0) {
                writer.writeAttribute(reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            writer.writeAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
    }

    public static void writeDocument(Document d, XMLStreamWriter writer, boolean repairing) throws XMLStreamException {
        StaxUtils.writeDocument(d, writer, true, repairing);
    }

    public static void writeDocument(Document d, XMLStreamWriter writer, boolean writeProlog, boolean repairing) throws XMLStreamException {
        if (writeProlog) {
            writer.writeStartDocument();
        }
        for (Node node = d.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!writeProlog && node.getNodeType() != 1) continue;
            StaxUtils.writeNode(node, writer, repairing);
        }
        if (writeProlog) {
            writer.writeEndDocument();
        }
    }

    public static void writeElement(Element e, XMLStreamWriter writer, boolean repairing) throws XMLStreamException {
        StaxUtils.writeElement(e, writer, repairing, true);
    }

    public static void writeElement(Element e, XMLStreamWriter writer, boolean repairing, boolean endElement) throws XMLStreamException {
        boolean declareNamespace;
        String prefix = e.getPrefix();
        String ns = e.getNamespaceURI();
        String localName = e.getLocalName();
        if (prefix == null) {
            prefix = "";
        }
        if (localName == null && (localName = e.getNodeName()) == null) {
            throw new IllegalStateException("Element's local name cannot be null!");
        }
        String decUri = writer.getNamespaceContext().getNamespaceURI(prefix);
        boolean bl = declareNamespace = decUri == null || !decUri.equals(ns);
        if (ns == null || ns.length() == 0) {
            writer.writeStartElement(localName);
            if (StringUtils.isEmpty(decUri)) {
                declareNamespace = false;
            }
        } else {
            writer.writeStartElement(prefix, localName, ns);
        }
        NamedNodeMap attrs = e.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getLocalName();
            String attrPrefix = attr.getPrefix();
            if (attrPrefix == null) {
                attrPrefix = "";
            }
            if (name == null) {
                name = attr.getNodeName();
            }
            if ("xmlns".equals(attrPrefix)) {
                writer.writeNamespace(name, attr.getNodeValue());
                if (!name.equals(prefix) || !attr.getNodeValue().equals(ns)) continue;
                declareNamespace = false;
                continue;
            }
            if ("xmlns".equals(name) && "".equals(attrPrefix)) {
                writer.writeNamespace("", attr.getNodeValue());
                if (attr.getNodeValue().equals(ns)) {
                    declareNamespace = false;
                    continue;
                }
                if (!StringUtils.isEmpty(attr.getNodeValue()) || !StringUtils.isEmpty(ns)) continue;
                declareNamespace = false;
                continue;
            }
            String attns = attr.getNamespaceURI();
            String value = attr.getNodeValue();
            if (attns == null || attns.length() == 0) {
                writer.writeAttribute(name, value);
                continue;
            }
            if (attrPrefix == null || attrPrefix.length() == 0) {
                writer.writeAttribute(attns, name, value);
                continue;
            }
            writer.writeAttribute(attrPrefix, attns, name, value);
        }
        if (declareNamespace && repairing) {
            if (ns == null) {
                writer.writeNamespace(prefix, "");
            } else {
                writer.writeNamespace(prefix, ns);
            }
        }
        for (Node nd = e.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            StaxUtils.writeNode(nd, writer, repairing);
        }
        if (endElement) {
            writer.writeEndElement();
        }
    }

    public static void writeNode(Node n, XMLStreamWriter writer, boolean repairing) throws XMLStreamException {
        switch (n.getNodeType()) {
            case 1: {
                StaxUtils.writeElement((Element)n, writer, repairing);
                break;
            }
            case 3: {
                writer.writeCharacters(((Text)n).getNodeValue());
                break;
            }
            case 8: {
                writer.writeComment(((Comment)n).getData());
                break;
            }
            case 4: {
                writer.writeCData(((CDATASection)n).getData());
                break;
            }
            case 5: {
                writer.writeEntityRef(((org.w3c.dom.EntityReference)n).getNodeValue());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)n;
                writer.writeProcessingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            case 9: {
                StaxUtils.writeDocument((Document)n, writer, repairing);
                break;
            }
            case 11: {
                DocumentFragment frag = (DocumentFragment)n;
                for (Node child = frag.getFirstChild(); child != null; child = child.getNextSibling()) {
                    StaxUtils.writeNode(child, writer, repairing);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Found type: " + n.getClass().getName());
            }
        }
    }

    public static Document read(XMLStreamReader reader) throws XMLStreamException {
        Document doc = DOMUtils.createDocument();
        StaxUtils.readDocElements(doc, reader, true);
        return doc;
    }

    public static Document read(DocumentBuilder builder, XMLStreamReader reader, boolean repairing) throws XMLStreamException {
        Document doc = builder.newDocument();
        StaxUtils.readDocElements(doc, reader, repairing);
        return doc;
    }

    private static Document getDocument(Node parent) {
        return parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
    }

    private static Element startElement(Node parent, XMLStreamReader reader, boolean repairing) throws XMLStreamException {
        String prefix;
        Document doc = StaxUtils.getDocument(parent);
        Element e = doc.createElementNS(reader.getNamespaceURI(), reader.getLocalName());
        if (reader.getPrefix() != null) {
            e.setPrefix(reader.getPrefix());
        }
        e = (Element)parent.appendChild(e);
        for (int ns = 0; ns < reader.getNamespaceCount(); ++ns) {
            String uri = reader.getNamespaceURI(ns);
            prefix = reader.getNamespacePrefix(ns);
            StaxUtils.declare(e, uri, prefix);
        }
        for (int att = 0; att < reader.getAttributeCount(); ++att) {
            String name = reader.getAttributeLocalName(att);
            prefix = reader.getAttributePrefix(att);
            if (prefix != null && prefix.length() > 0) {
                name = prefix + ":" + name;
            }
            Attr attr = doc.createAttributeNS(reader.getAttributeNamespace(att), name);
            attr.setValue(reader.getAttributeValue(att));
            e.setAttributeNode(attr);
        }
        if (repairing && !StaxUtils.isDeclared(e, reader.getNamespaceURI(), reader.getPrefix())) {
            StaxUtils.declare(e, reader.getNamespaceURI(), reader.getPrefix());
        }
        reader.next();
        StaxUtils.readDocElements(e, reader, repairing);
        return e;
    }

    private static boolean isDeclared(Element e, String namespaceURI, String prefix) {
        Attr att = prefix != null && prefix.length() > 0 ? e.getAttributeNodeNS(XML_NS, prefix) : e.getAttributeNode("xmlns");
        if (att != null && att.getNodeValue().equals(namespaceURI)) {
            return true;
        }
        if (e.getParentNode() instanceof Element) {
            return StaxUtils.isDeclared((Element)e.getParentNode(), namespaceURI, prefix);
        }
        return false;
    }

    public static void readDocElements(Node parent, XMLStreamReader reader, boolean repairing) throws XMLStreamException {
        Document doc = StaxUtils.getDocument(parent);
        int event = reader.getEventType();
        while (reader.hasNext()) {
            switch (event) {
                case 1: {
                    StaxUtils.startElement(parent, reader, repairing);
                    if (!(parent instanceof Document)) break;
                    return;
                }
                case 2: {
                    return;
                }
                case 13: {
                    break;
                }
                case 10: {
                    break;
                }
                case 4: {
                    if (parent == null) break;
                    parent.appendChild(doc.createTextNode(reader.getText()));
                    break;
                }
                case 5: {
                    if (parent == null) break;
                    parent.appendChild(doc.createComment(reader.getText()));
                    break;
                }
                case 12: {
                    parent.appendChild(doc.createCDATASection(reader.getText()));
                    break;
                }
                case 3: {
                    parent.appendChild(doc.createProcessingInstruction(reader.getPITarget(), reader.getPIData()));
                    break;
                }
                case 9: {
                    parent.appendChild(doc.createProcessingInstruction(reader.getPITarget(), reader.getPIData()));
                    break;
                }
            }
            if (!reader.hasNext()) continue;
            event = reader.next();
        }
    }

    private static void declare(Element node, String uri, String prefix) {
        String qualname = prefix != null && prefix.length() > 0 ? "xmlns:" + prefix : "xmlns";
        Attr attr = node.getOwnerDocument().createAttributeNS(XML_NS, qualname);
        attr.setValue(uri);
        node.setAttributeNodeNS(attr);
    }

    public static XMLStreamReader createXMLStreamReader(InputStream in, String encoding) {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            return StaxUtils.getXMLInputFactory().createXMLStreamReader(in, encoding);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
    }

    public static XMLStreamReader createXMLStreamReader(InputStream in) {
        try {
            return StaxUtils.getXMLInputFactory().createXMLStreamReader(in);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
    }

    public static XMLStreamReader createXMLStreamReader(String systemId, InputStream in) {
        try {
            return StaxUtils.getXMLInputFactory().createXMLStreamReader(systemId, in);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
    }

    public static XMLStreamReader createXMLStreamReader(Element el) {
        return new W3CDOMStreamReader(el);
    }

    public static XMLStreamReader createXMLStreamReader(Document doc) {
        return new W3CDOMStreamReader(doc.getDocumentElement());
    }

    public static XMLStreamReader createXMLStreamReader(Source source) {
        try {
            if (source instanceof DOMSource) {
                DOMSource ds = (DOMSource)source;
                Node nd = ds.getNode();
                Element el = null;
                if (nd instanceof Document) {
                    el = ((Document)nd).getDocumentElement();
                } else if (nd instanceof Element) {
                    el = (Element)nd;
                }
                if (null != el) {
                    return new W3CDOMStreamReader(el);
                }
            }
            return StaxUtils.getXMLInputFactory().createXMLStreamReader(source);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
    }

    public static XMLStreamReader createXMLStreamReader(Reader reader) {
        try {
            return StaxUtils.getXMLInputFactory().createXMLStreamReader(reader);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
    }

    public static QName readQName(XMLStreamReader reader) throws XMLStreamException {
        String value = reader.getElementText();
        if (value == null) {
            return null;
        }
        int index = value.indexOf(":");
        if (index == -1) {
            return new QName(value);
        }
        String prefix = value.substring(0, index);
        String localName = value.substring(index + 1);
        String ns = reader.getNamespaceURI(prefix);
        if (prefix != null && ns == null || localName == null) {
            throw new RuntimeException("Invalid QName in mapping: " + value);
        }
        if (ns == null) {
            return new QName(localName);
        }
        return new QName(ns, localName, prefix);
    }

    public static String getUniquePrefix(XMLStreamWriter writer, String namespaceURI, boolean declare) throws XMLStreamException {
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = StaxUtils.getUniquePrefix(writer);
            if (declare) {
                writer.setPrefix(prefix, namespaceURI);
                writer.writeNamespace(prefix, namespaceURI);
            }
        }
        return prefix;
    }

    public static String getUniquePrefix(XMLStreamWriter writer) {
        int n = 1;
        NamespaceContext nc = writer.getNamespaceContext();
        while (true) {
            String nsPrefix = "ns" + n;
            if (nc == null || nc.getNamespaceURI(nsPrefix) == null) {
                return nsPrefix;
            }
            ++n;
        }
    }

    public static void printXmlFragment(XMLStreamReader reader) {
        try {
            LOG.info(XMLUtils.toString(StaxUtils.read(reader), 4));
        }
        catch (XMLStreamException e) {
            LOG.severe(e.getMessage());
        }
    }

    private static void writeStartElementEvent(XMLEvent event, XMLStreamWriter writer) throws XMLStreamException {
        StartElement start = event.asStartElement();
        QName name = start.getName();
        String nsURI = name.getNamespaceURI();
        String localName = name.getLocalPart();
        String prefix = name.getPrefix();
        if (prefix != null) {
            writer.writeStartElement(prefix, localName, nsURI);
        } else if (nsURI != null) {
            writer.writeStartElement(localName, nsURI);
        } else {
            writer.writeStartElement(localName);
        }
        Iterator<Attribute> it = start.getNamespaces();
        while (it != null && it.hasNext()) {
            StaxUtils.writeEvent(it.next(), writer);
        }
        it = start.getAttributes();
        while (it != null && it.hasNext()) {
            StaxUtils.writeAttributeEvent(it.next(), writer);
        }
    }

    private static void writeAttributeEvent(XMLEvent event, XMLStreamWriter writer) throws XMLStreamException {
        Attribute attr = (Attribute)event;
        QName name = attr.getName();
        String nsURI = name.getNamespaceURI();
        String localName = name.getLocalPart();
        String prefix = name.getPrefix();
        String value = attr.getValue();
        if (prefix != null) {
            writer.writeAttribute(prefix, nsURI, localName, value);
        } else if (nsURI != null) {
            writer.writeAttribute(nsURI, localName, value);
        } else {
            writer.writeAttribute(localName, value);
        }
    }

    public static void writeEvent(XMLEvent event, XMLStreamWriter writer) throws XMLStreamException {
        switch (event.getEventType()) {
            case 1: {
                StaxUtils.writeStartElementEvent(event, writer);
                break;
            }
            case 2: {
                writer.writeEndElement();
                break;
            }
            case 10: {
                StaxUtils.writeAttributeEvent(event, writer);
                break;
            }
            case 9: {
                writer.writeEntityRef(((EntityReference)event).getName());
                break;
            }
            case 11: {
                writer.writeDTD(((DTD)event).getDocumentTypeDeclaration());
                break;
            }
            case 3: {
                if (((javax.xml.stream.events.ProcessingInstruction)event).getData() != null) {
                    writer.writeProcessingInstruction(((javax.xml.stream.events.ProcessingInstruction)event).getTarget(), ((javax.xml.stream.events.ProcessingInstruction)event).getData());
                    break;
                }
                writer.writeProcessingInstruction(((javax.xml.stream.events.ProcessingInstruction)event).getTarget());
                break;
            }
            case 13: {
                if (((Namespace)event).isDefaultNamespaceDeclaration()) {
                    writer.writeDefaultNamespace(((Namespace)event).getNamespaceURI());
                    break;
                }
                writer.writeNamespace(((Namespace)event).getPrefix(), ((Namespace)event).getNamespaceURI());
                break;
            }
            case 5: {
                writer.writeComment(((javax.xml.stream.events.Comment)event).getText());
                break;
            }
            case 4: 
            case 6: {
                writer.writeCharacters(event.asCharacters().getData());
                break;
            }
            case 12: {
                writer.writeCData(event.asCharacters().getData());
                break;
            }
            case 7: {
                if (((StartDocument)event).encodingSet()) {
                    writer.writeStartDocument(((StartDocument)event).getCharacterEncodingScheme(), ((StartDocument)event).getVersion());
                    break;
                }
                writer.writeStartDocument(((StartDocument)event).getVersion());
                break;
            }
            case 8: {
                writer.writeEndDocument();
                break;
            }
        }
    }

    static {
        try {
            XML_INPUT_FACTORY.setProperty("javax.xml.stream.isNamespaceAware", false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            XML_NS_AWARE_INPUT_FACTORY.setProperty("javax.xml.stream.isNamespaceAware", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

